/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.util.Vector;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    private void ensureAvailable(int n3) {
        int n4 = this.lookupPowX2.size();
        if (n4 <= n3) {
            long[] lArray = (long[])this.lookupPowX2.elementAt(n4 - 1);
            do {
                lArray = Arrays.clone(lArray);
                GCMUtil.square(lArray, lArray);
                this.lookupPowX2.addElement(lArray);
            } while (++n4 <= n3);
        }
    }

    @Override
    public void init(byte[] objectArray) {
        Vector vector;
        objectArray = GCMUtil.asLongs(objectArray);
        Vector vector2 = this.lookupPowX2;
        if (vector2 != null && Arrays.areEqual((long[])objectArray, (long[])vector2.elementAt(0))) {
            return;
        }
        vector2 = vector;
        vector2(8);
        this.lookupPowX2 = vector2;
        vector.addElement(objectArray);
    }

    @Override
    public void exponentiateX(long l3, byte[] byArray) {
        long[] lArray = GCMUtil.oneAsLongs();
        int n3 = 0;
        while (l3 > 0L) {
            if ((l3 & 1L) != 0L) {
                Tables1kGCMExponentiator tables1kGCMExponentiator = this;
                tables1kGCMExponentiator.ensureAvailable(n3);
                GCMUtil.multiply(lArray, (long[])tables1kGCMExponentiator.lookupPowX2.elementAt(n3));
            }
            ++n3;
            l3 >>>= 1;
        }
        GCMUtil.asBytes(lArray, byArray);
    }
}

