/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    @Override
    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[16][256][2];
        } else if (Arrays.areEqual(this.H, byArray)) {
            return;
        }
        this.H = Arrays.clone(byArray);
        for (int i3 = 0; i3 < 16; ++i3) {
            long[][][] lArray = this.T;
            long[][] lArray2 = this.T[i3];
            if (i3 == 0) {
                GCMUtil.asLongs(this.H, lArray2[1]);
                long[] lArray3 = lArray2[1];
                GCMUtil.multiplyP7(lArray3, lArray3);
            } else {
                GCMUtil.multiplyP8(lArray[i3 - 1][1], lArray2[1]);
            }
            for (int i4 = 2; i4 < 256; i4 += 2) {
                GCMUtil.divideP(lArray2[i4 >> 1], lArray2[i4]);
                long[] lArray4 = lArray2[1];
                GCMUtil.xor(lArray2[i4], lArray4, lArray2[i4 + 1]);
            }
        }
    }

    @Override
    public void multiplyH(byte[] byArray) {
        long[] lArray = this.T[15][byArray[15] & 0xFF];
        long l3 = lArray[0];
        long l4 = lArray[1];
        for (int i3 = 14; i3 >= 0; --i3) {
            long[] lArray2 = this.T[i3][byArray[i3] & 0xFF];
            l3 ^= lArray2[0];
            l4 ^= lArray2[1];
        }
        Pack.longToBigEndian(l3, byArray, 0);
        Pack.longToBigEndian(l4, byArray, 8);
    }
}

