/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.gcm.GCMUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;

public class Tables8kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    @Override
    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[32][16][2];
        } else if (Arrays.areEqual(this.H, byArray)) {
            return;
        }
        this.H = Arrays.clone(byArray);
        for (int i3 = 0; i3 < 32; ++i3) {
            long[][][] lArray = this.T;
            long[][] lArray2 = this.T[i3];
            if (i3 == 0) {
                GCMUtil.asLongs(this.H, lArray2[1]);
                long[] lArray3 = lArray2[1];
                GCMUtil.multiplyP3(lArray3, lArray3);
            } else {
                GCMUtil.multiplyP4(lArray[i3 - 1][1], lArray2[1]);
            }
            for (int i4 = 2; i4 < 16; i4 += 2) {
                GCMUtil.divideP(lArray2[i4 >> 1], lArray2[i4]);
                long[] lArray4 = lArray2[1];
                GCMUtil.xor(lArray2[i4], lArray4, lArray2[i4 + 1]);
            }
        }
    }

    @Override
    public void multiplyH(byte[] byArray) {
        long l3 = 0L;
        long l4 = 0L;
        for (int i3 = 15; i3 >= 0; --i3) {
            long[][][] lArray = this.T;
            int n3 = i3;
            int n4 = n3 + n3;
            byte by = byArray[i3];
            long[] lArray2 = this.T[n4 + 1][by & 0xF];
            long[] lArray3 = lArray[n4][(by & 0xF0) >>> 4];
            long l5 = l3 ^ (lArray2[0] ^ lArray3[0]);
            long l6 = l4 ^ (lArray2[1] ^ lArray3[1]);
            l4 = l6;
            l3 = l5;
        }
        Pack.longToBigEndian(l3, byArray, 0);
        Pack.longToBigEndian(l4, byArray, 8);
    }
}

