/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class ISO10126d2Padding
implements BlockCipherPadding {
    public SecureRandom random;

    @Override
    public void init(SecureRandom secureRandom) {
        this.random = CryptoServicesRegistrar.getSecureRandom(secureRandom);
    }

    @Override
    public String getPaddingName() {
        return "ISO10126-2";
    }

    @Override
    public int addPadding(byte[] byArray, int n3) {
        byte by = (byte)(byArray.length - n3);
        while (n3 < byArray.length - 1) {
            byArray[n3] = (byte)this.random.nextInt();
            ++n3;
        }
        byArray[n3] = by;
        return by;
    }

    @Override
    public int padCount(byte[] byArray) {
        int n3 = byArray[byArray.length - 1] & 0xFF;
        if (n3 <= byArray.length) {
            return n3;
        }
        throw new InvalidCipherTextException("pad block corrupted");
    }
}

