/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class ISO7816d4Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom secureRandom) {
    }

    @Override
    public String getPaddingName() {
        return "ISO7816-4";
    }

    @Override
    public int addPadding(byte[] byArray, int n3) {
        int n4 = byArray.length - n3;
        byArray[n3] = -128;
        ++n3;
        while (n3 < byArray.length) {
            byArray[n3] = 0;
            ++n3;
        }
        return n4;
    }

    @Override
    public int padCount(byte[] byArray) {
        int n3;
        for (n3 = byArray.length - 1; n3 > 0 && byArray[n3] == 0; --n3) {
        }
        if (byArray[n3] == -128) {
            return byArray.length - n3;
        }
        throw new InvalidCipherTextException("pad block corrupted");
    }
}

