/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class PKCS7Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom secureRandom) {
    }

    @Override
    public String getPaddingName() {
        return "PKCS7";
    }

    @Override
    public int addPadding(byte[] byArray, int n3) {
        byte by = (byte)(byArray.length - n3);
        while (n3 < byArray.length) {
            byArray[n3] = by;
            ++n3;
        }
        return by;
    }

    @Override
    public int padCount(byte[] byArray) {
        int n3 = byArray[byArray.length - 1] & 0xFF;
        byte by = (byte)n3;
        boolean bl = n3 > byArray.length;
        int n4 = n3 == 0 ? 1 : 0;
        bl |= n4;
        for (n4 = 0; n4 < byArray.length; ++n4) {
            boolean bl2 = byArray.length - n4 <= n3;
            boolean bl3 = byArray[n4] != by;
            bl |= bl2 & bl3;
        }
        if (!bl) {
            return n3;
        }
        throw new InvalidCipherTextException("pad block corrupted");
    }
}

