/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class X923Padding
implements BlockCipherPadding {
    public SecureRandom random = null;

    @Override
    public void init(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    @Override
    public String getPaddingName() {
        return "X9.23";
    }

    @Override
    public int addPadding(byte[] byArray, int n3) {
        byte by = (byte)(byArray.length - n3);
        while (n3 < byArray.length - 1) {
            SecureRandom secureRandom = this.random;
            byArray[n3] = secureRandom == null ? (byte)0 : (byte)secureRandom.nextInt();
            ++n3;
        }
        byArray[n3] = by;
        return by;
    }

    @Override
    public int padCount(byte[] byArray) {
        int n3 = byArray[byArray.length - 1] & 0xFF;
        if (n3 <= byArray.length) {
            return n3;
        }
        throw new InvalidCipherTextException("pad block corrupted");
    }
}

