/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CharToByteConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.PasswordConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class Argon2Parameters {
    public static final int ARGON2_d = 0;
    public static final int ARGON2_i = 1;
    public static final int ARGON2_id = 2;
    public static final int ARGON2_VERSION_10 = 16;
    public static final int ARGON2_VERSION_13 = 19;
    private static final int DEFAULT_ITERATIONS = 3;
    private static final int DEFAULT_MEMORY_COST = 12;
    private static final int DEFAULT_LANES = 1;
    private static final int DEFAULT_TYPE = 1;
    private static final int DEFAULT_VERSION = 19;
    private final byte[] salt;
    private final byte[] secret;
    private final byte[] additional;
    private final int iterations;
    private final int memory;
    private final int lanes;
    private final int version;
    private final int type;
    private final CharToByteConverter converter;

    private Argon2Parameters(int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, int n4, int n5, int n6, int n7, CharToByteConverter charToByteConverter) {
        this.salt = Arrays.clone(byArray);
        this.secret = Arrays.clone(byArray2);
        this.additional = Arrays.clone(byArray3);
        this.iterations = n4;
        this.memory = n5;
        this.lanes = n6;
        this.version = n7;
        this.type = n3;
        this.converter = charToByteConverter;
    }

    public /* synthetic */ Argon2Parameters(int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, int n4, int n5, int n6, int n7, CharToByteConverter charToByteConverter, 1 var10_10) {
        this(n3, byArray, byArray2, byArray3, n4, n5, n6, n7, charToByteConverter);
    }

    public byte[] getSalt() {
        return Arrays.clone(this.salt);
    }

    public byte[] getSecret() {
        return Arrays.clone(this.secret);
    }

    public byte[] getAdditional() {
        return Arrays.clone(this.additional);
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getMemory() {
        return this.memory;
    }

    public int getLanes() {
        return this.lanes;
    }

    public int getVersion() {
        return this.version;
    }

    public int getType() {
        return this.type;
    }

    public CharToByteConverter getCharToByteConverter() {
        return this.converter;
    }

    public void clear() {
        Argon2Parameters argon2Parameters = this;
        Arrays.clear(argon2Parameters.salt);
        Arrays.clear(argon2Parameters.secret);
        Arrays.clear(argon2Parameters.additional);
    }

    public static class Builder {
        private byte[] salt;
        private byte[] secret;
        private byte[] additional;
        private int iterations;
        private int memory;
        private int lanes;
        private int version;
        private final int type;
        private CharToByteConverter converter;

        public Builder() {
            this(1);
        }

        public Builder(int n3) {
            Builder builder = this;
            this.converter = PasswordConverter.UTF8;
            builder.type = n3;
            builder.lanes = 1;
            builder.memory = 4096;
            builder.iterations = 3;
            builder.version = 19;
        }

        public Builder withParallelism(int n3) {
            this.lanes = n3;
            return this;
        }

        public Builder withSalt(byte[] byArray) {
            this.salt = Arrays.clone(byArray);
            return this;
        }

        public Builder withSecret(byte[] byArray) {
            this.secret = Arrays.clone(byArray);
            return this;
        }

        public Builder withAdditional(byte[] byArray) {
            this.additional = Arrays.clone(byArray);
            return this;
        }

        public Builder withIterations(int n3) {
            this.iterations = n3;
            return this;
        }

        public Builder withMemoryAsKB(int n3) {
            this.memory = n3;
            return this;
        }

        public Builder withMemoryPowOfTwo(int n3) {
            this.memory = 1 << n3;
            return this;
        }

        public Builder withVersion(int n3) {
            this.version = n3;
            return this;
        }

        public Builder withCharToByteConverter(CharToByteConverter charToByteConverter) {
            this.converter = charToByteConverter;
            return this;
        }

        public Argon2Parameters build() {
            Builder builder = this;
            int n3 = builder.type;
            byte[] byArray = builder.salt;
            byte[] byArray2 = builder.secret;
            byte[] byArray3 = builder.additional;
            int n4 = builder.iterations;
            int n5 = builder.memory;
            int n6 = builder.lanes;
            int n7 = builder.version;
            CharToByteConverter charToByteConverter = builder.converter;
            return new Argon2Parameters(n3, byArray, byArray2, byArray3, n4, n5, n6, n7, charToByteConverter, null);
        }

        public void clear() {
            Builder builder = this;
            Arrays.clear(builder.salt);
            Arrays.clear(builder.secret);
            Arrays.clear(builder.additional);
        }
    }
}

