/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DESParameters;

public class DESedeParameters
extends DESParameters {
    public static final int DES_EDE_KEY_LENGTH = 24;

    public DESedeParameters(byte[] byArray) {
        super(byArray);
        if (!DESedeParameters.isWeakKey(byArray, 0, byArray.length)) {
            return;
        }
        throw new IllegalArgumentException("attempt to create weak DESede key");
    }

    public static boolean isWeakKey(byte[] byArray, int n3, int n4) {
        while (n3 < n4) {
            if (DESParameters.isWeakKey(byArray, n3)) {
                return true;
            }
            n3 += 8;
        }
        return false;
    }

    public static boolean isWeakKey(byte[] byArray, int n3) {
        return DESedeParameters.isWeakKey(byArray, n3, byArray.length - n3);
    }

    public static boolean isRealEDEKey(byte[] byArray, int n3) {
        return byArray.length == 16 ? DESedeParameters.isReal2Key(byArray, n3) : DESedeParameters.isReal3Key(byArray, n3);
    }

    public static boolean isReal2Key(byte[] byArray, int n3) {
        boolean bl = false;
        for (int i3 = n3; i3 != n3 + 8; ++i3) {
            if (byArray[i3] == byArray[i3 + 8]) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isReal3Key(byte[] byArray, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        for (int i3 = n3; i3 != n3 + 8; ++i3) {
            byte by = byArray[i3];
            byte by2 = byArray[i3 + 8];
            boolean bl3 = by != by2;
            byte by3 = by;
            bl |= bl3;
            by = byArray[i3 + 16];
            bl3 = by3 != by;
            bl2 |= bl3;
            by = by2 != by ? (byte)1 : 0;
            n4 |= by;
        }
        return bl && bl2 && n4 != 0;
    }
}

