/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public final class KDFCounterParameters
implements DerivationParameters {
    private byte[] ki;
    private byte[] fixedInputDataCounterPrefix;
    private byte[] fixedInputDataCounterSuffix;
    private int r;

    public KDFCounterParameters(byte[] byArray, byte[] byArray2, int n3) {
        this(byArray, null, byArray2, n3);
    }

    public KDFCounterParameters(byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        if (byArray != null) {
            this.ki = Arrays.clone(byArray);
            this.fixedInputDataCounterPrefix = byArray2 == null ? new byte[0] : Arrays.clone(byArray2);
            this.fixedInputDataCounterSuffix = byArray3 == null ? new byte[0] : Arrays.clone(byArray3);
            if (n3 != 8 && n3 != 16 && n3 != 24 && n3 != 32) {
                throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
            }
            this.r = n3;
            return;
        }
        throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
    }

    public byte[] getKI() {
        return this.ki;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.fixedInputDataCounterSuffix);
    }

    public byte[] getFixedInputDataCounterPrefix() {
        return Arrays.clone(this.fixedInputDataCounterPrefix);
    }

    public byte[] getFixedInputDataCounterSuffix() {
        return Arrays.clone(this.fixedInputDataCounterSuffix);
    }

    public int getR() {
        return this.r;
    }
}

