/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public final class KDFDoublePipelineIterationParameters
implements DerivationParameters {
    private static final int UNUSED_R = 32;
    private final byte[] ki;
    private final boolean useCounter;
    private final int r;
    private final byte[] fixedInputData;

    private KDFDoublePipelineIterationParameters(byte[] byArray, byte[] byArray2, int n3, boolean bl) {
        if (byArray != null) {
            this.ki = Arrays.clone(byArray);
            this.fixedInputData = byArray2 == null ? new byte[0] : Arrays.clone(byArray2);
            if (n3 != 8 && n3 != 16 && n3 != 24 && n3 != 32) {
                throw new IllegalArgumentException("Length of counter should be 8, 16, 24 or 32");
            }
            KDFDoublePipelineIterationParameters kDFDoublePipelineIterationParameters = this;
            kDFDoublePipelineIterationParameters.r = n3;
            kDFDoublePipelineIterationParameters.useCounter = bl;
            return;
        }
        throw new IllegalArgumentException("A KDF requires Ki (a seed) as input");
    }

    public static KDFDoublePipelineIterationParameters createWithCounter(byte[] byArray, byte[] byArray2, int n3) {
        return new KDFDoublePipelineIterationParameters(byArray, byArray2, n3, true);
    }

    public static KDFDoublePipelineIterationParameters createWithoutCounter(byte[] byArray, byte[] byArray2) {
        return new KDFDoublePipelineIterationParameters(byArray, byArray2, 32, false);
    }

    public byte[] getKI() {
        return this.ki;
    }

    public boolean useCounter() {
        return this.useCounter;
    }

    public int getR() {
        return this.r;
    }

    public byte[] getFixedInputData() {
        return Arrays.clone(this.fixedInputData);
    }
}

