/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSAKeyGenerationParameters
extends KeyGenerationParameters {
    private BigInteger publicExponent;
    private int certainty;

    public RSAKeyGenerationParameters(BigInteger bigInteger, SecureRandom secureRandom, int n3, int n4) {
        super(secureRandom, n3);
        if (n3 >= 12) {
            if (bigInteger.testBit(0)) {
                RSAKeyGenerationParameters rSAKeyGenerationParameters = this;
                rSAKeyGenerationParameters.publicExponent = bigInteger;
                rSAKeyGenerationParameters.certainty = n4;
                return;
            }
            throw new IllegalArgumentException("public exponent cannot be even");
        }
        throw new IllegalArgumentException("key strength too small");
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public int getCertainty() {
        return this.certainty;
    }
}

