/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748.X25519;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.InputStream;
import java.security.SecureRandom;

public final class X25519PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 32;
    public static final int SECRET_SIZE = 32;
    private final byte[] data;

    public X25519PrivateKeyParameters(SecureRandom secureRandom) {
        super(true);
        byte[] byArray = new byte[32];
        Object object = byArray;
        v1.data = byArray;
        X25519.generatePrivateKey(secureRandom, (byte[])object);
    }

    public X25519PrivateKeyParameters(byte[] byArray, int n3) {
        super(true);
        byte[] byArray2 = new byte[32];
        Object object = byArray2;
        v1.data = byArray2;
        System.arraycopy(byArray, n3, object, 0, 32);
    }

    public X25519PrivateKeyParameters(InputStream object) {
        InputStream inputStream = object;
        super(true);
        byte[] byArray = new byte[32];
        object = byArray;
        this.data = byArray;
        if (32 == Streams.readFully(inputStream, (byte[])object)) {
            return;
        }
        throw new EOFException("EOF encountered in middle of X25519 private key");
    }

    public void encode(byte[] byArray, int n3) {
        System.arraycopy(this.data, 0, byArray, n3, 32);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public X25519PublicKeyParameters generatePublicKey() {
        X25519PrivateKeyParameters x25519PrivateKeyParameters = object;
        Object object = new byte[32];
        X25519.generatePublicKey(x25519PrivateKeyParameters.data, 0, (byte[])object, 0);
        return new X25519PublicKeyParameters((byte[])object, 0);
    }

    public void generateSecret(X25519PublicKeyParameters x25519PublicKeyParameters, byte[] byArray, int n3) {
        X25519PrivateKeyParameters x25519PrivateKeyParameters = object;
        byte[] byArray2 = new byte[32];
        Object object = byArray2;
        x25519PublicKeyParameters.encode(byArray2, 0);
        if (X25519.calculateAgreement(x25519PrivateKeyParameters.data, 0, (byte[])object, 0, byArray, n3)) {
            return;
        }
        throw new IllegalStateException("X25519 agreement failed");
    }
}

