/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X448PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc7748.X448;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.InputStream;
import java.security.SecureRandom;

public final class X448PrivateKeyParameters
extends AsymmetricKeyParameter {
    public static final int KEY_SIZE = 56;
    public static final int SECRET_SIZE = 56;
    private final byte[] data;

    public X448PrivateKeyParameters(SecureRandom secureRandom) {
        super(true);
        byte[] byArray = new byte[56];
        Object object = byArray;
        v1.data = byArray;
        X448.generatePrivateKey(secureRandom, (byte[])object);
    }

    public X448PrivateKeyParameters(byte[] byArray, int n3) {
        super(true);
        byte[] byArray2 = new byte[56];
        Object object = byArray2;
        v1.data = byArray2;
        System.arraycopy(byArray, n3, object, 0, 56);
    }

    public X448PrivateKeyParameters(InputStream object) {
        InputStream inputStream = object;
        super(true);
        byte[] byArray = new byte[56];
        object = byArray;
        this.data = byArray;
        if (56 == Streams.readFully(inputStream, (byte[])object)) {
            return;
        }
        throw new EOFException("EOF encountered in middle of X448 private key");
    }

    public void encode(byte[] byArray, int n3) {
        System.arraycopy(this.data, 0, byArray, n3, 56);
    }

    public byte[] getEncoded() {
        return Arrays.clone(this.data);
    }

    public X448PublicKeyParameters generatePublicKey() {
        X448PrivateKeyParameters x448PrivateKeyParameters = object;
        Object object = new byte[56];
        X448.generatePublicKey(x448PrivateKeyParameters.data, 0, (byte[])object, 0);
        return new X448PublicKeyParameters((byte[])object, 0);
    }

    public void generateSecret(X448PublicKeyParameters x448PublicKeyParameters, byte[] byArray, int n3) {
        X448PrivateKeyParameters x448PrivateKeyParameters = object;
        byte[] byArray2 = new byte[56];
        Object object = byArray2;
        x448PublicKeyParameters.encode(byArray2, 0);
        if (X448.calculateAgreement(x448PrivateKeyParameters.data, 0, (byte[])object, 0, byArray, n3)) {
            return;
        }
        throw new IllegalStateException("X448 agreement failed");
    }
}

