/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySource;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySourceProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.SP800SecureRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.X931SecureRandom;
import java.security.SecureRandom;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom secureRandom, boolean bl) {
        this._sr = secureRandom;
        this._predictionResistant = bl;
    }

    @Override
    public EntropySource get(final int n3) {
        return new EntropySource(){

            @Override
            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                if (!(BasicEntropySourceProvider.this._sr instanceof SP800SecureRandom) && !(BasicEntropySourceProvider.this._sr instanceof X931SecureRandom)) {
                    return BasicEntropySourceProvider.this._sr.generateSeed((n3 + 7) / 8);
                }
                byte[] byArray = new byte[(n3 + 7) / 8];
                BasicEntropySourceProvider.this._sr.nextBytes(byArray);
                return byArray;
            }

            @Override
            public int entropySize() {
                return n3;
            }
        };
    }
}

