/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.RandomGenerator;

public class DigestRandomGenerator
implements RandomGenerator {
    private static long CYCLE_COUNT = 10L;
    private long stateCounter;
    private long seedCounter;
    private Digest digest;
    private byte[] state;
    private byte[] seed;

    public DigestRandomGenerator(Digest digest) {
        DigestRandomGenerator digestRandomGenerator = this;
        DigestRandomGenerator digestRandomGenerator2 = this;
        this.digest = digest;
        digestRandomGenerator2.seed = new byte[digest.getDigestSize()];
        digestRandomGenerator2.seedCounter = 1L;
        digestRandomGenerator.state = new byte[digest.getDigestSize()];
        digestRandomGenerator.stateCounter = 1L;
    }

    private void cycleSeed() {
        DigestRandomGenerator digestRandomGenerator = this;
        digestRandomGenerator.digestUpdate(digestRandomGenerator.seed);
        long l3 = digestRandomGenerator.seedCounter;
        digestRandomGenerator.seedCounter = l3 + 1L;
        digestRandomGenerator.digestAddCounter(l3);
        digestRandomGenerator.digestDoFinal(digestRandomGenerator.seed);
    }

    private void generateState() {
        DigestRandomGenerator digestRandomGenerator = this;
        long l3 = digestRandomGenerator.stateCounter;
        digestRandomGenerator.stateCounter = l3 + 1L;
        digestRandomGenerator.digestAddCounter(l3);
        digestRandomGenerator.digestUpdate(digestRandomGenerator.state);
        digestRandomGenerator.digestUpdate(digestRandomGenerator.seed);
        digestRandomGenerator.digestDoFinal(digestRandomGenerator.state);
        if (digestRandomGenerator.stateCounter % CYCLE_COUNT == 0L) {
            this.cycleSeed();
        }
    }

    private void digestAddCounter(long l3) {
        for (int i3 = 0; i3 != 8; ++i3) {
            this.digest.update((byte)l3);
            l3 >>>= 8;
        }
    }

    private void digestUpdate(byte[] byArray) {
        this.digest.update(byArray, 0, byArray.length);
    }

    private void digestDoFinal(byte[] byArray) {
        this.digest.doFinal(byArray, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSeedMaterial(byte[] byArray) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (this) {
            digestRandomGenerator.digestUpdate(byArray);
            digestRandomGenerator.digestUpdate(digestRandomGenerator.seed);
            digestRandomGenerator.digestDoFinal(digestRandomGenerator.seed);
            // ** MonitorExit[v0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSeedMaterial(long l3) {
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (this) {
            digestRandomGenerator.digestAddCounter(l3);
            digestRandomGenerator.digestUpdate(digestRandomGenerator.seed);
            digestRandomGenerator.digestDoFinal(digestRandomGenerator.seed);
            // ** MonitorExit[v0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void nextBytes(byte[] byArray) {
        int n3 = byArray.length;
        this.nextBytes(byArray, 0, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextBytes(byte[] byArray, int n3, int n4) {
        int n5 = n4;
        DigestRandomGenerator digestRandomGenerator = this;
        synchronized (digestRandomGenerator) {
            n4 = 0;
            digestRandomGenerator.generateState();
            int n6 = n3 + n5;
            while (n3 != n6) {
                block9: {
                    if (n4 != this.state.length) break block9;
                    this.generateState();
                    n4 = 0;
                }
                byte[] byArray2 = byArray;
                int n7 = n3++;
                byte[] byArray3 = this.state;
                int n8 = n4++;
                byArray2[n7] = byArray3[n8];
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }
}

