/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.X931RNG;
import java.security.SecureRandom;

public class X931SecureRandom
extends SecureRandom {
    private final boolean predictionResistant;
    private final SecureRandom randomSource;
    private final X931RNG drbg;

    public X931SecureRandom(SecureRandom secureRandom, X931RNG x931RNG, boolean bl) {
        this.randomSource = secureRandom;
        this.drbg = x931RNG;
        this.predictionResistant = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setSeed(byte[] byArray) {
        X931SecureRandom x931SecureRandom = this;
        synchronized (x931SecureRandom) {
            SecureRandom secureRandom = x931SecureRandom.randomSource;
            if (secureRandom != null) {
                secureRandom.setSeed(byArray);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setSeed(long l3) {
        X931SecureRandom x931SecureRandom = this;
        synchronized (x931SecureRandom) {
            SecureRandom secureRandom = x931SecureRandom.randomSource;
            if (secureRandom != null) {
                secureRandom.setSeed(l3);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nextBytes(byte[] byArray) {
        X931SecureRandom x931SecureRandom = this;
        synchronized (x931SecureRandom) {
            block5: {
                if (x931SecureRandom.drbg.generate(byArray, this.predictionResistant) >= 0) break block5;
                X931SecureRandom x931SecureRandom2 = this;
                x931SecureRandom2.drbg.reseed();
                x931SecureRandom2.drbg.generate(byArray, this.predictionResistant);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    @Override
    public byte[] generateSeed(int n3) {
        return EntropyUtil.generateSeed(this.drbg.getEntropySource(), n3);
    }
}

