/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySource;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.SP80090DRBG;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg.Utils;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;

public class CTRSP800DRBG
implements SP80090DRBG {
    private static final long TDEA_RESEED_MAX = 0x80000000L;
    private static final long AES_RESEED_MAX = 0x800000000000L;
    private static final int TDEA_MAX_BITS_REQUEST = 4096;
    private static final int AES_MAX_BITS_REQUEST = 262144;
    private static final byte[] K_BITS = Hex.decodeStrict("000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F");
    private EntropySource _entropySource;
    private BlockCipher _engine;
    private int _keySizeInBits;
    private int _seedLength;
    private int _securityStrength;
    private byte[] _Key;
    private byte[] _V;
    private long _reseedCounter = 0L;
    private boolean _isTDEA = false;

    public CTRSP800DRBG(BlockCipher blockCipher, int n3, int n4, EntropySource entropySource, byte[] byArray, byte[] byArray2) {
        this._entropySource = entropySource;
        this._engine = blockCipher;
        this._keySizeInBits = n3;
        this._securityStrength = n4;
        this._seedLength = blockCipher.getBlockSize() * 8 + n3;
        this._isTDEA = this.isTDEA(blockCipher);
        if (n4 <= 256) {
            if (this.getMaxSecurityStrength(blockCipher, n3) >= n4) {
                if (entropySource.entropySize() >= n4) {
                    CTRSP800DRBG cTRSP800DRBG = this;
                    cTRSP800DRBG.CTR_DRBG_Instantiate_algorithm(cTRSP800DRBG.getEntropy(), byArray2, byArray);
                    return;
                }
                throw new IllegalArgumentException("Not enough entropy for security strength required");
            }
            throw new IllegalArgumentException("Requested security strength is not supported by block cipher and key size");
        }
        throw new IllegalArgumentException("Requested security strength is not supported by the derivation function");
    }

    private void CTR_DRBG_Instantiate_algorithm(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        CTRSP800DRBG cTRSP800DRBG = object;
        byArray = Arrays.concatenate(byArray, byArray2, byArray3);
        byArray = cTRSP800DRBG.Block_Cipher_df(byArray, cTRSP800DRBG._seedLength);
        byte[] byArray4 = new byte[(((CTRSP800DRBG)object)._keySizeInBits + 7) / 8];
        Object object = byArray4;
        v2._Key = byArray4;
        byArray2 = new byte[cTRSP800DRBG._engine.getBlockSize()];
        cTRSP800DRBG._V = byArray2;
        cTRSP800DRBG.CTR_DRBG_Update(byArray, (byte[])object, byArray2);
        cTRSP800DRBG._reseedCounter = 1L;
    }

    private void CTR_DRBG_Update(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n3;
        KeyParameter keyParameter;
        CTRSP800DRBG cTRSP800DRBG = this;
        int n4 = byArray.length;
        byte[] byArray4 = new byte[n4];
        byte[] byArray5 = new byte[cTRSP800DRBG._engine.getBlockSize()];
        int n5 = 0;
        int n6 = cTRSP800DRBG._engine.getBlockSize();
        KeyParameter keyParameter2 = keyParameter;
        keyParameter = new KeyParameter(this.expandKey(byArray2));
        cTRSP800DRBG._engine.init(true, keyParameter2);
        while ((n3 = n5 * n6) < byArray.length) {
            CTRSP800DRBG cTRSP800DRBG2 = this;
            cTRSP800DRBG2.addOneTo(byArray3);
            cTRSP800DRBG2._engine.processBlock(byArray3, 0, byArray5, 0);
            int n7 = n4 - n3;
            if (n7 > n6) {
                n7 = n6;
            }
            System.arraycopy(byArray5, 0, byArray4, n3, n7);
            ++n5;
        }
        this.XOR(byArray4, byArray, byArray4, 0);
        int n8 = byArray2.length;
        System.arraycopy(byArray4, 0, byArray2, 0, n8);
        n8 = byArray2.length;
        int n9 = byArray3.length;
        System.arraycopy(byArray4, n8, byArray3, 0, n9);
    }

    private void CTR_DRBG_Reseed_algorithm(byte[] byArray) {
        CTRSP800DRBG cTRSP800DRBG = object;
        Object object = Arrays.concatenate(cTRSP800DRBG.getEntropy(), byArray);
        object = cTRSP800DRBG.Block_Cipher_df((byte[])object, cTRSP800DRBG._seedLength);
        byArray = cTRSP800DRBG._Key;
        byte[] byArray2 = cTRSP800DRBG._V;
        cTRSP800DRBG.CTR_DRBG_Update((byte[])object, byArray, byArray2);
        cTRSP800DRBG._reseedCounter = 1L;
    }

    private void XOR(byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            byArray[i3] = (byte)(byArray2[i3] ^ byArray3[i3 + n3]);
        }
    }

    private void addOneTo(byte[] byArray) {
        int n3 = 1;
        for (int i3 = 1; i3 <= byArray.length; ++i3) {
            int n4 = (n3 = (byArray[byArray.length - i3] & 0xFF) + n3) > 255 ? 1 : 0;
            int n5 = n3;
            n3 = byArray.length - i3;
            byArray[n3] = (byte)n5;
            n3 = n4;
        }
    }

    private byte[] getEntropy() {
        byte[] byArray = this._entropySource.getEntropy();
        if (byArray.length >= (this._securityStrength + 7) / 8) {
            return byArray;
        }
        throw new IllegalStateException("Insufficient entropy provided by entropy source");
    }

    private byte[] Block_Cipher_df(byte[] byArray, int n3) {
        int n4;
        KeyParameter keyParameter;
        int n5;
        int n6;
        int n7 = n3;
        n3 = this._engine.getBlockSize();
        int n8 = byArray.length;
        int n9 = n7 / 8;
        int n10 = n8 + 8;
        byte[] byArray2 = new byte[(n10 + 1 + n3 - 1) / n3 * n3];
        Object object = byArray2;
        this.copyIntToByteArray((byte[])object, n8, 0);
        this.copyIntToByteArray((byte[])object, n9, 4);
        System.arraycopy(byArray, 0, object, 8, n8);
        byArray2[n10] = -128;
        int n11 = this._keySizeInBits;
        int n12 = n11;
        int n13 = n3;
        n12 = n12 / 8 + n3;
        byte[] byArray3 = new byte[n12];
        byte[] byArray4 = new byte[n13];
        byte[] byArray5 = new byte[n13];
        int n14 = 0;
        int n15 = n11 / 8;
        byte[] byArray6 = new byte[n15];
        System.arraycopy(K_BITS, 0, byArray6, 0, n15);
        while ((n6 = n14 * n3) * 8 < n3 * 8 + (n5 = this._keySizeInBits)) {
            CTRSP800DRBG cTRSP800DRBG = this;
            cTRSP800DRBG.copyIntToByteArray(byArray5, n14, 0);
            cTRSP800DRBG.BCC(byArray4, byArray6, byArray5, (byte[])object);
            n5 = n12 - n6;
            if (n5 > n3) {
                n5 = n3;
            }
            System.arraycopy(byArray4, 0, byArray3, n6, n5);
            ++n14;
        }
        byte[] byArray7 = new byte[n3];
        System.arraycopy(byArray3, 0, byArray6, 0, n15);
        System.arraycopy(byArray3, n15, byArray7, 0, n3);
        byArray3 = new byte[n9];
        int n16 = 0;
        object = keyParameter;
        keyParameter = new KeyParameter(this.expandKey(byArray6));
        this._engine.init(true, (CipherParameters)object);
        while ((n4 = n16 * n3) < n9) {
            this._engine.processBlock(byArray7, 0, byArray7, 0);
            int n17 = n9 - n4;
            if (n17 > n3) {
                n17 = n3;
            }
            System.arraycopy(byArray7, 0, byArray3, n4, n17);
            ++n16;
        }
        return byArray3;
    }

    private void BCC(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        KeyParameter keyParameter;
        CTRSP800DRBG cTRSP800DRBG = this;
        int n3 = cTRSP800DRBG._engine.getBlockSize();
        byte[] byArray5 = new byte[n3];
        int n4 = byArray4.length / n3;
        byte[] byArray6 = new byte[n3];
        KeyParameter keyParameter2 = keyParameter;
        keyParameter = new KeyParameter(this.expandKey(byArray2));
        cTRSP800DRBG._engine.init(true, keyParameter2);
        cTRSP800DRBG._engine.processBlock(byArray3, 0, byArray5, 0);
        for (int i3 = 0; i3 < n4; ++i3) {
            CTRSP800DRBG cTRSP800DRBG2 = this;
            int n5 = i3 * n3;
            cTRSP800DRBG2.XOR(byArray6, byArray5, byArray4, n5);
            cTRSP800DRBG2._engine.processBlock(byArray6, 0, byArray5, 0);
        }
        int n6 = byArray.length;
        System.arraycopy(byArray5, 0, byArray, 0, n6);
    }

    private void copyIntToByteArray(byte[] byArray, int n3, int n4) {
        int n5 = n4 + 0;
        byArray[n5] = (byte)(n3 >> 24);
        n5 = n4 + 1;
        byArray[n5] = (byte)(n3 >> 16);
        n5 = n4 + 2;
        byArray[n5] = (byte)(n3 >> 8);
        n5 = n4 + 3;
        byArray[n5] = (byte)n3;
    }

    private boolean isTDEA(BlockCipher blockCipher) {
        return blockCipher.getAlgorithmName().equals("DESede") || blockCipher.getAlgorithmName().equals("TDEA");
    }

    private int getMaxSecurityStrength(BlockCipher blockCipher, int n3) {
        if (this.isTDEA(blockCipher) && n3 == 168) {
            return 112;
        }
        if (blockCipher.getAlgorithmName().equals("AES")) {
            return n3;
        }
        return -1;
    }

    private void padKey(byte[] byArray, int n3, byte[] byArray2, int n4) {
        int n5 = n4 + 0;
        int n6 = n3 + 0;
        byArray2[n5] = (byte)(byArray[n6] & 0xFE);
        n5 = n4 + 1;
        int n7 = byArray[n6] << 7;
        n6 = n3 + 1;
        byArray2[n5] = (byte)(n7 | (byArray[n6] & 0xFC) >>> 1);
        n5 = n4 + 2;
        int n8 = byArray[n6] << 6;
        n6 = n3 + 2;
        byArray2[n5] = (byte)(n8 | (byArray[n6] & 0xF8) >>> 2);
        n5 = n4 + 3;
        int n9 = byArray[n6] << 5;
        n6 = n3 + 3;
        byArray2[n5] = (byte)(n9 | (byArray[n6] & 0xF0) >>> 3);
        n5 = n4 + 4;
        int n10 = byArray[n6] << 4;
        n6 = n3 + 4;
        byArray2[n5] = (byte)(n10 | (byArray[n6] & 0xE0) >>> 4);
        n5 = n4 + 5;
        int n11 = byArray[n6] << 3;
        n6 = n3 + 5;
        byArray2[n5] = (byte)(n11 | (byArray[n6] & 0xC0) >>> 5);
        n5 = n4 + 6;
        int n12 = n3 + 6;
        byArray2[n5] = (byte)(byArray[n6] << 2 | (byArray[n12] & 0x80) >>> 6);
        n5 = n4 + 7;
        byArray2[n5] = (byte)(byArray[n12] << 1);
        while (n4 <= n5) {
            n12 = byArray2[n4];
            byArray2[n4] = (byte)(n12 & 0xFE | (n12 >> 1 ^ n12 >> 2 ^ n12 >> 3 ^ n12 >> 4 ^ n12 >> 5 ^ n12 >> 6 ^ n12 >> 7 ^ 1) & 1);
            ++n4;
        }
    }

    @Override
    public int getBlockSize() {
        return this._V.length * 8;
    }

    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl) {
        block13: {
            KeyParameter keyParameter;
            byte[] byArray3;
            block12: {
                block11: {
                    if (!((CTRSP800DRBG)object)._isTDEA) break block11;
                    if (((CTRSP800DRBG)object)._reseedCounter > 0x80000000L) {
                        return -1;
                    }
                    if (Utils.isTooLarge(byArray, 512)) {
                        throw new IllegalArgumentException("Number of bits per request limited to 4096");
                    }
                    break block12;
                }
                if (((CTRSP800DRBG)object)._reseedCounter > 0x800000000000L) {
                    return -1;
                }
                if (Utils.isTooLarge(byArray, 32768)) break block13;
            }
            if (bl) {
                ((CTRSP800DRBG)object).CTR_DRBG_Reseed_algorithm(byArray2);
                byArray2 = null;
            }
            if (byArray2 != null) {
                CTRSP800DRBG cTRSP800DRBG = object;
                byArray2 = cTRSP800DRBG.Block_Cipher_df(byArray2, cTRSP800DRBG._seedLength);
                byte[] byArray4 = cTRSP800DRBG._Key;
                byArray3 = cTRSP800DRBG._V;
                cTRSP800DRBG.CTR_DRBG_Update(byArray2, byArray4, byArray3);
            } else {
                byArray2 = new byte[((CTRSP800DRBG)object)._seedLength / 8];
            }
            CTRSP800DRBG cTRSP800DRBG = object;
            int n3 = cTRSP800DRBG._V.length;
            byArray3 = new byte[n3];
            KeyParameter keyParameter2 = keyParameter;
            CTRSP800DRBG cTRSP800DRBG2 = object;
            keyParameter = new KeyParameter(cTRSP800DRBG2.expandKey(cTRSP800DRBG2._Key));
            cTRSP800DRBG._engine.init(true, keyParameter2);
            for (int i3 = 0; i3 <= byArray.length / n3; ++i3) {
                int n4 = i3 * n3;
                int n5 = byArray.length - n4 > n3 ? n3 : byArray.length - i3 * ((CTRSP800DRBG)object)._V.length;
                if (n5 == 0) continue;
                Object object = object;
                super.addOneTo(((CTRSP800DRBG)object)._V);
                ((CTRSP800DRBG)object)._engine.processBlock(((CTRSP800DRBG)object)._V, 0, byArray3, 0);
                System.arraycopy(byArray3, 0, byArray, n4, n5);
            }
            CTRSP800DRBG cTRSP800DRBG3 = object;
            CTRSP800DRBG cTRSP800DRBG4 = object;
            Object object = cTRSP800DRBG4._Key;
            cTRSP800DRBG3.CTR_DRBG_Update(byArray2, (byte[])object, cTRSP800DRBG4._V);
            ++cTRSP800DRBG3._reseedCounter;
            return byArray.length * 8;
        }
        throw new IllegalArgumentException("Number of bits per request limited to 262144");
    }

    @Override
    public void reseed(byte[] byArray) {
        this.CTR_DRBG_Reseed_algorithm(byArray);
    }

    public byte[] expandKey(byte[] byArray) {
        if (this._isTDEA) {
            byte[] byArray2 = new byte[24];
            CTRSP800DRBG cTRSP800DRBG = this;
            cTRSP800DRBG.padKey(byArray, 0, byArray2, 0);
            cTRSP800DRBG.padKey(byArray, 7, byArray2, 8);
            cTRSP800DRBG.padKey(byArray, 14, byArray2, 16);
            return byArray2;
        }
        return byArray;
    }
}

