/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.util.Hashtable;

class Utils {
    public static final Hashtable maxSecurityStrengths = new Hashtable<String, Integer>();

    public static int getMaxSecurityStrength(Digest digest) {
        return (Integer)maxSecurityStrengths.get(digest.getAlgorithmName());
    }

    public static int getMaxSecurityStrength(Mac mac) {
        String string2 = mac.getAlgorithmName();
        return (Integer)maxSecurityStrengths.get(string2.substring(0, string2.indexOf("/")));
    }

    public static byte[] hash_df(Digest digest, byte[] byArray, int n3) {
        int n4 = (n3 + 7) / 8;
        byte[] byArray2 = new byte[n4];
        int n5 = n4 / digest.getDigestSize();
        int n6 = 1;
        int n7 = digest.getDigestSize();
        byte[] byArray3 = new byte[n7];
        for (int i3 = 0; i3 <= n5; ++i3) {
            digest.update((byte)n6);
            digest.update((byte)(n3 >> 24));
            digest.update((byte)(n3 >> 16));
            digest.update((byte)(n3 >> 8));
            digest.update((byte)n3);
            digest.update(byArray, 0, byArray.length);
            digest.doFinal(byArray3, 0);
            int n8 = i3 * n7;
            int n9 = n4 - n8;
            if (n9 > n7) {
                n9 = n7;
            }
            System.arraycopy(byArray3, 0, byArray2, n8, n9);
            ++n6;
        }
        int n10 = n3 % 8;
        if (n10 != 0) {
            n10 = 8 - n10;
            int n11 = 0;
            for (n3 = 0; n3 != n4; ++n3) {
                n5 = byArray2[n3] & 0xFF;
                byArray2[n3] = (byte)(n5 >>> n10 | n11 << 8 - n10);
                n11 = n5;
            }
        }
        return byArray2;
    }

    public static boolean isTooLarge(byte[] byArray, int n3) {
        return byArray != null && byArray.length > n3;
    }

    static {
        maxSecurityStrengths.put("SHA-1", Integers.valueOf(128));
        maxSecurityStrengths.put("SHA-224", Integers.valueOf(192));
        maxSecurityStrengths.put("SHA-256", Integers.valueOf(256));
        maxSecurityStrengths.put("SHA-384", Integers.valueOf(256));
        maxSecurityStrengths.put("SHA-512", Integers.valueOf(256));
        maxSecurityStrengths.put("SHA-512/224", Integers.valueOf(192));
        maxSecurityStrengths.put("SHA-512/256", Integers.valueOf(256));
    }
}

