/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032.Ed25519;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class Ed25519Signer
implements Signer {
    private final Buffer buffer;
    private boolean forSigning;
    private Ed25519PrivateKeyParameters privateKey;
    private Ed25519PublicKeyParameters publicKey;

    public Ed25519Signer() {
        Buffer buffer;
        Buffer buffer2 = buffer;
        buffer = new Buffer(null);
        v1.buffer = buffer2;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        if (bl) {
            Ed25519Signer ed25519Signer = this;
            ed25519Signer.privateKey = (Ed25519PrivateKeyParameters)cipherParameters;
            ed25519Signer.publicKey = null;
        } else {
            this.privateKey = null;
            this.publicKey = (Ed25519PublicKeyParameters)cipherParameters;
        }
        this.reset();
    }

    @Override
    public void update(byte by) {
        ((OutputStream)this.buffer).write(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        ((OutputStream)this.buffer).write(byArray, n3, n4);
    }

    @Override
    public byte[] generateSignature() {
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters;
        if (this.forSigning && (ed25519PrivateKeyParameters = this.privateKey) != null) {
            return this.buffer.generateSignature(ed25519PrivateKeyParameters);
        }
        throw new IllegalStateException("Ed25519Signer not initialised for signature generation.");
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        Ed25519PublicKeyParameters ed25519PublicKeyParameters;
        if (!this.forSigning && (ed25519PublicKeyParameters = this.publicKey) != null) {
            return this.buffer.verifySignature(ed25519PublicKeyParameters, byArray);
        }
        throw new IllegalStateException("Ed25519Signer not initialised for verification");
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    public static class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        public /* synthetic */ Buffer(1 var1_1) {
            this();
        }

        public synchronized byte[] generateSignature(Ed25519PrivateKeyParameters ed25519PrivateKeyParameters) {
            byte[] byArray = new byte[64];
            Buffer buffer = object;
            Buffer buffer2 = object;
            Object object = buffer2.buf;
            int n3 = buffer2.count;
            ed25519PrivateKeyParameters.sign(0, null, (byte[])object, 0, n3, byArray, 0);
            buffer.reset();
            return byArray;
        }

        public synchronized boolean verifySignature(Ed25519PublicKeyParameters object, byte[] byArray) {
            if (64 != byArray.length) {
                this.reset();
                return false;
            }
            byte[] byArray2 = byArray;
            Buffer buffer = this;
            object = ((Ed25519PublicKeyParameters)object).getEncoded();
            byArray = buffer.buf;
            int n3 = buffer.count;
            boolean bl = Ed25519.verify(byArray2, 0, (byte[])object, 0, byArray, 0, n3);
            this.reset();
            return bl;
        }

        @Override
        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

