/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032.Ed25519;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class Ed25519phSigner
implements Signer {
    private final Digest prehash = Ed25519.createPrehash();
    private final byte[] context;
    private boolean forSigning;
    private Ed25519PrivateKeyParameters privateKey;
    private Ed25519PublicKeyParameters publicKey;

    public Ed25519phSigner(byte[] byArray) {
        this.context = Arrays.clone(byArray);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        if (bl) {
            Ed25519phSigner ed25519phSigner = this;
            ed25519phSigner.privateKey = (Ed25519PrivateKeyParameters)cipherParameters;
            ed25519phSigner.publicKey = null;
        } else {
            this.privateKey = null;
            this.publicKey = (Ed25519PublicKeyParameters)cipherParameters;
        }
        this.reset();
    }

    @Override
    public void update(byte by) {
        this.prehash.update(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        this.prehash.update(byArray, n3, n4);
    }

    @Override
    public byte[] generateSignature() {
        if (this.forSigning && this.privateKey != null) {
            byte[] byArray = new byte[64];
            if (64 == this.prehash.doFinal(byArray, 0)) {
                byte[] byArray2 = new byte[64];
                this.privateKey.sign(2, this.context, byArray, 0, 64, byArray2, 0);
                return byArray2;
            }
            throw new IllegalStateException("Prehash digest failed");
        }
        throw new IllegalStateException("Ed25519phSigner not initialised for signature generation.");
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        Object object;
        if (!((Ed25519phSigner)object2).forSigning && (object = ((Ed25519phSigner)object2).publicKey) != null) {
            if (64 != byArray.length) {
                ((Ed25519phSigner)object2).prehash.reset();
                return false;
            }
            byte[] byArray2 = byArray;
            Ed25519phSigner ed25519phSigner = object2;
            Object object2 = ((Ed25519PublicKeyParameters)object).getEncoded();
            byArray = ed25519phSigner.context;
            object = ed25519phSigner.prehash;
            return Ed25519.verifyPrehash(byArray2, 0, (byte[])object2, 0, byArray, (Digest)object);
        }
        throw new IllegalStateException("Ed25519phSigner not initialised for verification");
    }

    @Override
    public void reset() {
        this.prehash.reset();
    }
}

