/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.rfc8032.Ed448;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class Ed448Signer
implements Signer {
    private final Buffer buffer = new Buffer(null);
    private final byte[] context;
    private boolean forSigning;
    private Ed448PrivateKeyParameters privateKey;
    private Ed448PublicKeyParameters publicKey;

    public Ed448Signer(byte[] byArray) {
        this.context = Arrays.clone(byArray);
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        if (bl) {
            Ed448Signer ed448Signer = this;
            ed448Signer.privateKey = (Ed448PrivateKeyParameters)cipherParameters;
            ed448Signer.publicKey = null;
        } else {
            this.privateKey = null;
            this.publicKey = (Ed448PublicKeyParameters)cipherParameters;
        }
        this.reset();
    }

    @Override
    public void update(byte by) {
        ((OutputStream)this.buffer).write(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        ((OutputStream)this.buffer).write(byArray, n3, n4);
    }

    @Override
    public byte[] generateSignature() {
        Ed448PrivateKeyParameters ed448PrivateKeyParameters;
        if (this.forSigning && (ed448PrivateKeyParameters = this.privateKey) != null) {
            return this.buffer.generateSignature(ed448PrivateKeyParameters, this.context);
        }
        throw new IllegalStateException("Ed448Signer not initialised for signature generation.");
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        Ed448PublicKeyParameters ed448PublicKeyParameters;
        if (!this.forSigning && (ed448PublicKeyParameters = this.publicKey) != null) {
            return this.buffer.verifySignature(ed448PublicKeyParameters, this.context, byArray);
        }
        throw new IllegalStateException("Ed448Signer not initialised for verification");
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    public static class Buffer
    extends ByteArrayOutputStream {
        private Buffer() {
        }

        public /* synthetic */ Buffer(1 var1_1) {
            this();
        }

        public synchronized byte[] generateSignature(Ed448PrivateKeyParameters ed448PrivateKeyParameters, byte[] byArray) {
            byte[] byArray2 = new byte[114];
            Buffer buffer = object;
            Buffer buffer2 = object;
            Object object = buffer2.buf;
            int n3 = buffer2.count;
            ed448PrivateKeyParameters.sign(0, byArray, (byte[])object, 0, n3, byArray2, 0);
            buffer.reset();
            return byArray2;
        }

        public synchronized boolean verifySignature(Ed448PublicKeyParameters object, byte[] byArray, byte[] byArray2) {
            if (114 != byArray2.length) {
                this.reset();
                return false;
            }
            byte[] byArray3 = byArray2;
            Buffer buffer = this;
            object = ((Ed448PublicKeyParameters)object).getEncoded();
            byArray2 = buffer.buf;
            int n3 = buffer.count;
            boolean bl = Ed448.verify(byArray3, 0, (byte[])object, 0, byArray, byArray2, 0, n3);
            this.reset();
            return bl;
        }

        @Override
        public synchronized void reset() {
            Arrays.fill(this.buf, 0, this.count, (byte)0);
            this.count = 0;
        }
    }
}

