/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class GenericSigner
implements Signer {
    private final AsymmetricBlockCipher engine;
    private final Digest digest;
    private boolean forSigning;

    public GenericSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this.engine = asymmetricBlockCipher;
        this.digest = digest;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        this.forSigning = bl;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!bl && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        GenericSigner genericSigner = this;
        genericSigner.reset();
        genericSigner.engine.init(bl, cipherParameters);
    }

    @Override
    public void update(byte by) {
        this.digest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        this.digest.update(byArray, n3, n4);
    }

    @Override
    public byte[] generateSignature() {
        if (this.forSigning) {
            GenericSigner genericSigner = this;
            int n3 = genericSigner.digest.getDigestSize();
            byte[] byArray = new byte[n3];
            genericSigner.digest.doFinal(byArray, 0);
            return genericSigner.engine.processBlock(byArray, 0, n3);
        }
        throw new IllegalStateException("GenericSigner not initialised for signature generation.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean verifySignature(byte[] byArray) {
        int n3;
        AsymmetricBlockCipher asymmetricBlockCipher;
        if (this.forSigning) throw new IllegalStateException("GenericSigner not initialised for verification");
        GenericSigner genericSigner = this;
        int n4 = genericSigner.digest.getDigestSize();
        byte[] byArray2 = new byte[n4];
        genericSigner.digest.doFinal(byArray2, 0);
        try {
            asymmetricBlockCipher = genericSigner.engine;
            n3 = 0;
        }
        catch (Exception exception) {
            return false;
        }
        byte[] byArray3 = asymmetricBlockCipher.processBlock(byArray, n3, byArray.length);
        if (byArray3.length >= n4) return Arrays.constantTimeAreEqual(byArray3, byArray2);
        byte[] byArray4 = byArray3;
        byte[] byArray5 = byArray3;
        int n5 = n4;
        byte[] byArray6 = byArray3;
        byArray3 = new byte[n4];
        n4 = 0;
        int n6 = n5 - byArray6.length;
        int n7 = byArray4.length;
        System.arraycopy(byArray5, n4, byArray3, n6, n7);
        return Arrays.constantTimeAreEqual(byArray3, byArray2);
    }

    @Override
    public void reset() {
        this.digest.reset();
    }
}

