/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.HMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAKCalculator;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class HMacDSAKCalculator
implements DSAKCalculator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private final HMac hMac;
    private final byte[] K;
    private final byte[] V;
    private BigInteger n;

    public HMacDSAKCalculator(Digest digest) {
        HMac hMac;
        HMac hMac2 = hMac;
        v1.hMac = new HMac(digest);
        v1.V = new byte[hMac2.getMacSize()];
        v1.K = new byte[hMac2.getMacSize()];
    }

    private BigInteger bitsToInt(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = bigInteger;
        bigInteger = new BigInteger(1, byArray);
        if (byArray.length * 8 > this.n.bitLength()) {
            bigInteger2 = bigInteger2.shiftRight(byArray.length * 8 - this.n.bitLength());
        }
        return bigInteger2;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public void init(BigInteger bigInteger, SecureRandom secureRandom) {
        throw new IllegalStateException("Operation not supported");
    }

    @Override
    public void init(BigInteger bigInteger, BigInteger object, byte[] byArray) {
        HMacDSAKCalculator hMacDSAKCalculator = this;
        hMacDSAKCalculator.n = bigInteger;
        Arrays.fill(hMacDSAKCalculator.V, (byte)1);
        Arrays.fill(hMacDSAKCalculator.K, (byte)0);
        int n3 = BigIntegers.getUnsignedByteLength(bigInteger);
        BigInteger bigInteger2 = object;
        object = new byte[n3];
        byte[] byArray2 = BigIntegers.asUnsignedByteArray(bigInteger2);
        int n4 = n3 - byArray2.length;
        int n5 = byArray2.length;
        System.arraycopy(byArray2, 0, object, n4, n5);
        byte[] byArray3 = new byte[n3];
        BigInteger bigInteger3 = this.bitsToInt(byArray);
        if (bigInteger3.compareTo(bigInteger) >= 0) {
            bigInteger3 = bigInteger3.subtract(bigInteger);
        }
        HMacDSAKCalculator hMacDSAKCalculator2 = this;
        byte[] byArray4 = BigIntegers.asUnsignedByteArray(bigInteger3);
        int n6 = n3 - byArray4.length;
        int n7 = byArray4.length;
        System.arraycopy(byArray4, 0, byArray3, n6, n7);
        hMacDSAKCalculator2.hMac.init(new KeyParameter(this.K));
        hMacDSAKCalculator2.hMac.update(this.V, 0, this.V.length);
        hMacDSAKCalculator2.hMac.update((byte)0);
        hMacDSAKCalculator2.hMac.update((byte[])object, 0, n3);
        hMacDSAKCalculator2.hMac.update(byArray3, 0, n3);
        hMacDSAKCalculator2.hMac.doFinal(this.K, 0);
        hMacDSAKCalculator2.hMac.init(new KeyParameter(this.K));
        hMacDSAKCalculator2.hMac.update(this.V, 0, this.V.length);
        hMacDSAKCalculator2.hMac.doFinal(this.V, 0);
        hMacDSAKCalculator2.hMac.update(this.V, 0, this.V.length);
        hMacDSAKCalculator2.hMac.update((byte)1);
        hMacDSAKCalculator2.hMac.update((byte[])object, 0, n3);
        hMacDSAKCalculator2.hMac.update(byArray3, 0, n3);
        hMacDSAKCalculator2.hMac.doFinal(this.K, 0);
        hMacDSAKCalculator2.hMac.init(new KeyParameter(this.K));
        hMacDSAKCalculator2.hMac.update(this.V, 0, this.V.length);
        hMacDSAKCalculator2.hMac.doFinal(this.V, 0);
    }

    @Override
    public BigInteger nextK() {
        int n3 = BigIntegers.getUnsignedByteLength(this.n);
        byte[] byArray = new byte[n3];
        while (true) {
            int n4;
            for (int i3 = 0; i3 < n3; i3 += n4) {
                HMacDSAKCalculator hMacDSAKCalculator = this;
                hMacDSAKCalculator.hMac.update(this.V, 0, this.V.length);
                hMacDSAKCalculator.hMac.doFinal(this.V, 0);
                n4 = Math.min(n3 - i3, this.V.length);
                System.arraycopy(this.V, 0, byArray, i3, n4);
            }
            BigInteger bigInteger = this.bitsToInt(byArray);
            if (bigInteger.compareTo(ZERO) > 0 && bigInteger.compareTo(this.n) < 0) {
                return bigInteger;
            }
            HMacDSAKCalculator hMacDSAKCalculator = this;
            hMacDSAKCalculator.hMac.update(this.V, 0, this.V.length);
            hMacDSAKCalculator.hMac.update((byte)0);
            hMacDSAKCalculator.hMac.doFinal(this.K, 0);
            hMacDSAKCalculator.hMac.init(new KeyParameter(this.K));
            hMacDSAKCalculator.hMac.update(this.V, 0, this.V.length);
            hMacDSAKCalculator.hMac.doFinal(this.V, 0);
        }
    }
}

