/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.SignerWithRecovery;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithSalt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.ISOTrailers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class ISO9796d2PSSSigner
implements SignerWithRecovery {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private SecureRandom random;
    private byte[] standardSalt;
    private int hLen;
    private int trailer;
    private int keyBits;
    private byte[] block;
    private byte[] mBuf;
    private int messageLength;
    private int saltLength;
    private boolean fullMessage;
    private byte[] recoveredMessage;
    private byte[] preSig;
    private byte[] preBlock;
    private int preMStart;
    private int preTLength;

    public ISO9796d2PSSSigner(AsymmetricBlockCipher object, Digest digest, int n3, boolean bl) {
        block4: {
            block3: {
                block2: {
                    this.cipher = object;
                    this.digest = digest;
                    this.hLen = digest.getDigestSize();
                    this.saltLength = n3;
                    if (!bl) break block2;
                    this.trailer = 188;
                    break block3;
                }
                object = ISOTrailers.getTrailer(digest);
                if (object == null) break block4;
                this.trailer = (Integer)object;
            }
            return;
        }
        throw new IllegalArgumentException(b.a("no valid trailer for digest: ").append(digest.getAlgorithmName()).toString());
    }

    public ISO9796d2PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n3) {
        this(asymmetricBlockCipher, digest, n3, false);
    }

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        if (this.messageLength != byArray2.length) {
            bl = false;
        }
        for (int i3 = 0; i3 != byArray2.length; ++i3) {
            if (byArray[i3] == byArray2[i3]) continue;
            bl = false;
        }
        return bl;
    }

    private void clearBlock(byte[] byArray) {
        for (int i3 = 0; i3 != byArray.length; ++i3) {
            byArray[i3] = 0;
        }
    }

    private void ItoOSP(int n3, byte[] byArray) {
        byArray[0] = (byte)(n3 >>> 24);
        byArray[1] = (byte)(n3 >>> 16);
        byArray[2] = (byte)(n3 >>> 8);
        byArray[3] = (byte)(n3 >>> 0);
    }

    private void LtoOSP(long l3, byte[] byArray) {
        byArray[0] = (byte)(l3 >>> 56);
        byArray[1] = (byte)(l3 >>> 48);
        byArray[2] = (byte)(l3 >>> 40);
        byArray[3] = (byte)(l3 >>> 32);
        byArray[4] = (byte)(l3 >>> 24);
        byArray[5] = (byte)(l3 >>> 16);
        byArray[6] = (byte)(l3 >>> 8);
        byArray[7] = (byte)(l3 >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n3, int n4, int n5) {
        int n6;
        int n7;
        ISO9796d2PSSSigner iSO9796d2PSSSigner = this;
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[iSO9796d2PSSSigner.hLen];
        int n8 = 4;
        byte[] byArray4 = new byte[4];
        iSO9796d2PSSSigner.digest.reset();
        for (n7 = 0; n7 < n5 / (n6 = this.hLen); ++n7) {
            ISO9796d2PSSSigner iSO9796d2PSSSigner2 = this;
            iSO9796d2PSSSigner2.ItoOSP(n7, byArray4);
            iSO9796d2PSSSigner2.digest.update(byArray, n3, n4);
            iSO9796d2PSSSigner2.digest.update(byArray4, 0, n8);
            iSO9796d2PSSSigner2.digest.doFinal(byArray3, 0);
            n6 = iSO9796d2PSSSigner2.hLen;
            int n9 = n7 * n6;
            System.arraycopy(byArray3, 0, byArray2, n9, n6);
        }
        if (n7 * n6 < n5) {
            int n10 = n7;
            ISO9796d2PSSSigner iSO9796d2PSSSigner3 = this;
            iSO9796d2PSSSigner3.ItoOSP(n7, byArray4);
            iSO9796d2PSSSigner3.digest.update(byArray, n3, n4);
            iSO9796d2PSSSigner3.digest.update(byArray4, 0, n8);
            iSO9796d2PSSSigner3.digest.doFinal(byArray3, 0);
            int n11 = iSO9796d2PSSSigner3.hLen;
            int n12 = n10 * n11;
            n11 = n5 - n10 * n11;
            System.arraycopy(byArray3, 0, byArray2, n12, n11);
        }
        return byArray2;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters;
        int n3 = this.saltLength;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = (ParametersWithRandom)cipherParameters;
            rSAKeyParameters = (RSAKeyParameters)((ParametersWithRandom)cipherParameters).getParameters();
            if (bl) {
                this.random = ((ParametersWithRandom)cipherParameters).getRandom();
            }
        } else if (cipherParameters instanceof ParametersWithSalt) {
            ParametersWithSalt parametersWithSalt = (ParametersWithSalt)cipherParameters;
            rSAKeyParameters = (RSAKeyParameters)parametersWithSalt.getParameters();
            this.standardSalt = parametersWithSalt.getSalt();
            n3 = this.standardSalt.length;
            if (this.standardSalt.length != this.saltLength) {
                throw new IllegalArgumentException("Fixed salt is of wrong length");
            }
        } else {
            rSAKeyParameters = (RSAKeyParameters)cipherParameters;
            if (bl) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
        }
        this.cipher.init(bl, rSAKeyParameters);
        this.keyBits = rSAKeyParameters.getModulus().bitLength();
        byte[] byArray = new byte[(this.keyBits + 7) / 8];
        this.block = byArray;
        this.mBuf = this.trailer == 188 ? new byte[byArray.length - this.digest.getDigestSize() - n3 - 1 - 1] : new byte[byArray.length - this.digest.getDigestSize() - n3 - 1 - 2];
        this.reset();
    }

    @Override
    public void updateWithRecoveredMessage(byte[] byArray) {
        block10: {
            int n3;
            byte[] byArray2;
            block9: {
                int n4;
                block8: {
                    byArray2 = ((ISO9796d2PSSSigner)object).cipher.processBlock(byArray, 0, byArray.length);
                    if (byArray2.length < ((n3 = ((ISO9796d2PSSSigner)object).keyBits) + 7) / 8) {
                        byte[] byArray3 = byArray2;
                        int n5 = (n3 + 7) / 8;
                        byArray2 = new byte[n5];
                        n3 = n5 - byArray2.length;
                        n4 = byArray3.length;
                        System.arraycopy(byArray3, 0, byArray2, n3, n4);
                        ((ISO9796d2PSSSigner)object).clearBlock(byArray2);
                    }
                    if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) != 0) break block8;
                    n3 = 1;
                    break block9;
                }
                n3 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
                Integer n6 = ISOTrailers.getTrailer(((ISO9796d2PSSSigner)object).digest);
                if (n6 == null) break block10;
                n4 = n6;
                if (n3 != n4 && (n4 != 15052 || n3 != 16588)) {
                    throw new IllegalStateException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a.a("signer initialised with wrong digest for trailer ", n3));
                }
                n3 = 2;
            }
            ISO9796d2PSSSigner iSO9796d2PSSSigner = object;
            byte[] byArray4 = new byte[iSO9796d2PSSSigner.hLen];
            iSO9796d2PSSSigner.digest.doFinal(byArray4, 0);
            int n7 = ((ISO9796d2PSSSigner)object).hLen;
            int n8 = byArray2.length - n7 - n3;
            int n9 = byArray2.length - n7 - n3;
            byte[] byArray5 = ((ISO9796d2PSSSigner)object).maskGeneratorFunction1(byArray2, n8, n7, n9);
            for (n8 = 0; n8 != byArray5.length; ++n8) {
                byArray2[n8] = (byte)(byArray2[n8] ^ byArray5[n8]);
            }
            byArray2[0] = (byte)(byArray2[0] & 0x7F);
            for (n8 = 0; n8 != byArray2.length && byArray2[n8] != 1; ++n8) {
            }
            if (++n8 >= byArray2.length) {
                ((ISO9796d2PSSSigner)object).clearBlock(byArray2);
            }
            n9 = n8 > 1 ? 1 : 0;
            ISO9796d2PSSSigner iSO9796d2PSSSigner2 = object;
            ISO9796d2PSSSigner iSO9796d2PSSSigner3 = object;
            ISO9796d2PSSSigner iSO9796d2PSSSigner4 = object;
            ISO9796d2PSSSigner iSO9796d2PSSSigner5 = object;
            byte[] byArray6 = byArray;
            ((ISO9796d2PSSSigner)object).fullMessage = n9;
            byArray = new byte[byArray5.length - n8 - ((ISO9796d2PSSSigner)object).saltLength];
            ((ISO9796d2PSSSigner)object).recoveredMessage = byArray;
            int n10 = byArray.length;
            System.arraycopy(byArray2, n8, byArray, 0, n10);
            Object object = ((ISO9796d2PSSSigner)object).mBuf;
            int n11 = ((ISO9796d2PSSSigner)object).recoveredMessage.length;
            System.arraycopy(((ISO9796d2PSSSigner)object).recoveredMessage, 0, object, 0, n11);
            iSO9796d2PSSSigner5.preSig = byArray6;
            iSO9796d2PSSSigner4.preBlock = byArray2;
            iSO9796d2PSSSigner3.preMStart = n8;
            iSO9796d2PSSSigner2.preTLength = n3;
            return;
        }
        throw new IllegalArgumentException("unrecognised hash in signature");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void update(byte by) {
        if (this.preSig == null) {
            int n3 = this.messageLength;
            byte[] byArray = this.mBuf;
            if (n3 < this.mBuf.length) {
                this.messageLength = n3 + 1;
                byArray[n3] = by;
                return;
            }
        }
        this.digest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        if (this.preSig == null) {
            while (n4 > 0 && this.messageLength < this.mBuf.length) {
                this.update(byArray[n3]);
                ++n3;
                --n4;
            }
        }
        if (n4 > 0) {
            this.digest.update(byArray, n3, n4);
        }
    }

    @Override
    public void reset() {
        ISO9796d2PSSSigner iSO9796d2PSSSigner = this;
        iSO9796d2PSSSigner.digest.reset();
        iSO9796d2PSSSigner.messageLength = 0;
        byte[] byArray = iSO9796d2PSSSigner.mBuf;
        if (iSO9796d2PSSSigner.mBuf != null) {
            this.clearBlock(byArray);
        }
        byArray = this.recoveredMessage;
        if (this.recoveredMessage != null) {
            this.clearBlock(byArray);
            this.recoveredMessage = null;
        }
        this.fullMessage = false;
        if (this.preSig != null) {
            ISO9796d2PSSSigner iSO9796d2PSSSigner2 = this;
            iSO9796d2PSSSigner2.preSig = null;
            iSO9796d2PSSSigner2.clearBlock(iSO9796d2PSSSigner2.preBlock);
            iSO9796d2PSSSigner2.preBlock = null;
        }
    }

    @Override
    public byte[] generateSignature() {
        ISO9796d2PSSSigner iSO9796d2PSSSigner = this;
        int n3 = iSO9796d2PSSSigner.digest.getDigestSize();
        byte[] byArray = new byte[n3];
        iSO9796d2PSSSigner.digest.doFinal(byArray, 0);
        byte[] byArray2 = new byte[8];
        iSO9796d2PSSSigner.LtoOSP(iSO9796d2PSSSigner.messageLength * 8, byArray2);
        iSO9796d2PSSSigner.digest.update(byArray2, 0, 8);
        ISO9796d2PSSSigner iSO9796d2PSSSigner2 = this;
        byArray2 = iSO9796d2PSSSigner2.mBuf;
        int n4 = iSO9796d2PSSSigner2.messageLength;
        iSO9796d2PSSSigner.digest.update(byArray2, 0, n4);
        iSO9796d2PSSSigner.digest.update(byArray, 0, n3);
        byte[] byArray3 = iSO9796d2PSSSigner.standardSalt;
        if (iSO9796d2PSSSigner.standardSalt == null) {
            ISO9796d2PSSSigner iSO9796d2PSSSigner3 = this;
            byArray3 = new byte[iSO9796d2PSSSigner3.saltLength];
            iSO9796d2PSSSigner3.random.nextBytes(byArray3);
        }
        ISO9796d2PSSSigner iSO9796d2PSSSigner4 = this;
        iSO9796d2PSSSigner4.digest.update(byArray3, 0, byArray3.length);
        int n5 = iSO9796d2PSSSigner4.digest.getDigestSize();
        byArray2 = new byte[n5];
        iSO9796d2PSSSigner4.digest.doFinal(byArray2, 0);
        n4 = 2;
        if (iSO9796d2PSSSigner4.trailer == 188) {
            n4 = 1;
        }
        ISO9796d2PSSSigner iSO9796d2PSSSigner5 = this;
        byte[] byArray4 = iSO9796d2PSSSigner5.block;
        int n6 = this.messageLength;
        int n7 = a.a(byArray4.length - n6 - byArray3.length, this.hLen, n4, 1);
        iSO9796d2PSSSigner5.block[n7] = 1;
        byte[] byArray5 = iSO9796d2PSSSigner5.mBuf;
        ISO9796d2PSSSigner iSO9796d2PSSSigner6 = this;
        System.arraycopy(byArray5, 0, byArray4, ++n7, n6);
        byte[] byArray6 = iSO9796d2PSSSigner6.block;
        int n8 = n7 + iSO9796d2PSSSigner6.messageLength;
        n6 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray6, n8, n6);
        int n9 = this.block.length - this.hLen - n4;
        byte[] byArray7 = this.maskGeneratorFunction1(byArray2, 0, n5, n9);
        for (n5 = 0; n5 != byArray7.length; ++n5) {
            this.block[n5] = (byte)(this.block[n5] ^ byArray7[n5]);
        }
        byArray7 = this.block;
        n5 = this.hLen;
        int n10 = this.block.length - n5 - n4;
        System.arraycopy(byArray2, 0, byArray7, n10, n5);
        int n11 = this.trailer;
        if (n11 == 188) {
            this.block[this.block.length - 1] = -68;
        } else {
            byte[] byArray8 = this.block;
            int n12 = n11;
            int n13 = n11;
            n11 = byArray8.length - 2;
            byArray8[n11] = (byte)(n13 >>> 8);
            n11 = byArray8.length - 1;
            this.block[n11] = (byte)n12;
        }
        ISO9796d2PSSSigner iSO9796d2PSSSigner7 = this;
        byte[] byArray9 = iSO9796d2PSSSigner7.block;
        iSO9796d2PSSSigner7.block[0] = (byte)(byArray9[0] & 0x7F);
        byArray9 = iSO9796d2PSSSigner7.cipher.processBlock(byArray9, 0, byArray9.length);
        int n14 = iSO9796d2PSSSigner7.messageLength;
        ISO9796d2PSSSigner iSO9796d2PSSSigner8 = this;
        byte[] byArray10 = new byte[n14];
        iSO9796d2PSSSigner8.recoveredMessage = byArray10;
        byte[] byArray11 = iSO9796d2PSSSigner8.mBuf;
        n4 = n14 <= iSO9796d2PSSSigner8.mBuf.length ? 1 : 0;
        ISO9796d2PSSSigner iSO9796d2PSSSigner9 = this;
        this.fullMessage = n4;
        int n15 = byArray10.length;
        System.arraycopy(byArray11, 0, byArray10, 0, n15);
        iSO9796d2PSSSigner9.clearBlock(iSO9796d2PSSSigner9.mBuf);
        iSO9796d2PSSSigner9.clearBlock(iSO9796d2PSSSigner9.block);
        iSO9796d2PSSSigner9.messageLength = 0;
        return byArray9;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        block14: {
            ISO9796d2PSSSigner iSO9796d2PSSSigner = this;
            int n3 = iSO9796d2PSSSigner.hLen;
            byte[] byArray2 = new byte[n3];
            iSO9796d2PSSSigner.digest.doFinal(byArray2, 0);
            byte[] byArray3 = iSO9796d2PSSSigner.preSig;
            if (iSO9796d2PSSSigner.preSig == null) {
                try {
                    this.updateWithRecoveredMessage(byArray);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            if (!Arrays.areEqual(byArray3, byArray)) break block14;
            ISO9796d2PSSSigner iSO9796d2PSSSigner2 = this;
            byArray = iSO9796d2PSSSigner2.preBlock;
            int n4 = iSO9796d2PSSSigner2.preMStart;
            int n5 = iSO9796d2PSSSigner2.preTLength;
            iSO9796d2PSSSigner2.preSig = null;
            iSO9796d2PSSSigner2.preBlock = null;
            byte[] byArray4 = new byte[8];
            iSO9796d2PSSSigner2.LtoOSP(iSO9796d2PSSSigner2.recoveredMessage.length * 8, byArray4);
            iSO9796d2PSSSigner2.digest.update(byArray4, 0, 8);
            byArray4 = iSO9796d2PSSSigner2.recoveredMessage;
            if (iSO9796d2PSSSigner2.recoveredMessage.length != 0) {
                this.digest.update(byArray4, 0, byArray4.length);
            }
            ISO9796d2PSSSigner iSO9796d2PSSSigner3 = this;
            iSO9796d2PSSSigner3.digest.update(byArray2, 0, n3);
            byte[] byArray5 = iSO9796d2PSSSigner3.standardSalt;
            if (iSO9796d2PSSSigner3.standardSalt != null) {
                this.digest.update(byArray5, 0, byArray5.length);
            } else {
                int n6 = n4 + this.recoveredMessage.length;
                this.digest.update(byArray, n6, this.saltLength);
            }
            ISO9796d2PSSSigner iSO9796d2PSSSigner4 = this;
            int n7 = iSO9796d2PSSSigner4.digest.getDigestSize();
            byArray2 = new byte[n7];
            iSO9796d2PSSSigner4.digest.doFinal(byArray2, 0);
            n4 = byArray.length - n5 - n7;
            n5 = 1;
            for (int i3 = 0; i3 != n7; ++i3) {
                if (byArray2[i3] == byArray[n4 + i3]) continue;
                n5 = 0;
            }
            ISO9796d2PSSSigner iSO9796d2PSSSigner5 = this;
            iSO9796d2PSSSigner5.clearBlock(byArray);
            iSO9796d2PSSSigner5.clearBlock(byArray2);
            if (n5 == 0) {
                ISO9796d2PSSSigner iSO9796d2PSSSigner6 = this;
                iSO9796d2PSSSigner6.fullMessage = false;
                iSO9796d2PSSSigner6.messageLength = 0;
                iSO9796d2PSSSigner6.clearBlock(iSO9796d2PSSSigner6.recoveredMessage);
                return false;
            }
            if (this.messageLength != 0) {
                ISO9796d2PSSSigner iSO9796d2PSSSigner7 = this;
                byArray = iSO9796d2PSSSigner7.mBuf;
                if (!iSO9796d2PSSSigner7.isSameAs(byArray, iSO9796d2PSSSigner7.recoveredMessage)) {
                    ISO9796d2PSSSigner iSO9796d2PSSSigner8 = this;
                    iSO9796d2PSSSigner8.messageLength = 0;
                    iSO9796d2PSSSigner8.clearBlock(iSO9796d2PSSSigner8.mBuf);
                    return false;
                }
            }
            ISO9796d2PSSSigner iSO9796d2PSSSigner9 = this;
            iSO9796d2PSSSigner9.messageLength = 0;
            iSO9796d2PSSSigner9.clearBlock(iSO9796d2PSSSigner9.mBuf);
            return true;
        }
        throw new IllegalStateException("updateWithRecoveredMessage called on different signature");
    }

    @Override
    public boolean hasFullMessage() {
        return this.fullMessage;
    }

    @Override
    public byte[] getRecoveredMessage() {
        return this.recoveredMessage;
    }
}

