/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.InvalidCipherTextException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.SignerWithRecovery;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.ISOTrailers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class ISO9796d2Signer
implements SignerWithRecovery {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private int trailer;
    private int keyBits;
    private byte[] block;
    private byte[] mBuf;
    private int messageLength;
    private boolean fullMessage;
    private byte[] recoveredMessage;
    private byte[] preSig;
    private byte[] preBlock;

    public ISO9796d2Signer(AsymmetricBlockCipher object, Digest digest, boolean bl) {
        block4: {
            block3: {
                block2: {
                    this.cipher = object;
                    this.digest = digest;
                    if (!bl) break block2;
                    this.trailer = 188;
                    break block3;
                }
                object = ISOTrailers.getTrailer(digest);
                if (object == null) break block4;
                this.trailer = (Integer)object;
            }
            return;
        }
        throw new IllegalArgumentException(b.a("no valid trailer for digest: ").append(digest.getAlgorithmName()).toString());
    }

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, false);
    }

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        boolean bl = true;
        int n3 = this.messageLength;
        byte[] byArray3 = this.mBuf;
        if (n3 > this.mBuf.length) {
            if (byArray3.length > byArray2.length) {
                bl = false;
            }
            for (n3 = 0; n3 != this.mBuf.length; ++n3) {
                if (byArray[n3] == byArray2[n3]) continue;
                bl = false;
            }
        } else {
            if (n3 != byArray2.length) {
                bl = false;
            }
            for (int i3 = 0; i3 != byArray2.length; ++i3) {
                if (byArray[i3] == byArray2[i3]) continue;
                bl = false;
            }
        }
        return bl;
    }

    private void clearBlock(byte[] byArray) {
        for (int i3 = 0; i3 != byArray.length; ++i3) {
            byArray[i3] = 0;
        }
    }

    private boolean returnFalse(byte[] byArray) {
        ISO9796d2Signer iSO9796d2Signer = this;
        iSO9796d2Signer.messageLength = 0;
        iSO9796d2Signer.clearBlock(iSO9796d2Signer.mBuf);
        this.clearBlock(byArray);
        return false;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        cipherParameters = (RSAKeyParameters)cipherParameters;
        this.cipher.init(bl, cipherParameters);
        this.keyBits = ((RSAKeyParameters)cipherParameters).getModulus().bitLength();
        byte[] byArray = new byte[(this.keyBits + 7) / 8];
        this.block = byArray;
        this.mBuf = this.trailer == 188 ? new byte[byArray.length - this.digest.getDigestSize() - 2] : new byte[byArray.length - this.digest.getDigestSize() - 3];
        this.reset();
    }

    @Override
    public void updateWithRecoveredMessage(byte[] byArray) {
        block8: {
            block9: {
                block12: {
                    int n3;
                    int n4;
                    byte[] byArray2;
                    block11: {
                        block10: {
                            byArray2 = ((ISO9796d2Signer)object).cipher.processBlock(byArray, 0, byArray.length);
                            if ((byArray2[0] & 0xC0 ^ 0x40) != 0) break block8;
                            if ((byArray2[byArray2.length - 1] & 0xF ^ 0xC) != 0) break block9;
                            if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) != 0) break block10;
                            n4 = 1;
                            break block11;
                        }
                        n4 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
                        Integer n5 = ISOTrailers.getTrailer(((ISO9796d2Signer)object).digest);
                        if (n5 == null) break block12;
                        n3 = n5;
                        if (n4 != n3 && (n3 != 15052 || n4 != 16588)) {
                            throw new IllegalStateException(a.a("signer initialised with wrong digest for trailer ", n4));
                        }
                        n4 = 2;
                    }
                    for (n3 = 0; n3 != byArray2.length && (byArray2[n3] & 0xF ^ 0xA) != 0; ++n3) {
                    }
                    if ((n4 = byArray2.length - n4 - ((ISO9796d2Signer)object).digest.getDigestSize() - ++n3) > 0) {
                        if ((byArray2[0] & 0x20) == 0) {
                            ((ISO9796d2Signer)object).fullMessage = true;
                            byte[] byArray3 = new byte[n4];
                            ((ISO9796d2Signer)object).recoveredMessage = byArray3;
                            int n6 = byArray3.length;
                            System.arraycopy(byArray2, n3, byArray3, 0, n6);
                        } else {
                            ((ISO9796d2Signer)object).fullMessage = false;
                            byte[] byArray4 = new byte[n4];
                            ((ISO9796d2Signer)object).recoveredMessage = byArray4;
                            int n7 = byArray4.length;
                            System.arraycopy(byArray2, n3, byArray4, 0, n7);
                        }
                        ISO9796d2Signer iSO9796d2Signer = object;
                        ((ISO9796d2Signer)object).preSig = byArray;
                        iSO9796d2Signer.preBlock = byArray2;
                        iSO9796d2Signer.digest.update(((ISO9796d2Signer)object).recoveredMessage, 0, ((ISO9796d2Signer)object).recoveredMessage.length);
                        byArray = iSO9796d2Signer.recoveredMessage;
                        ((ISO9796d2Signer)object).messageLength = byArray.length;
                        Object object = ((ISO9796d2Signer)object).mBuf;
                        int n8 = byArray.length;
                        System.arraycopy(iSO9796d2Signer.recoveredMessage, 0, object, 0, n8);
                        return;
                    }
                    throw new InvalidCipherTextException("malformed block");
                }
                throw new IllegalArgumentException("unrecognised hash in signature");
            }
            throw new InvalidCipherTextException("malformed signature");
        }
        throw new InvalidCipherTextException("malformed signature");
    }

    @Override
    public void update(byte by) {
        ISO9796d2Signer iSO9796d2Signer = this;
        iSO9796d2Signer.digest.update(by);
        int n3 = iSO9796d2Signer.messageLength;
        byte[] byArray = this.mBuf;
        if (n3 < this.mBuf.length) {
            byArray[n3] = by;
        }
        this.messageLength = n3 + 1;
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        while (n4 > 0 && this.messageLength < this.mBuf.length) {
            this.update(byArray[n3]);
            ++n3;
            --n4;
        }
        ISO9796d2Signer iSO9796d2Signer = this;
        iSO9796d2Signer.digest.update(byArray, n3, n4);
        iSO9796d2Signer.messageLength += n4;
    }

    @Override
    public void reset() {
        ISO9796d2Signer iSO9796d2Signer = this;
        iSO9796d2Signer.digest.reset();
        iSO9796d2Signer.messageLength = 0;
        iSO9796d2Signer.clearBlock(iSO9796d2Signer.mBuf);
        byte[] byArray = iSO9796d2Signer.recoveredMessage;
        if (iSO9796d2Signer.recoveredMessage != null) {
            this.clearBlock(byArray);
        }
        this.recoveredMessage = null;
        this.fullMessage = false;
        if (this.preSig != null) {
            ISO9796d2Signer iSO9796d2Signer2 = this;
            iSO9796d2Signer2.preSig = null;
            iSO9796d2Signer2.clearBlock(iSO9796d2Signer2.preBlock);
            iSO9796d2Signer2.preBlock = null;
        }
    }

    @Override
    public byte[] generateSignature() {
        int n3;
        int n4;
        int n5;
        ISO9796d2Signer iSO9796d2Signer = object;
        int n6 = iSO9796d2Signer.digest.getDigestSize();
        if (iSO9796d2Signer.trailer == 188) {
            ISO9796d2Signer iSO9796d2Signer2 = object;
            n5 = 8;
            byte[] byArray = iSO9796d2Signer2.block;
            n4 = iSO9796d2Signer2.block.length - n6 - 1;
            iSO9796d2Signer2.digest.doFinal(byArray, n4);
            iSO9796d2Signer2.block[iSO9796d2Signer2.block.length - 1] = -68;
        } else {
            ISO9796d2Signer iSO9796d2Signer3 = object;
            n5 = 16;
            byte[] byArray = iSO9796d2Signer3.block;
            n4 = iSO9796d2Signer3.block.length - n6 - 2;
            iSO9796d2Signer3.digest.doFinal(byArray, n4);
            byArray = iSO9796d2Signer3.block;
            int n7 = byArray.length - 2;
            int n8 = ((ISO9796d2Signer)object).trailer;
            byArray[n7] = (byte)(n8 >>> 8);
            int n9 = byArray.length - 1;
            iSO9796d2Signer3.block[n9] = (byte)n8;
        }
        int n10 = n6;
        n6 = ((ISO9796d2Signer)object).messageLength;
        n5 = (n10 + n6) * 8 + n5 + 4 - ((ISO9796d2Signer)object).keyBits;
        if (n5 > 0) {
            n6 -= (n5 + 7) / 8;
            n5 = 96;
            n3 = n4 - n6;
            System.arraycopy(((ISO9796d2Signer)object).mBuf, 0, ((ISO9796d2Signer)object).block, n3, n6);
            ((ISO9796d2Signer)object).recoveredMessage = new byte[n6];
        } else {
            ISO9796d2Signer iSO9796d2Signer4 = object;
            n5 = 64;
            n3 = n4 - n6;
            System.arraycopy(iSO9796d2Signer4.mBuf, 0, ((ISO9796d2Signer)object).block, n3, n6);
            iSO9796d2Signer4.recoveredMessage = new byte[iSO9796d2Signer4.messageLength];
        }
        n6 = n3 - 1;
        if (n6 > 0) {
            for (n3 = n6; n3 != 0; --n3) {
                ((ISO9796d2Signer)object).block[n3] = -69;
            }
            byte[] byArray = ((ISO9796d2Signer)object).block;
            byte[] byArray2 = ((ISO9796d2Signer)object).block;
            byArray2[n6] = (byte)(byArray[n6] ^ 1);
            byArray[0] = 11;
            byArray2[0] = (byte)(0xB | n5);
        } else {
            ((ISO9796d2Signer)object).block[0] = 10;
            ((ISO9796d2Signer)object).block[0] = (byte)(0xA | n5);
        }
        byte[] byArray = ((ISO9796d2Signer)object).cipher.processBlock(((ISO9796d2Signer)object).block, 0, ((ISO9796d2Signer)object).block.length);
        n5 = (n5 & 0x20) == 0 ? 1 : 0;
        ISO9796d2Signer iSO9796d2Signer5 = object;
        iSO9796d2Signer5.fullMessage = n5;
        Object object = ((ISO9796d2Signer)object).recoveredMessage;
        int n11 = ((ISO9796d2Signer)object).recoveredMessage.length;
        System.arraycopy(iSO9796d2Signer5.mBuf, 0, object, 0, n11);
        iSO9796d2Signer5.messageLength = 0;
        iSO9796d2Signer5.clearBlock(iSO9796d2Signer5.mBuf);
        iSO9796d2Signer5.clearBlock(iSO9796d2Signer5.block);
        return byArray;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        block22: {
            block25: {
                byte[] byArray2;
                int n3;
                int n4;
                int n5;
                block24: {
                    block23: {
                        byte[] byArray3 = this.preSig;
                        if (this.preSig == null) {
                            int n6;
                            AsymmetricBlockCipher asymmetricBlockCipher;
                            try {
                                asymmetricBlockCipher = this.cipher;
                                n6 = 0;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                            byArray = asymmetricBlockCipher.processBlock(byArray, n6, byArray.length);
                        }
                        if (!Arrays.areEqual(byArray3, byArray)) break block22;
                        byArray = this.preBlock;
                        this.preSig = null;
                        this.preBlock = null;
                        if ((byArray[0] & 0xC0 ^ 0x40) != 0) {
                            return this.returnFalse(byArray);
                        }
                        if ((byArray[byArray.length - 1] & 0xF ^ 0xC) != 0) {
                            return this.returnFalse(byArray);
                        }
                        if ((byArray[byArray.length - 1] & 0xFF ^ 0xBC) != 0) break block23;
                        n5 = 1;
                        break block24;
                    }
                    n5 = (byArray[byArray.length - 2] & 0xFF) << 8 | byArray[byArray.length - 1] & 0xFF;
                    Integer n7 = ISOTrailers.getTrailer(this.digest);
                    if (n7 == null) break block25;
                    n4 = n7;
                    if (n5 != n4 && (n4 != 15052 || n5 != 16588)) {
                        throw new IllegalStateException(a.a("signer initialised with wrong digest for trailer ", n5));
                    }
                    n5 = 2;
                }
                for (n4 = 0; n4 != byArray.length && (byArray[n4] & 0xF ^ 0xA) != 0; ++n4) {
                }
                int n8 = this.digest.getDigestSize();
                byte[] byArray4 = new byte[n8];
                if ((n3 = (n5 = byArray.length - n5 - n8) - ++n4) <= 0) {
                    return this.returnFalse(byArray);
                }
                if ((byArray[0] & 0x20) == 0) {
                    this.fullMessage = true;
                    if (this.messageLength > n3) {
                        return this.returnFalse(byArray);
                    }
                    ISO9796d2Signer iSO9796d2Signer = this;
                    iSO9796d2Signer.digest.reset();
                    iSO9796d2Signer.digest.update(byArray, n4, n3);
                    iSO9796d2Signer.digest.doFinal(byArray4, 0);
                    boolean bl = true;
                    for (int i3 = 0; i3 != n8; ++i3) {
                        byte by;
                        int n9 = n5 + i3;
                        byArray[n9] = by = (byte)(byArray[n9] ^ byArray4[i3]);
                        if (by == 0) continue;
                        bl = false;
                    }
                    if (!bl) {
                        return this.returnFalse(byArray);
                    }
                    byArray2 = new byte[n3];
                    this.recoveredMessage = byArray2;
                    n8 = byArray2.length;
                    System.arraycopy(byArray, n4, byArray2, 0, n8);
                } else {
                    this.fullMessage = false;
                    this.digest.doFinal(byArray4, 0);
                    boolean bl = true;
                    for (int i4 = 0; i4 != n8; ++i4) {
                        byte by;
                        int n10 = n5 + i4;
                        byArray[n10] = by = (byte)(byArray[n10] ^ byArray4[i4]);
                        if (by == 0) continue;
                        bl = false;
                    }
                    if (!bl) {
                        return this.returnFalse(byArray);
                    }
                    byArray2 = new byte[n3];
                    this.recoveredMessage = byArray2;
                    n8 = byArray2.length;
                    System.arraycopy(byArray, n4, byArray2, 0, n8);
                }
                if (this.messageLength != 0) {
                    ISO9796d2Signer iSO9796d2Signer = this;
                    byArray2 = iSO9796d2Signer.mBuf;
                    if (!iSO9796d2Signer.isSameAs(byArray2, iSO9796d2Signer.recoveredMessage)) {
                        return this.returnFalse(byArray);
                    }
                }
                ISO9796d2Signer iSO9796d2Signer = this;
                iSO9796d2Signer.clearBlock(iSO9796d2Signer.mBuf);
                this.clearBlock(byArray);
                this.messageLength = 0;
                return true;
            }
            throw new IllegalArgumentException("unrecognised hash in signature");
        }
        throw new IllegalStateException("updateWithRecoveredMessage called on different signature");
    }

    @Override
    public boolean hasFullMessage() {
        return this.fullMessage;
    }

    @Override
    public byte[] getRecoveredMessage() {
        return this.recoveredMessage;
    }
}

