/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSABlindingParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class PSSSigner
implements Signer {
    public static final byte TRAILER_IMPLICIT = -68;
    private Digest contentDigest;
    private Digest mgfDigest;
    private AsymmetricBlockCipher cipher;
    private SecureRandom random;
    private int hLen;
    private int mgfhLen;
    private boolean sSet;
    private int sLen;
    private int emBits;
    private byte[] salt;
    private byte[] mDash;
    private byte[] block;
    private byte trailer;

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n3) {
        this(asymmetricBlockCipher, digest, n3, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, int n3) {
        this(asymmetricBlockCipher, digest, digest2, n3, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n3, byte by) {
        Digest digest2 = digest;
        this(asymmetricBlockCipher, digest2, digest2, n3, by);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, int n3, byte by) {
        PSSSigner pSSSigner = this;
        this.cipher = asymmetricBlockCipher;
        this.contentDigest = digest;
        this.mgfDigest = digest2;
        this.hLen = digest.getDigestSize();
        pSSSigner.mgfhLen = digest2.getDigestSize();
        pSSSigner.sSet = false;
        this.sLen = n3;
        this.salt = new byte[n3];
        this.mDash = new byte[n3 + 8 + this.hLen];
        this.trailer = by;
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, byte[] byArray) {
        Digest digest2 = digest;
        this(asymmetricBlockCipher, digest2, digest2, byArray, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray) {
        this(asymmetricBlockCipher, digest, digest2, byArray, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray, byte by) {
        int n3;
        PSSSigner pSSSigner = this;
        this.cipher = asymmetricBlockCipher;
        this.contentDigest = digest;
        this.mgfDigest = digest2;
        this.hLen = digest.getDigestSize();
        pSSSigner.mgfhLen = digest2.getDigestSize();
        pSSSigner.sSet = true;
        this.sLen = n3 = byArray.length;
        this.salt = byArray;
        this.mDash = new byte[n3 + 8 + this.hLen];
        this.trailer = by;
    }

    private void clearBlock(byte[] byArray) {
        for (int i3 = 0; i3 != byArray.length; ++i3) {
            byArray[i3] = 0;
        }
    }

    private void ItoOSP(int n3, byte[] byArray) {
        byArray[0] = (byte)(n3 >>> 24);
        byArray[1] = (byte)(n3 >>> 16);
        byArray[2] = (byte)(n3 >>> 8);
        byArray[3] = (byte)(n3 >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n3, int n4, int n5) {
        int n6;
        int n7;
        PSSSigner pSSSigner = this;
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[pSSSigner.mgfhLen];
        int n8 = 4;
        byte[] byArray4 = new byte[4];
        pSSSigner.mgfDigest.reset();
        for (n7 = 0; n7 < n5 / (n6 = this.mgfhLen); ++n7) {
            PSSSigner pSSSigner2 = this;
            pSSSigner2.ItoOSP(n7, byArray4);
            pSSSigner2.mgfDigest.update(byArray, n3, n4);
            pSSSigner2.mgfDigest.update(byArray4, 0, n8);
            pSSSigner2.mgfDigest.doFinal(byArray3, 0);
            n6 = pSSSigner2.mgfhLen;
            int n9 = n7 * n6;
            System.arraycopy(byArray3, 0, byArray2, n9, n6);
        }
        if (n7 * n6 < n5) {
            int n10 = n7;
            PSSSigner pSSSigner3 = this;
            pSSSigner3.ItoOSP(n7, byArray4);
            pSSSigner3.mgfDigest.update(byArray, n3, n4);
            pSSSigner3.mgfDigest.update(byArray4, 0, n8);
            pSSSigner3.mgfDigest.doFinal(byArray3, 0);
            int n11 = pSSSigner3.mgfhLen;
            int n12 = n10 * n11;
            n11 = n5 - n10 * n11;
            System.arraycopy(byArray3, 0, byArray2, n12, n11);
        }
        return byArray2;
    }

    @Override
    public void init(boolean n3, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            cipherParameters2 = parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            if (n3) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            cipherParameters2 = cipherParameters;
        }
        if (cipherParameters2 instanceof RSABlindingParameters) {
            cipherParameters2 = ((RSABlindingParameters)cipherParameters2).getPublicKey();
            this.cipher.init(n3 != 0, cipherParameters);
        } else {
            cipherParameters = (RSAKeyParameters)cipherParameters2;
            this.cipher.init(n3 != 0, cipherParameters2);
            cipherParameters2 = cipherParameters;
        }
        n3 = ((RSAKeyParameters)cipherParameters2).getModulus().bitLength() - 1;
        PSSSigner pSSSigner = this;
        pSSSigner.emBits = n3;
        int n4 = pSSSigner.hLen * 8;
        if (n3 >= pSSSigner.sLen * 8 + n4 + 9) {
            this.block = new byte[(n3 + 7) / 8];
            this.reset();
            return;
        }
        throw new IllegalArgumentException("key too small for specified hash and salt lengths");
    }

    @Override
    public void update(byte by) {
        this.contentDigest.update(by);
    }

    @Override
    public void update(byte[] byArray, int n3, int n4) {
        this.contentDigest.update(byArray, n3, n4);
    }

    @Override
    public void reset() {
        this.contentDigest.reset();
    }

    @Override
    public byte[] generateSignature() {
        PSSSigner pSSSigner = this;
        pSSSigner.contentDigest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        if (pSSSigner.sLen != 0) {
            if (!this.sSet) {
                this.random.nextBytes(this.salt);
            }
            byte[] byArray = this.mDash;
            int n3 = this.sLen;
            int n4 = this.mDash.length - n3;
            System.arraycopy(this.salt, 0, byArray, n4, n3);
        }
        PSSSigner pSSSigner2 = this;
        int n5 = pSSSigner2.hLen;
        byte[] byArray = new byte[n5];
        pSSSigner2.contentDigest.update(this.mDash, 0, this.mDash.length);
        pSSSigner2.contentDigest.doFinal(byArray, 0);
        byte[] byArray2 = pSSSigner2.block;
        PSSSigner pSSSigner3 = this;
        int n6 = this.sLen;
        int n7 = this.hLen;
        byArray2[byArray2.length - n6 - 1 - n7 - 1] = 1;
        n7 = byArray2.length - n6 - n7 - 1;
        System.arraycopy(pSSSigner3.salt, 0, byArray2, n7, n6);
        int n8 = pSSSigner3.block.length - this.hLen - 1;
        byte[] byArray3 = pSSSigner2.maskGeneratorFunction1(byArray, 0, n5, n8);
        for (n8 = 0; n8 != byArray3.length; ++n8) {
            this.block[n8] = (byte)(this.block[n8] ^ byArray3[n8]);
        }
        PSSSigner pSSSigner4 = this;
        byArray3 = this.block;
        int n9 = this.hLen;
        n8 = this.block.length - n9 - 1;
        System.arraycopy(byArray, 0, byArray3, n8, n9);
        byte[] byArray4 = byArray3 = pSSSigner4.block;
        n9 = 255 >>> byArray4.length * 8 - this.emBits;
        byArray4[0] = (byte)(byArray3[0] & n9);
        n9 = byArray3.length - 1;
        pSSSigner4.block[n9] = this.trailer;
        byte[] byArray5 = pSSSigner4.cipher.processBlock(byArray3, 0, byArray3.length);
        PSSSigner pSSSigner5 = this;
        pSSSigner5.clearBlock(pSSSigner5.block);
        return byArray5;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        byte[] byArray2;
        PSSSigner pSSSigner = this;
        pSSSigner.contentDigest.doFinal(this.mDash, this.mDash.length - this.hLen - this.sLen);
        AsymmetricBlockCipher asymmetricBlockCipher = pSSSigner.cipher;
        int n3 = 0;
        byte[] byArray3 = asymmetricBlockCipher.processBlock(byArray, n3, byArray.length);
        PSSSigner pSSSigner2 = this;
        PSSSigner pSSSigner3 = pSSSigner2;
        byte[] byArray4 = pSSSigner2.block;
        int n4 = 0;
        int n5 = byArray4.length - byArray3.length;
        Arrays.fill(pSSSigner2.block, n4, n5, (byte)0);
        int n6 = 0;
        byte[] byArray5 = pSSSigner3.block;
        int n7 = pSSSigner3.block.length - byArray3.length;
        int n8 = byArray3.length;
        try {
            System.arraycopy(byArray3, n6, byArray5, n7, n8);
            byArray2 = pSSSigner.block;
        }
        catch (Exception exception) {
            return false;
        }
        n6 = 255 >>> byArray2.length * 8 - this.emBits;
        int n9 = pSSSigner.block[0];
        if ((n9 & 0xFF) == (n9 & n6) && byArray2[byArray2.length - 1] == this.trailer) {
            byte[] byArray6;
            byte[] byArray7;
            int n10 = this.hLen;
            n9 = byArray2.length - n10 - 1;
            n8 = byArray2.length - n10 - 1;
            byte[] byArray8 = this.maskGeneratorFunction1(byArray2, n9, n10, n8);
            for (n9 = 0; n9 != byArray8.length; ++n9) {
                this.block[n9] = (byte)(this.block[n9] ^ byArray8[n9]);
            }
            this.block[0] = (byte)(this.block[0] & n6);
            int n11 = 0;
            while (true) {
                byArray7 = this.block;
                n9 = this.hLen;
                n8 = this.sLen;
                if (n11 == this.block.length - n9 - n8 - 2) break;
                if (byArray7[n11] != 0) {
                    this.clearBlock(byArray7);
                    return false;
                }
                ++n11;
            }
            if (byArray7[a.a(byArray7.length, n9, n8, 2)] != 1) {
                this.clearBlock(byArray7);
                return false;
            }
            if (this.sSet) {
                byte[] byArray9 = this.mDash;
                int n12 = this.mDash.length - n8;
                System.arraycopy(this.salt, 0, byArray9, n12, n8);
            } else {
                byte[] byArray10 = byArray7;
                n11 = a.a(byArray7.length, n8, n9, 1);
                byArray7 = this.mDash;
                System.arraycopy(byArray10, n11, byArray7, byArray7.length - n8, n8);
            }
            PSSSigner pSSSigner4 = this;
            pSSSigner4.contentDigest.update(this.mDash, 0, this.mDash.length);
            pSSSigner4.contentDigest.doFinal(this.mDash, this.mDash.length - this.hLen);
            int n13 = this.hLen;
            int n14 = pSSSigner4.block.length - n13 - 1;
            n13 = pSSSigner4.mDash.length - n13;
            while (true) {
                byArray6 = this.mDash;
                if (n13 == this.mDash.length) break;
                if ((this.block[n14] ^ byArray6[n13]) != 0) {
                    PSSSigner pSSSigner5 = this;
                    pSSSigner5.clearBlock(byArray6);
                    pSSSigner5.clearBlock(pSSSigner5.block);
                    return false;
                }
                ++n14;
                ++n13;
            }
            PSSSigner pSSSigner6 = this;
            pSSSigner6.clearBlock(byArray6);
            pSSSigner6.clearBlock(pSSSigner6.block);
            return true;
        }
        this.clearBlock(byArray2);
        return false;
    }
}

