/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAEncoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class PlainDSAEncoding
implements DSAEncoding {
    public static final PlainDSAEncoding INSTANCE = new PlainDSAEncoding();

    private void encodeValue(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n3, int n4) {
        byte[] byArray2 = ((PlainDSAEncoding)this).checkValue(bigInteger, bigInteger2).toByteArray();
        Object object = this = (Object)byArray2;
        int n5 = Math.max(0, ((Object)object).length - n4);
        int n6 = ((Object)object).length - n5;
        int n7 = n4 - n6 + n3;
        Arrays.fill(byArray, n3, n7, (byte)0);
        System.arraycopy(byArray2, n5, byArray, n7, n6);
    }

    @Override
    public byte[] encode(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        int n3 = BigIntegers.getUnsignedByteLength(bigInteger);
        byte[] byArray = new byte[n3 * 2];
        this.encodeValue(bigInteger, bigInteger2, byArray, 0, n3);
        int n4 = n3;
        this.encodeValue(bigInteger, bigInteger3, byArray, n4, n4);
        return byArray;
    }

    @Override
    public BigInteger[] decode(BigInteger bigInteger, byte[] byArray) {
        int n3 = BigIntegers.getUnsignedByteLength(bigInteger);
        if (byArray.length == n3 * 2) {
            BigInteger[] bigIntegerArray = new BigInteger[2];
            bigIntegerArray[0] = this.decodeValue(bigInteger, byArray, 0, n3);
            int n4 = n3;
            bigIntegerArray[1] = this.decodeValue(bigInteger, byArray, n4, n4);
            return bigIntegerArray;
        }
        throw new IllegalArgumentException("Encoding has incorrect length");
    }

    public BigInteger checkValue(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.signum() >= 0 && bigInteger2.compareTo(bigInteger) < 0) {
            return bigInteger2;
        }
        throw new IllegalArgumentException("Value out of range");
    }

    public BigInteger decodeValue(BigInteger bigInteger, byte[] byArray, int n3, int n4) {
        PlainDSAEncoding plainDSAEncoding = object;
        int n5 = n3;
        Object object = Arrays.copyOfRange(byArray, n5, n5 + n4);
        return plainDSAEncoding.checkValue(bigInteger, new BigInteger(1, (byte[])object));
    }
}

