/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAEncoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class StandardDSAEncoding
implements DSAEncoding {
    public static final StandardDSAEncoding INSTANCE = new StandardDSAEncoding();

    @Override
    public byte[] encode(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        ASN1EncodableVector aSN1EncodableVector;
        StandardDSAEncoding standardDSAEncoding = aSN1EncodableVector2;
        StandardDSAEncoding standardDSAEncoding2 = aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        standardDSAEncoding2.encodeValue(bigInteger, aSN1EncodableVector2, bigInteger2);
        standardDSAEncoding.encodeValue(bigInteger, aSN1EncodableVector2, bigInteger3);
        return new DERSequence(aSN1EncodableVector2).getEncoded("DER");
    }

    @Override
    public BigInteger[] decode(BigInteger bigInteger, byte[] byArray) {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Primitive.fromByteArray(byArray);
        if (aSN1Sequence.size() == 2 && Arrays.areEqual(((StandardDSAEncoding)this).encode(bigInteger, (BigInteger)(this = ((StandardDSAEncoding)this).decodeValue(bigInteger, aSN1Sequence, 0)), bigInteger = ((StandardDSAEncoding)this).decodeValue(bigInteger, aSN1Sequence, 1)), byArray)) {
            return new BigInteger[]{this, bigInteger};
        }
        throw new IllegalArgumentException("Malformed signature");
    }

    public BigInteger checkValue(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.signum() >= 0 && (bigInteger == null || bigInteger2.compareTo(bigInteger) < 0)) {
            return bigInteger2;
        }
        throw new IllegalArgumentException("Value out of range");
    }

    public BigInteger decodeValue(BigInteger bigInteger, ASN1Sequence aSN1Sequence, int n3) {
        return this.checkValue(bigInteger, ((ASN1Integer)aSN1Sequence.getObjectAt(n3)).getValue());
    }

    public void encodeValue(BigInteger bigInteger, ASN1EncodableVector aSN1EncodableVector, BigInteger bigInteger2) {
        aSN1EncodableVector.add(new ASN1Integer(this.checkValue(bigInteger, bigInteger2)));
    }
}

