/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.DESKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.DESedeKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.AlgorithmIdentifierFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.a;
import java.security.SecureRandom;

public class CipherKeyGeneratorFactory {
    private CipherKeyGeneratorFactory() {
    }

    public static CipherKeyGenerator createKeyGenerator(ASN1ObjectIdentifier object, SecureRandom secureRandom) {
        if (NISTObjectIdentifiers.id_aes128_CBC.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (NISTObjectIdentifiers.id_aes192_CBC.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 192);
        }
        if (NISTObjectIdentifiers.id_aes256_CBC.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 256);
        }
        if (NISTObjectIdentifiers.id_aes128_GCM.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (NISTObjectIdentifiers.id_aes192_GCM.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 192);
        }
        if (NISTObjectIdentifiers.id_aes256_GCM.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 256);
        }
        if (PKCSObjectIdentifiers.des_EDE3_CBC.equals((ASN1Primitive)object)) {
            KeyGenerationParameters keyGenerationParameters;
            DESedeKeyGenerator dESedeKeyGenerator = new DESedeKeyGenerator();
            object = keyGenerationParameters;
            keyGenerationParameters = new KeyGenerationParameters(secureRandom, 192);
            dESedeKeyGenerator.init((KeyGenerationParameters)object);
            return dESedeKeyGenerator;
        }
        if (NTTObjectIdentifiers.id_camellia128_cbc.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (NTTObjectIdentifiers.id_camellia192_cbc.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 192);
        }
        if (NTTObjectIdentifiers.id_camellia256_cbc.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 256);
        }
        if (KISAObjectIdentifiers.id_seedCBC.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (AlgorithmIdentifierFactory.CAST5_CBC.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (OIWObjectIdentifiers.desCBC.equals((ASN1Primitive)object)) {
            KeyGenerationParameters keyGenerationParameters;
            DESKeyGenerator dESKeyGenerator = new DESKeyGenerator();
            object = keyGenerationParameters;
            keyGenerationParameters = new KeyGenerationParameters(secureRandom, 64);
            dESKeyGenerator.init((KeyGenerationParameters)object);
            return dESKeyGenerator;
        }
        if (PKCSObjectIdentifiers.rc4.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        if (PKCSObjectIdentifiers.RC2_CBC.equals((ASN1Primitive)object)) {
            return CipherKeyGeneratorFactory.createCipherKeyGenerator(secureRandom, 128);
        }
        throw new IllegalArgumentException(a.a("cannot recognise cipher: ", (ASN1ObjectIdentifier)object));
    }

    private static CipherKeyGenerator createCipherKeyGenerator(SecureRandom secureRandom, int n3) {
        KeyGenerationParameters keyGenerationParameters;
        CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
        KeyGenerationParameters keyGenerationParameters2 = keyGenerationParameters;
        keyGenerationParameters = new KeyGenerationParameters(secureRandom, n3);
        cipherKeyGenerator.init(keyGenerationParameters2);
        return cipherKeyGenerator;
    }
}

