/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;

public class JournalingSecureRandom
extends SecureRandom {
    private static byte[] EMPTY_TRANSCRIPT = new byte[0];
    private final SecureRandom base;
    private TranscriptStream tOut;
    private byte[] transcript;
    private int index;

    public JournalingSecureRandom() {
        this(CryptoServicesRegistrar.getSecureRandom());
    }

    public JournalingSecureRandom(SecureRandom secureRandom) {
        JournalingSecureRandom journalingSecureRandom = this;
        this.tOut = new TranscriptStream(null);
        this.index = 0;
        journalingSecureRandom.base = secureRandom;
        journalingSecureRandom.transcript = EMPTY_TRANSCRIPT;
    }

    public JournalingSecureRandom(byte[] byArray, SecureRandom secureRandom) {
        this.tOut = new TranscriptStream(null);
        this.index = 0;
        this.base = secureRandom;
        this.transcript = Arrays.clone(byArray);
    }

    @Override
    public final void nextBytes(byte[] byArray) {
        if (this.index >= this.transcript.length) {
            this.base.nextBytes(byArray);
        } else {
            int n3;
            int n4;
            for (n4 = 0; n4 != byArray.length; ++n4) {
                n3 = this.index;
                byte[] byArray2 = this.transcript;
                if (n3 >= this.transcript.length) break;
                this.index = n3 + 1;
                byArray[n4] = byArray2[n3];
            }
            if (n4 != byArray.length) {
                n3 = byArray.length - n4;
                byte[] byArray3 = new byte[n3];
                this.base.nextBytes(byArray3);
                System.arraycopy(byArray3, 0, byArray, n4, n3);
            }
        }
        try {
            this.tOut.write(byArray);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(b.a(iOException, b.b.a("unable to record transcript: ")));
        }
    }

    public void clear() {
        JournalingSecureRandom journalingSecureRandom = this;
        Arrays.fill(journalingSecureRandom.transcript, (byte)0);
        journalingSecureRandom.tOut.clear();
    }

    public void reset() {
        this.index = 0;
        if (this.transcript.length == 0) {
            this.transcript = this.tOut.toByteArray();
        }
        this.tOut.reset();
    }

    public byte[] getTranscript() {
        return this.tOut.toByteArray();
    }

    public byte[] getFullTranscript() {
        byte[] byArray = this.transcript;
        if (this.index == this.transcript.length) {
            return this.tOut.toByteArray();
        }
        return Arrays.clone(byArray);
    }

    public class TranscriptStream
    extends ByteArrayOutputStream {
        private TranscriptStream() {
        }

        public /* synthetic */ TranscriptStream(1 var2_2) {
            this();
        }

        public void clear() {
            Arrays.fill(this.buf, (byte)0);
        }
    }
}

