/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.SSHBuffer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.SSHBuilder;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.SSHNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.math.BigInteger;

public class OpenSSHPrivateKeyUtil {
    public static final byte[] AUTH_MAGIC = Strings.toByteArray("openssh-key-v1\u0000");

    private OpenSSHPrivateKeyUtil() {
    }

    public static byte[] encodePrivateKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        if (asymmetricKeyParameter != null) {
            if (asymmetricKeyParameter instanceof RSAPrivateCrtKeyParameters) {
                return PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter).parsePrivateKey().toASN1Primitive().getEncoded();
            }
            if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
                return PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter).parsePrivateKey().toASN1Primitive().getEncoded();
            }
            if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
                ASN1EncodableVector aSN1EncodableVector;
                ASN1EncodableVector aSN1EncodableVector2;
                asymmetricKeyParameter = (DSAPrivateKeyParameters)asymmetricKeyParameter;
                Object object = ((DSAKeyParameters)asymmetricKeyParameter).getParameters();
                ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2 = aSN1EncodableVector;
                aSN1EncodableVector3();
                aSN1EncodableVector3.add(new ASN1Integer(0L));
                aSN1EncodableVector3.add(new ASN1Integer(((DSAParameters)object).getP()));
                aSN1EncodableVector3.add(new ASN1Integer(((DSAParameters)object).getQ()));
                aSN1EncodableVector3.add(new ASN1Integer(((DSAParameters)object).getG()));
                BigInteger bigInteger = ((DSAParameters)object).getG();
                DSAParameters dSAParameters = object;
                object = ((DSAPrivateKeyParameters)asymmetricKeyParameter).getX();
                object = bigInteger.modPow((BigInteger)object, dSAParameters.getP());
                aSN1EncodableVector.add(new ASN1Integer((BigInteger)object));
                aSN1EncodableVector.add(new ASN1Integer(((DSAPrivateKeyParameters)asymmetricKeyParameter).getX()));
                try {
                    return new DERSequence(aSN1EncodableVector2).getEncoded();
                }
                catch (Exception exception) {
                    throw new IllegalStateException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a.a(exception, b.a("unable to encode DSAPrivateKeyParameters ")));
                }
            }
            if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
                SSHBuilder sSHBuilder;
                SSHBuilder sSHBuilder2;
                asymmetricKeyParameter = (Ed25519PrivateKeyParameters)asymmetricKeyParameter;
                Ed25519PublicKeyParameters ed25519PublicKeyParameters = ((Ed25519PrivateKeyParameters)asymmetricKeyParameter).generatePublicKey();
                SSHBuilder sSHBuilder3 = new SSHBuilder();
                sSHBuilder3.writeBytes(AUTH_MAGIC);
                sSHBuilder3.writeString("none");
                sSHBuilder3.writeString("none");
                sSHBuilder3.writeString("");
                sSHBuilder3.u32(1);
                sSHBuilder3.writeBlock(OpenSSHPublicKeyUtil.encodePublicKey(ed25519PublicKeyParameters));
                SSHBuilder sSHBuilder4 = sSHBuilder2 = sSHBuilder;
                sSHBuilder4();
                int n3 = CryptoServicesRegistrar.getSecureRandom().nextInt();
                sSHBuilder4.u32(n3);
                sSHBuilder4.u32(n3);
                sSHBuilder4.writeString("ssh-ed25519");
                byte[] byArray = ed25519PublicKeyParameters.getEncoded();
                sSHBuilder2.writeBlock(byArray);
                sSHBuilder.writeBlock(Arrays.concatenate(((Ed25519PrivateKeyParameters)asymmetricKeyParameter).getEncoded(), byArray));
                sSHBuilder.writeString("");
                sSHBuilder3.writeBlock(sSHBuilder.getPaddedBytes());
                return sSHBuilder3.getBytes();
            }
            throw new IllegalArgumentException(b.a("unable to convert ").append(asymmetricKeyParameter.getClass().getName()).append(" to openssh private key").toString());
        }
        throw new IllegalArgumentException("param is null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AsymmetricKeyParameter parsePrivateKeyBlob(byte[] object) {
        Object object2 = null;
        if (object[0] == 48) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(object);
            if (aSN1Sequence.size() == 6) {
                if (OpenSSHPrivateKeyUtil.allIntegers(aSN1Sequence) && ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    DSAPrivateKeyParameters dSAPrivateKeyParameters;
                    object2 = dSAPrivateKeyParameters;
                    ASN1Sequence aSN1Sequence2 = aSN1Sequence;
                    BigInteger bigInteger = ((ASN1Integer)aSN1Sequence2.getObjectAt(1)).getPositiveValue();
                    BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence2.getObjectAt(2)).getPositiveValue();
                    BigInteger bigInteger3 = ((ASN1Integer)aSN1Sequence2.getObjectAt(3)).getPositiveValue();
                    dSAPrivateKeyParameters = new DSAPrivateKeyParameters(((ASN1Integer)aSN1Sequence.getObjectAt(5)).getPositiveValue(), new DSAParameters(bigInteger, bigInteger2, bigInteger3));
                }
            } else if (aSN1Sequence.size() == 9) {
                if (OpenSSHPrivateKeyUtil.allIntegers(aSN1Sequence) && ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getPositiveValue().equals(BigIntegers.ZERO)) {
                    RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters;
                    RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance(aSN1Sequence);
                    object2 = rSAPrivateCrtKeyParameters;
                    RSAPrivateKey rSAPrivateKey2 = rSAPrivateKey;
                    BigInteger bigInteger = rSAPrivateKey2.getModulus();
                    BigInteger bigInteger4 = rSAPrivateKey2.getPublicExponent();
                    BigInteger bigInteger5 = rSAPrivateKey2.getPrivateExponent();
                    BigInteger bigInteger6 = rSAPrivateKey2.getPrime1();
                    BigInteger bigInteger7 = rSAPrivateKey2.getPrime2();
                    BigInteger bigInteger8 = rSAPrivateKey2.getExponent1();
                    BigInteger bigInteger9 = rSAPrivateKey2.getExponent2();
                    BigInteger bigInteger10 = rSAPrivateKey2.getCoefficient();
                    rSAPrivateCrtKeyParameters = new RSAPrivateCrtKeyParameters(bigInteger, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8, bigInteger9, bigInteger10);
                }
            } else if (aSN1Sequence.size() == 4 && aSN1Sequence.getObjectAt(3) instanceof ASN1TaggedObject && aSN1Sequence.getObjectAt(2) instanceof ASN1TaggedObject) {
                ECPrivateKeyParameters eCPrivateKeyParameters;
                ECPrivateKey eCPrivateKey = ECPrivateKey.getInstance(aSN1Sequence);
                object2 = (ASN1ObjectIdentifier)eCPrivateKey.getParameters();
                X9ECParameters x9ECParameters = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)object2);
                ECPrivateKeyParameters eCPrivateKeyParameters2 = eCPrivateKeyParameters;
                eCPrivateKeyParameters = new ECPrivateKeyParameters(eCPrivateKey.getKey(), (ECDomainParameters)new ECNamedDomainParameters((ASN1ObjectIdentifier)object2, x9ECParameters));
                object2 = eCPrivateKeyParameters2;
            }
        } else {
            SSHBuffer sSHBuffer;
            SSHBuffer sSHBuffer2;
            SSHBuffer sSHBuffer3 = sSHBuffer2;
            if (!"none".equals(new SSHBuffer(AUTH_MAGIC, (byte[])object).readString())) throw new IllegalStateException("encrypted keys not supported");
            SSHBuffer sSHBuffer4 = sSHBuffer3;
            sSHBuffer4.skipBlock();
            sSHBuffer4.skipBlock();
            if (sSHBuffer4.readU32() != 1) throw new IllegalStateException("multiple keys not supported");
            SSHBuffer sSHBuffer5 = sSHBuffer3;
            OpenSSHPublicKeyUtil.parsePublicKey(sSHBuffer5.readBlock());
            byte[] byArray = sSHBuffer5.readPaddedBlock();
            if (sSHBuffer5.hasRemaining()) throw new IllegalArgumentException("decoded key has trailing data");
            sSHBuffer3 = sSHBuffer;
            if (new SSHBuffer(byArray).readU32() != sSHBuffer3.readU32()) throw new IllegalStateException("private key check values are not the same");
            String string2 = sSHBuffer3.readString();
            if ("ssh-ed25519".equals(string2)) {
                Ed25519PrivateKeyParameters ed25519PrivateKeyParameters;
                SSHBuffer sSHBuffer6 = sSHBuffer3;
                sSHBuffer6.readBlock();
                byte[] byArray2 = sSHBuffer6.readBlock();
                if (byArray2.length != 64) throw new IllegalStateException("private key value of wrong length");
                object2 = ed25519PrivateKeyParameters;
                ed25519PrivateKeyParameters = new Ed25519PrivateKeyParameters(byArray2, 0);
            } else if (string2.startsWith("ecdsa")) {
                ECNamedDomainParameters eCNamedDomainParameters;
                BigInteger bigInteger;
                ECPrivateKeyParameters eCPrivateKeyParameters;
                object2 = SSHNamedCurves.getByName(Strings.fromByteArray(sSHBuffer3.readBlock()));
                if (object2 == null) throw new IllegalStateException(i.a("OID not found for: ", string2));
                X9ECParameters x9ECParameters = NISTNamedCurves.getByOID((ASN1ObjectIdentifier)object2);
                if (x9ECParameters == null) throw new IllegalStateException(a.a("Curve not found for: ", (ASN1ObjectIdentifier)object2));
                SSHBuffer sSHBuffer7 = sSHBuffer3;
                sSHBuffer7.readBlock();
                byte[] byArray3 = sSHBuffer7.readBlock();
                ECPrivateKeyParameters eCPrivateKeyParameters3 = eCPrivateKeyParameters;
                BigInteger bigInteger11 = bigInteger;
                bigInteger = new BigInteger(1, byArray3);
                ECNamedDomainParameters eCNamedDomainParameters2 = eCNamedDomainParameters;
                eCNamedDomainParameters = new ECNamedDomainParameters((ASN1ObjectIdentifier)object2, x9ECParameters);
                eCPrivateKeyParameters = new ECPrivateKeyParameters(bigInteger11, (ECDomainParameters)eCNamedDomainParameters2);
                object2 = eCPrivateKeyParameters3;
            }
            SSHBuffer sSHBuffer8 = sSHBuffer3;
            sSHBuffer8.skipBlock();
            if (sSHBuffer8.hasRemaining()) throw new IllegalArgumentException("private key block has trailing data");
        }
        if (object2 == null) throw new IllegalArgumentException("unable to parse key");
        return object2;
    }

    private static boolean allIntegers(ASN1Sequence aSN1Sequence) {
        for (int i3 = 0; i3 < aSN1Sequence.size(); ++i3) {
            if (aSN1Sequence.getObjectAt(i3) instanceof ASN1Integer) continue;
            return false;
        }
        return true;
    }
}

