/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.SSHBuffer;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.SSHBuilder;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.SSHNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class OpenSSHPublicKeyUtil {
    private static final String RSA = "ssh-rsa";
    private static final String ECDSA = "ecdsa";
    private static final String ED_25519 = "ssh-ed25519";
    private static final String DSS = "ssh-dss";

    private OpenSSHPublicKeyUtil() {
    }

    public static AsymmetricKeyParameter parsePublicKey(byte[] byArray) {
        return OpenSSHPublicKeyUtil.parsePublicKey(new SSHBuffer(byArray));
    }

    public static byte[] encodePublicKey(AsymmetricKeyParameter object) {
        if (object != null) {
            if (object instanceof RSAKeyParameters) {
                if (!((AsymmetricKeyParameter)object).isPrivate()) {
                    SSHBuilder sSHBuilder;
                    SSHBuilder sSHBuilder2;
                    object = (RSAKeyParameters)object;
                    SSHBuilder sSHBuilder3 = sSHBuilder2 = sSHBuilder;
                    sSHBuilder3();
                    sSHBuilder3.writeString(RSA);
                    sSHBuilder2.writeBigNum(((RSAKeyParameters)object).getExponent());
                    sSHBuilder.writeBigNum(((RSAKeyParameters)object).getModulus());
                    return sSHBuilder.getBytes();
                }
                throw new IllegalArgumentException("RSAKeyParamaters was for encryption");
            }
            if (object instanceof ECPublicKeyParameters) {
                SSHBuilder sSHBuilder;
                AsymmetricKeyParameter asymmetricKeyParameter = object;
                object = sSHBuilder;
                sSHBuilder = new SSHBuilder();
                ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricKeyParameter;
                String string2 = SSHNamedCurves.getNameForParameters(eCPublicKeyParameters.getParameters());
                if (string2 != null) {
                    Object object2 = object;
                    ((SSHBuilder)object).writeString(i.a("ecdsa-sha2-", string2));
                    ((SSHBuilder)object).writeString(string2);
                    ((SSHBuilder)object2).writeBlock(eCPublicKeyParameters.getQ().getEncoded(false));
                    return ((SSHBuilder)object2).getBytes();
                }
                throw new IllegalArgumentException(b.a("unable to derive ssh curve name for ").append(eCPublicKeyParameters.getParameters().getCurve().getClass().getName()).toString());
            }
            if (object instanceof DSAPublicKeyParameters) {
                SSHBuilder sSHBuilder;
                SSHBuilder sSHBuilder4;
                object = (DSAPublicKeyParameters)object;
                DSAParameters dSAParameters = ((DSAKeyParameters)object).getParameters();
                SSHBuilder sSHBuilder5 = sSHBuilder4 = sSHBuilder;
                sSHBuilder5();
                sSHBuilder5.writeString(DSS);
                sSHBuilder4.writeBigNum(dSAParameters.getP());
                sSHBuilder4.writeBigNum(dSAParameters.getQ());
                sSHBuilder4.writeBigNum(dSAParameters.getG());
                sSHBuilder.writeBigNum(((DSAPublicKeyParameters)object).getY());
                return sSHBuilder.getBytes();
            }
            if (object instanceof Ed25519PublicKeyParameters) {
                SSHBuilder sSHBuilder = new SSHBuilder();
                sSHBuilder.writeString(ED_25519);
                sSHBuilder.writeBlock(((Ed25519PublicKeyParameters)object).getEncoded());
                return sSHBuilder.getBytes();
            }
            throw new IllegalArgumentException(b.a("unable to convert ").append(object.getClass().getName()).append(" to private key").toString());
        }
        throw new IllegalArgumentException("cipherParameters was null.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AsymmetricKeyParameter parsePublicKey(SSHBuffer sSHBuffer) {
        Object object = null;
        Object object2 = sSHBuffer.readString();
        if (RSA.equals(object2)) {
            RSAKeyParameters rSAKeyParameters;
            SSHBuffer sSHBuffer2 = sSHBuffer;
            object = sSHBuffer2.readBigNumPositive();
            object2 = sSHBuffer2.readBigNumPositive();
            RSAKeyParameters rSAKeyParameters2 = rSAKeyParameters;
            rSAKeyParameters = new RSAKeyParameters(false, (BigInteger)object2, (BigInteger)object);
            object = rSAKeyParameters2;
        } else if (DSS.equals(object2)) {
            DSAParameters dSAParameters;
            DSAPublicKeyParameters dSAPublicKeyParameters;
            SSHBuffer sSHBuffer3 = sSHBuffer;
            object = sSHBuffer3.readBigNumPositive();
            object2 = sSHBuffer3.readBigNumPositive();
            BigInteger bigInteger = sSHBuffer3.readBigNumPositive();
            BigInteger bigInteger2 = sSHBuffer3.readBigNumPositive();
            DSAPublicKeyParameters dSAPublicKeyParameters2 = dSAPublicKeyParameters;
            DSAParameters dSAParameters2 = dSAParameters;
            dSAParameters = new DSAParameters((BigInteger)object, (BigInteger)object2, bigInteger);
            dSAPublicKeyParameters = new DSAPublicKeyParameters(bigInteger2, dSAParameters2);
            object = dSAPublicKeyParameters2;
        } else if (((String)object2).startsWith(ECDSA)) {
            ECNamedDomainParameters eCNamedDomainParameters;
            ECPublicKeyParameters eCPublicKeyParameters;
            object = sSHBuffer.readString();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = SSHNamedCurves.getByName((String)object);
            X9ECParameters x9ECParameters = SSHNamedCurves.getParameters(aSN1ObjectIdentifier);
            if (x9ECParameters == null) throw new IllegalStateException("unable to find curve for " + (String)object2 + " using curve name " + (String)object);
            object = x9ECParameters.getCurve();
            object2 = sSHBuffer.readBlock();
            ECPublicKeyParameters eCPublicKeyParameters2 = eCPublicKeyParameters;
            object = ((ECCurve)object).decodePoint((byte[])object2);
            object2 = eCNamedDomainParameters;
            eCNamedDomainParameters = new ECNamedDomainParameters(aSN1ObjectIdentifier, x9ECParameters);
            eCPublicKeyParameters = new ECPublicKeyParameters((ECPoint)object, (ECDomainParameters)object2);
            object = eCPublicKeyParameters2;
        } else if (ED_25519.equals(object2)) {
            Ed25519PublicKeyParameters ed25519PublicKeyParameters;
            byte[] byArray = sSHBuffer.readBlock();
            object = byArray;
            if (byArray.length != 32) throw new IllegalStateException("public key value of wrong length");
            object2 = ed25519PublicKeyParameters;
            ed25519PublicKeyParameters = new Ed25519PublicKeyParameters((byte[])object, 0);
            object = object2;
        }
        if (object == null) throw new IllegalArgumentException("unable to parse key");
        if (sSHBuffer.hasRemaining()) throw new IllegalArgumentException("decoded key has trailing data");
        return object;
    }
}

