/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.ElGamalParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.DHParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DSAParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.CustomNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECGOST3410Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X448PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.InputStream;
import java.math.BigInteger;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] byArray) {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo object) {
        Object object2 = ((PrivateKeyInfo)object).getPrivateKeyAlgorithm();
        Object object3 = ((AlgorithmIdentifier)object2).getAlgorithm();
        if (!(((ASN1Primitive)object3).equals(PKCSObjectIdentifiers.rsaEncryption) || ((ASN1Primitive)object3).equals(PKCSObjectIdentifiers.id_RSASSA_PSS) || ((ASN1Primitive)object3).equals(X509ObjectIdentifiers.id_ea_rsa))) {
            ECGOST3410Parameters eCGOST3410Parameters;
            Object object4;
            Object object5;
            if (((ASN1Primitive)object3).equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
                DHParameters dHParameters;
                object2 = DHParameter.getInstance(((AlgorithmIdentifier)object2).getParameters());
                object = (ASN1Integer)((PrivateKeyInfo)object).parsePrivateKey();
                object3 = ((DHParameter)object2).getL();
                int n3 = object3 == null ? 0 : ((BigInteger)object3).intValue();
                DHParameters dHParameters2 = dHParameters;
                Object object6 = object2;
                object2 = ((DHParameter)object6).getP();
                dHParameters = new DHParameters((BigInteger)object2, ((DHParameter)object6).getG(), null, n3);
                return new DHPrivateKeyParameters(((ASN1Integer)object).getValue(), dHParameters2);
            }
            if (((ASN1Primitive)object3).equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
                Object object7 = object;
                object = ElGamalParameter.getInstance(((AlgorithmIdentifier)object2).getParameters());
                object2 = (ASN1Integer)((PrivateKeyInfo)object7).parsePrivateKey();
                Object object8 = object;
                object = ((ElGamalParameter)object8).getP();
                return new ElGamalPrivateKeyParameters(((ASN1Integer)object2).getValue(), new ElGamalParameters((BigInteger)object, ((ElGamalParameter)object8).getG()));
            }
            if (((ASN1Primitive)object3).equals(X9ObjectIdentifiers.id_dsa)) {
                object = (ASN1Integer)((PrivateKeyInfo)object).parsePrivateKey();
                object2 = ((AlgorithmIdentifier)object2).getParameters();
                object3 = null;
                if (object2 != null) {
                    DSAParameters dSAParameters;
                    object2 = DSAParameter.getInstance(object2.toASN1Primitive());
                    object3 = dSAParameters;
                    Object object9 = object2;
                    object2 = ((DSAParameter)object9).getP();
                    BigInteger bigInteger = ((DSAParameter)object9).getQ();
                    BigInteger bigInteger2 = ((DSAParameter)object9).getG();
                    dSAParameters = new DSAParameters((BigInteger)object2, bigInteger, bigInteger2);
                }
                return new DSAPrivateKeyParameters(((ASN1Integer)object).getValue(), (DSAParameters)object3);
            }
            if (((ASN1Primitive)object3).equals(X9ObjectIdentifiers.id_ecPublicKey)) {
                ECDomainParameters eCDomainParameters;
                if (((X962Parameters)(object2 = X962Parameters.getInstance(((AlgorithmIdentifier)object2).getParameters()))).isNamedCurve()) {
                    ECNamedDomainParameters eCNamedDomainParameters;
                    object3 = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)(object2 = (ASN1ObjectIdentifier)((X962Parameters)object2).getParameters()));
                    if (object3 == null) {
                        object3 = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)object2);
                    }
                    eCDomainParameters = eCNamedDomainParameters;
                    eCNamedDomainParameters = new ECNamedDomainParameters((ASN1ObjectIdentifier)object2, (X9ECParameters)object3);
                } else {
                    ECDomainParameters eCDomainParameters2;
                    object2 = X9ECParameters.getInstance(((X962Parameters)object2).getParameters());
                    eCDomainParameters = eCDomainParameters2;
                    Object object10 = object2;
                    object2 = ((X9ECParameters)object10).getCurve();
                    object3 = ((X9ECParameters)object10).getG();
                    BigInteger bigInteger = ((X9ECParameters)object10).getN();
                    BigInteger bigInteger3 = ((X9ECParameters)object10).getH();
                    byte[] byArray = ((X9ECParameters)object10).getSeed();
                    eCDomainParameters2 = new ECDomainParameters((ECCurve)object2, (ECPoint)object3, bigInteger, bigInteger3, byArray);
                }
                object = ECPrivateKey.getInstance(((PrivateKeyInfo)object).parsePrivateKey()).getKey();
                return new ECPrivateKeyParameters((BigInteger)object, eCDomainParameters);
            }
            if (((ASN1Primitive)object3).equals(EdECObjectIdentifiers.id_X25519)) {
                return new X25519PrivateKeyParameters(PrivateKeyFactory.getRawKey((PrivateKeyInfo)object, 32), 0);
            }
            if (((ASN1Primitive)object3).equals(EdECObjectIdentifiers.id_X448)) {
                return new X448PrivateKeyParameters(PrivateKeyFactory.getRawKey((PrivateKeyInfo)object, 56), 0);
            }
            if (((ASN1Primitive)object3).equals(EdECObjectIdentifiers.id_Ed25519)) {
                return new Ed25519PrivateKeyParameters(PrivateKeyFactory.getRawKey((PrivateKeyInfo)object, 32), 0);
            }
            if (((ASN1Primitive)object3).equals(EdECObjectIdentifiers.id_Ed448)) {
                return new Ed448PrivateKeyParameters(PrivateKeyFactory.getRawKey((PrivateKeyInfo)object, 57), 0);
            }
            if (!(((ASN1Primitive)object3).equals(CryptoProObjectIdentifiers.gostR3410_2001) || ((ASN1Primitive)object3).equals(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512) || ((ASN1Primitive)object3).equals(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256))) {
                throw new RuntimeException("algorithm identifier in private key not recognised");
            }
            Object object11 = object;
            object2 = GOST3410PublicKeyAlgParameters.getInstance(((PrivateKeyInfo)object11).getPrivateKeyAlgorithm().getParameters());
            Object object12 = ((PrivateKeyInfo)object11).getPrivateKeyAlgorithm().getParameters().toASN1Primitive();
            if (object12 instanceof ASN1Sequence && (ASN1Sequence.getInstance(object12).size() == 2 || ASN1Sequence.getInstance(object12).size() == 3)) {
                ECNamedDomainParameters eCNamedDomainParameters;
                ECGOST3410Parameters eCGOST3410Parameters2;
                object3 = ECGOST3410NamedCurves.getByOIDX9(((GOST3410PublicKeyAlgParameters)object2).getPublicKeyParamSet());
                object12 = eCGOST3410Parameters2;
                Object object13 = object2;
                object5 = eCNamedDomainParameters;
                eCNamedDomainParameters = new ECNamedDomainParameters(((GOST3410PublicKeyAlgParameters)object2).getPublicKeyParamSet(), (X9ECParameters)object3);
                object3 = ((GOST3410PublicKeyAlgParameters)object13).getPublicKeyParamSet();
                object4 = ((GOST3410PublicKeyAlgParameters)object13).getDigestParamSet();
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ((GOST3410PublicKeyAlgParameters)object13).getEncryptionParamSet();
                eCGOST3410Parameters2 = new ECGOST3410Parameters((ECDomainParameters)object5, (ASN1ObjectIdentifier)object3, (ASN1ObjectIdentifier)object4, aSN1ObjectIdentifier);
                object3 = ((PrivateKeyInfo)object).getPrivateKey();
                if (((ASN1OctetString)object3).getOctets().length != 32 && ((ASN1OctetString)object3).getOctets().length != 64) {
                    if ((object = ((PrivateKeyInfo)object).parsePrivateKey()) instanceof ASN1Integer) {
                        object = ASN1Integer.getInstance(object).getPositiveValue();
                    } else {
                        BigInteger bigInteger;
                        object = Arrays.reverse(ASN1OctetString.getInstance(object).getOctets());
                        object3 = bigInteger;
                        bigInteger = new BigInteger(1, (byte[])object);
                        object = object3;
                    }
                } else {
                    BigInteger bigInteger;
                    object = bigInteger;
                    bigInteger = new BigInteger(1, Arrays.reverse(((ASN1OctetString)object3).getOctets()));
                }
            } else {
                object12 = X962Parameters.getInstance(((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getParameters());
                if (((X962Parameters)object12).isNamedCurve()) {
                    ECNamedDomainParameters eCNamedDomainParameters;
                    ECGOST3410Parameters eCGOST3410Parameters3;
                    object3 = ASN1ObjectIdentifier.getInstance(((X962Parameters)object12).getParameters());
                    object12 = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)object3);
                    object5 = eCGOST3410Parameters3;
                    Object object14 = object2;
                    object4 = eCNamedDomainParameters;
                    eCNamedDomainParameters = new ECNamedDomainParameters((ASN1ObjectIdentifier)object3, (X9ECParameters)object12);
                    object3 = ((GOST3410PublicKeyAlgParameters)object14).getPublicKeyParamSet();
                    object12 = ((GOST3410PublicKeyAlgParameters)object14).getDigestParamSet();
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = ((GOST3410PublicKeyAlgParameters)object14).getEncryptionParamSet();
                    eCGOST3410Parameters3 = new ECGOST3410Parameters((ECDomainParameters)object4, (ASN1ObjectIdentifier)object3, (ASN1ObjectIdentifier)object12, aSN1ObjectIdentifier);
                    object12 = object5;
                } else if (((X962Parameters)object12).isImplicitlyCA()) {
                    object12 = object3 = null;
                } else {
                    ECNamedDomainParameters eCNamedDomainParameters;
                    ECGOST3410Parameters eCGOST3410Parameters4;
                    object12 = X9ECParameters.getInstance(((X962Parameters)object12).getParameters());
                    object5 = eCGOST3410Parameters4;
                    Object object15 = object2;
                    object4 = eCNamedDomainParameters;
                    eCNamedDomainParameters = new ECNamedDomainParameters((ASN1ObjectIdentifier)object3, (X9ECParameters)object12);
                    object3 = ((GOST3410PublicKeyAlgParameters)object15).getPublicKeyParamSet();
                    object12 = ((GOST3410PublicKeyAlgParameters)object15).getDigestParamSet();
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = ((GOST3410PublicKeyAlgParameters)object15).getEncryptionParamSet();
                    eCGOST3410Parameters4 = new ECGOST3410Parameters((ECDomainParameters)object4, (ASN1ObjectIdentifier)object3, (ASN1ObjectIdentifier)object12, aSN1ObjectIdentifier);
                    object12 = object5;
                }
                object = ((PrivateKeyInfo)object).parsePrivateKey();
                object = object instanceof ASN1Integer ? ASN1Integer.getInstance(object).getValue() : ECPrivateKey.getInstance(object).getKey();
            }
            object3 = eCGOST3410Parameters;
            Object object16 = object2;
            object2 = ((GOST3410PublicKeyAlgParameters)object16).getPublicKeyParamSet();
            object5 = ((GOST3410PublicKeyAlgParameters)object16).getDigestParamSet();
            object4 = ((GOST3410PublicKeyAlgParameters)object16).getEncryptionParamSet();
            eCGOST3410Parameters = new ECGOST3410Parameters((ECDomainParameters)object12, (ASN1ObjectIdentifier)object2, (ASN1ObjectIdentifier)object5, (ASN1ObjectIdentifier)object4);
            return new ECPrivateKeyParameters((BigInteger)object, (ECDomainParameters)object3);
        }
        object = RSAPrivateKey.getInstance(((PrivateKeyInfo)object).parsePrivateKey());
        ASN1Object aSN1Object = object;
        object = ((RSAPrivateKey)aSN1Object).getModulus();
        object2 = ((RSAPrivateKey)aSN1Object).getPublicExponent();
        object3 = ((RSAPrivateKey)aSN1Object).getPrivateExponent();
        BigInteger bigInteger = ((RSAPrivateKey)aSN1Object).getPrime1();
        BigInteger bigInteger4 = ((RSAPrivateKey)aSN1Object).getPrime2();
        BigInteger bigInteger5 = ((RSAPrivateKey)aSN1Object).getExponent1();
        BigInteger bigInteger6 = ((RSAPrivateKey)aSN1Object).getExponent2();
        BigInteger bigInteger7 = ((RSAPrivateKey)aSN1Object).getCoefficient();
        return new RSAPrivateCrtKeyParameters((BigInteger)object, (BigInteger)object2, (BigInteger)object3, bigInteger, bigInteger4, bigInteger5, bigInteger6, bigInteger7);
    }

    private static byte[] getRawKey(PrivateKeyInfo object, int n3) {
        byte[] byArray = ASN1OctetString.getInstance(((PrivateKeyInfo)object).parsePrivateKey()).getOctets();
        object = byArray;
        if (n3 == byArray.length) {
            return object;
        }
        throw new RuntimeException("private key encoding has incorrect length");
    }
}

