/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DSAParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECGOST3410Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X448PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class PrivateKeyInfoFactory {
    private static Set cryptoProOids = new HashSet<ASN1ObjectIdentifier>(5);

    private PrivateKeyInfoFactory() {
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) {
        return PrivateKeyInfoFactory.createPrivateKeyInfo(asymmetricKeyParameter, null);
    }

    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter object, ASN1Set aSN1Object) {
        if (object instanceof RSAKeyParameters) {
            RSAPrivateKey rSAPrivateKey;
            AlgorithmIdentifier algorithmIdentifier;
            object = (RSAPrivateCrtKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
            RSAPrivateKey rSAPrivateKey2 = rSAPrivateKey;
            AsymmetricKeyParameter asymmetricKeyParameter = object;
            object = ((RSAKeyParameters)asymmetricKeyParameter).getModulus();
            BigInteger bigInteger = ((RSAPrivateCrtKeyParameters)asymmetricKeyParameter).getPublicExponent();
            BigInteger bigInteger2 = ((RSAKeyParameters)asymmetricKeyParameter).getExponent();
            BigInteger bigInteger3 = ((RSAPrivateCrtKeyParameters)asymmetricKeyParameter).getP();
            BigInteger bigInteger4 = ((RSAPrivateCrtKeyParameters)asymmetricKeyParameter).getQ();
            BigInteger bigInteger5 = ((RSAPrivateCrtKeyParameters)asymmetricKeyParameter).getDP();
            BigInteger bigInteger6 = ((RSAPrivateCrtKeyParameters)asymmetricKeyParameter).getDQ();
            BigInteger bigInteger7 = ((RSAPrivateCrtKeyParameters)asymmetricKeyParameter).getQInv();
            rSAPrivateKey = new RSAPrivateKey((BigInteger)object, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7);
            return new PrivateKeyInfo(algorithmIdentifier2, rSAPrivateKey2, (ASN1Set)aSN1Object);
        }
        if (object instanceof DSAPrivateKeyParameters) {
            object = (DSAPrivateKeyParameters)object;
            Object object2 = ((DSAKeyParameters)object).getParameters();
            DSAParameters dSAParameters = object2;
            object2 = dSAParameters.getP();
            BigInteger bigInteger = dSAParameters.getQ();
            BigInteger bigInteger8 = dSAParameters.getG();
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter((BigInteger)object2, bigInteger, bigInteger8)), new ASN1Integer(((DSAPrivateKeyParameters)object).getX()), (ASN1Set)aSN1Object);
        }
        if (object instanceof ECPrivateKeyParameters) {
            DERBitString dERBitString;
            FixedPointCombMultiplier fixedPointCombMultiplier;
            Object object3;
            int n3;
            Object object4;
            Object object5 = ((ECKeyParameters)(object = (ECPrivateKeyParameters)object)).getParameters();
            if (object5 == null) {
                X962Parameters x962Parameters;
                object4 = x962Parameters;
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
                n3 = ((ECPrivateKeyParameters)object).getD().bitLength();
            } else {
                if (object5 instanceof ECGOST3410Parameters) {
                    DEROctetString dEROctetString;
                    AlgorithmIdentifier algorithmIdentifier;
                    int n4;
                    GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters;
                    aSN1Object = gOST3410PublicKeyAlgParameters;
                    ECGOST3410Parameters eCGOST3410Parameters = (ECGOST3410Parameters)object5;
                    object5 = eCGOST3410Parameters.getPublicKeyParamSet();
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = eCGOST3410Parameters.getDigestParamSet();
                    Object object6 = eCGOST3410Parameters.getEncryptionParamSet();
                    gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters((ASN1ObjectIdentifier)object5, aSN1ObjectIdentifier, (ASN1ObjectIdentifier)object6);
                    if (cryptoProOids.contains(((GOST3410PublicKeyAlgParameters)aSN1Object).getPublicKeyParamSet())) {
                        n4 = 32;
                        aSN1ObjectIdentifier = CryptoProObjectIdentifiers.gostR3410_2001;
                    } else {
                        n4 = ((ECPrivateKeyParameters)object).getD().bitLength() > 256 ? 1 : 0;
                        aSN1ObjectIdentifier = n4 != 0 ? RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512 : RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256;
                        n4 = n4 != 0 ? 64 : 32;
                    }
                    byte[] byArray = new byte[n4];
                    object6 = byArray;
                    object = ((ECPrivateKeyParameters)object).getD();
                    PrivateKeyInfoFactory.extractBytes(byArray, n4, 0, (BigInteger)object);
                    object = algorithmIdentifier;
                    algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier, aSN1Object);
                    aSN1Object = dEROctetString;
                    dEROctetString = new DEROctetString((byte[])object6);
                    return new PrivateKeyInfo((AlgorithmIdentifier)object, aSN1Object);
                }
                if (object5 instanceof ECNamedDomainParameters) {
                    X962Parameters x962Parameters;
                    object4 = x962Parameters;
                    x962Parameters = new X962Parameters(((ECNamedDomainParameters)object5).getName());
                    n3 = ((ECDomainParameters)object5).getN().bitLength();
                } else {
                    int n5;
                    X962Parameters x962Parameters;
                    X9ECPoint x9ECPoint;
                    X9ECParameters x9ECParameters;
                    X9ECParameters x9ECParameters2 = x9ECParameters;
                    ECDomainParameters eCDomainParameters = object5;
                    Object object7 = eCDomainParameters.getCurve();
                    object3 = x9ECPoint;
                    x9ECPoint = new X9ECPoint(((ECDomainParameters)object5).getG(), false);
                    BigInteger bigInteger = eCDomainParameters.getN();
                    BigInteger bigInteger9 = eCDomainParameters.getH();
                    byte[] byArray = eCDomainParameters.getSeed();
                    x9ECParameters = new X9ECParameters((ECCurve)object7, (X9ECPoint)object3, bigInteger, bigInteger9, byArray);
                    object7 = x962Parameters;
                    x962Parameters = new X962Parameters(x9ECParameters2);
                    n3 = n5 = ((ECDomainParameters)object5).getN().bitLength();
                    object4 = object7;
                }
            }
            object3 = fixedPointCombMultiplier;
            ((FixedPointCombMultiplier)object3)();
            object5 = ((ECDomainParameters)object5).getG();
            object5 = fixedPointCombMultiplier.multiply((ECPoint)object5, ((ECPrivateKeyParameters)object).getD());
            object3 = dERBitString;
            dERBitString = new DERBitString(((ECPoint)object5).getEncoded(false));
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)object4), new ECPrivateKey(n3, ((ECPrivateKeyParameters)object).getD(), (DERBitString)object3, (ASN1Encodable)object4), (ASN1Set)aSN1Object);
        }
        if (object instanceof X448PrivateKeyParameters) {
            DEROctetString dEROctetString;
            object = (X448PrivateKeyParameters)object;
            DEROctetString dEROctetString2 = dEROctetString;
            dEROctetString = new DEROctetString(((X448PrivateKeyParameters)object).getEncoded());
            object = ((X448PrivateKeyParameters)object).generatePublicKey().getEncoded();
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X448), dEROctetString2, (ASN1Set)aSN1Object, (byte[])object);
        }
        if (object instanceof X25519PrivateKeyParameters) {
            DEROctetString dEROctetString;
            object = (X25519PrivateKeyParameters)object;
            DEROctetString dEROctetString3 = dEROctetString;
            dEROctetString = new DEROctetString(((X25519PrivateKeyParameters)object).getEncoded());
            object = ((X25519PrivateKeyParameters)object).generatePublicKey().getEncoded();
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), dEROctetString3, (ASN1Set)aSN1Object, (byte[])object);
        }
        if (object instanceof Ed448PrivateKeyParameters) {
            DEROctetString dEROctetString;
            object = (Ed448PrivateKeyParameters)object;
            DEROctetString dEROctetString4 = dEROctetString;
            dEROctetString = new DEROctetString(((Ed448PrivateKeyParameters)object).getEncoded());
            object = ((Ed448PrivateKeyParameters)object).generatePublicKey().getEncoded();
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed448), dEROctetString4, (ASN1Set)aSN1Object, (byte[])object);
        }
        if (object instanceof Ed25519PrivateKeyParameters) {
            DEROctetString dEROctetString;
            object = (Ed25519PrivateKeyParameters)object;
            DEROctetString dEROctetString5 = dEROctetString;
            dEROctetString = new DEROctetString(((Ed25519PrivateKeyParameters)object).getEncoded());
            object = ((Ed25519PrivateKeyParameters)object).generatePublicKey().getEncoded();
            return new PrivateKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519), dEROctetString5, (ASN1Set)aSN1Object, (byte[])object);
        }
        throw new IOException("key parameters not recognized");
    }

    private static void extractBytes(byte[] byArray, int n3, int n4, BigInteger object) {
        int n5;
        int n6;
        byte[] byArray2 = ((BigInteger)object).toByteArray();
        object = byArray2;
        if (byArray2.length < n3) {
            Object object2 = object;
            Object object3 = object;
            object = new byte[n3];
            n6 = n3 - ((Object)object3).length;
            n5 = ((Object)object2).length;
            System.arraycopy(object2, 0, object, n6, n5);
        }
        for (n6 = 0; n6 != n3; ++n6) {
            Object object4 = object;
            n5 = n4 + n6;
            byArray[n5] = (byte)object4[((Object)object4).length - 1 - n6];
        }
    }

    static {
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_B);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_C);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchA);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchB);
    }
}

