/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.ElGamalParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.DHParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145BinaryField;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145ECBinary;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145NamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145Params;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145PointEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.UAObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DSAParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.DHPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.DomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.ValidationParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9IntegerConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.CustomNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHValidationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECGOST3410Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X448PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class PublicKeyFactory {
    private static Map converters = new HashMap<ASN1ObjectIdentifier, RSAConverter>();

    public static AsymmetricKeyParameter createKey(byte[] byArray) {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo, null);
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
        AlgorithmIdentifier algorithmIdentifier = subjectPublicKeyInfo.getAlgorithm();
        SubjectPublicKeyInfoConverter subjectPublicKeyInfoConverter = (SubjectPublicKeyInfoConverter)converters.get(algorithmIdentifier.getAlgorithm());
        if (subjectPublicKeyInfoConverter != null) {
            return subjectPublicKeyInfoConverter.getPublicKeyParameters(subjectPublicKeyInfo, object);
        }
        throw new IOException(b.a("algorithm identifier in public key not recognised: ").append(algorithmIdentifier.getAlgorithm()).toString());
    }

    private static byte[] getRawKey(SubjectPublicKeyInfo object, Object object2, int n3) {
        byte[] byArray = ((SubjectPublicKeyInfo)object).getPublicKeyData().getOctets();
        object = byArray;
        if (n3 == byArray.length) {
            return object;
        }
        throw new RuntimeException("public key encoding has incorrect length");
    }

    static {
        converters.put(PKCSObjectIdentifiers.rsaEncryption, new RSAConverter(null));
        converters.put(PKCSObjectIdentifiers.id_RSASSA_PSS, new RSAConverter(null));
        converters.put(X509ObjectIdentifiers.id_ea_rsa, new RSAConverter(null));
        converters.put(X9ObjectIdentifiers.dhpublicnumber, new DHPublicNumberConverter(null));
        converters.put(PKCSObjectIdentifiers.dhKeyAgreement, new DHAgreementConverter(null));
        converters.put(X9ObjectIdentifiers.id_dsa, new DSAConverter(null));
        converters.put(OIWObjectIdentifiers.dsaWithSHA1, new DSAConverter(null));
        converters.put(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalConverter(null));
        converters.put(X9ObjectIdentifiers.id_ecPublicKey, new ECConverter(null));
        converters.put(CryptoProObjectIdentifiers.gostR3410_2001, new GOST3410_2001Converter(null));
        converters.put(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256, new GOST3410_2012Converter(null));
        converters.put(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512, new GOST3410_2012Converter(null));
        converters.put(UAObjectIdentifiers.dstu4145be, new DSTUConverter(null));
        converters.put(UAObjectIdentifiers.dstu4145le, new DSTUConverter(null));
        converters.put(EdECObjectIdentifiers.id_X25519, new X25519Converter(null));
        converters.put(EdECObjectIdentifiers.id_X448, new X448Converter(null));
        converters.put(EdECObjectIdentifiers.id_Ed25519, new Ed25519Converter(null));
        converters.put(EdECObjectIdentifiers.id_Ed448, new Ed448Converter(null));
    }

    public static class Ed448Converter
    extends SubjectPublicKeyInfoConverter {
        private Ed448Converter() {
            super(null);
        }

        public /* synthetic */ Ed448Converter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            return new Ed448PublicKeyParameters(PublicKeyFactory.getRawKey(subjectPublicKeyInfo, object, 57), 0);
        }
    }

    public static class Ed25519Converter
    extends SubjectPublicKeyInfoConverter {
        private Ed25519Converter() {
            super(null);
        }

        public /* synthetic */ Ed25519Converter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            return new Ed25519PublicKeyParameters(PublicKeyFactory.getRawKey(subjectPublicKeyInfo, object, 32), 0);
        }
    }

    public static class X448Converter
    extends SubjectPublicKeyInfoConverter {
        private X448Converter() {
            super(null);
        }

        public /* synthetic */ X448Converter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            return new X448PublicKeyParameters(PublicKeyFactory.getRawKey(subjectPublicKeyInfo, object, 56), 0);
        }
    }

    public static class X25519Converter
    extends SubjectPublicKeyInfoConverter {
        private X25519Converter() {
            super(null);
        }

        public /* synthetic */ X25519Converter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo, Object object) {
            return new X25519PublicKeyParameters(PublicKeyFactory.getRawKey(subjectPublicKeyInfo, object, 32), 0);
        }
    }

    public static class DSTUConverter
    extends SubjectPublicKeyInfoConverter {
        private DSTUConverter() {
            super(null);
        }

        private void reverseBytes(byte[] byArray) {
            for (int i3 = 0; i3 < byArray.length / 2; ++i3) {
                byte[] byArray2 = byArray;
                byte by = byArray[i3];
                byArray2[i3] = byArray[byArray.length - 1 - i3];
                byArray[byArray2.length - 1 - i3] = by;
            }
        }

        public /* synthetic */ DSTUConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo object, Object object2) {
            block6: {
                ECDomainParameters eCDomainParameters;
                ECCurve.F2m f2m;
                BigInteger bigInteger;
                Object object3;
                ASN1Object aSN1Object;
                Object object4;
                block5: {
                    object2 = ((SubjectPublicKeyInfo)object).getAlgorithm();
                    object4 = ((AlgorithmIdentifier)object2).getAlgorithm();
                    SubjectPublicKeyInfo subjectPublicKeyInfo = object;
                    object = DSTU4145Params.getInstance(((AlgorithmIdentifier)object2).getParameters());
                    try {
                        object2 = Arrays.clone(((ASN1OctetString)subjectPublicKeyInfo.parsePublicKey()).getOctets());
                        aSN1Object = UAObjectIdentifiers.dstu4145le;
                        if (((ASN1Primitive)object4).equals((ASN1Primitive)aSN1Object)) {
                            ((DSTUConverter)object3).reverseBytes((byte[])object2);
                        }
                        if (!((DSTU4145Params)object).isNamedCurve()) break block5;
                    }
                    catch (IOException iOException) {
                        throw new IllegalArgumentException("error recovering DSTU public key");
                    }
                    object3 = DSTU4145NamedCurves.getByOID(((DSTU4145Params)object).getNamedCurve());
                    break block6;
                }
                object = ((DSTU4145Params)object).getECBinary();
                Object object5 = ((DSTU4145ECBinary)object).getB();
                if (((ASN1Primitive)object4).equals((ASN1Primitive)aSN1Object)) {
                    super.reverseBytes((byte[])object5);
                }
                ASN1ObjectIdentifier aSN1ObjectIdentifier = object4;
                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = aSN1Object;
                Object object6 = object;
                object4 = bigInteger;
                bigInteger = new BigInteger(1, (byte[])object5);
                aSN1Object = ((DSTU4145ECBinary)object6).getField();
                object5 = f2m;
                ASN1Object aSN1Object2 = aSN1Object;
                int n3 = ((DSTU4145BinaryField)aSN1Object2).getM();
                int n4 = ((DSTU4145BinaryField)aSN1Object2).getK1();
                int n5 = ((DSTU4145BinaryField)aSN1Object2).getK2();
                int n6 = ((DSTU4145BinaryField)aSN1Object2).getK3();
                BigInteger bigInteger2 = ((DSTU4145ECBinary)object).getA();
                f2m = new ECCurve.F2m(n3, n4, n5, n6, bigInteger2, (BigInteger)object4);
                object4 = ((DSTU4145ECBinary)object6).getG();
                if (aSN1ObjectIdentifier.equals(aSN1ObjectIdentifier2)) {
                    super.reverseBytes((byte[])object4);
                }
                object3 = DSTU4145PointEncoder.decodePoint((ECCurve)object5, (byte[])object4);
                object4 = eCDomainParameters;
                object = ((DSTU4145ECBinary)object).getN();
                eCDomainParameters = new ECDomainParameters((ECCurve)object5, (ECPoint)object3, (BigInteger)object);
                object3 = object4;
            }
            object = DSTU4145PointEncoder.decodePoint(((ECDomainParameters)object3).getCurve(), (byte[])object2);
            return new ECPublicKeyParameters((ECPoint)object, (ECDomainParameters)object3);
        }
    }

    public static class GOST3410_2012Converter
    extends SubjectPublicKeyInfoConverter {
        private GOST3410_2012Converter() {
            super(null);
        }

        public /* synthetic */ GOST3410_2012Converter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo aSN1Object, Object object) {
            byte[] byArray;
            int n3;
            int n4;
            ECNamedDomainParameters eCNamedDomainParameters;
            ECGOST3410Parameters eCGOST3410Parameters;
            Object object2 = aSN1Object.getAlgorithm();
            SubjectPublicKeyInfo subjectPublicKeyInfo = aSN1Object;
            object2 = GOST3410PublicKeyAlgParameters.getInstance(((AlgorithmIdentifier)object2).getParameters());
            aSN1Object = ((GOST3410PublicKeyAlgParameters)object2).getPublicKeyParamSet();
            object = eCGOST3410Parameters;
            Object object3 = object2;
            object2 = eCNamedDomainParameters;
            ASN1Object aSN1Object2 = aSN1Object;
            eCNamedDomainParameters = new ECNamedDomainParameters((ASN1ObjectIdentifier)aSN1Object2, ECGOST3410NamedCurves.getByOIDX9((ASN1ObjectIdentifier)aSN1Object2));
            Object object4 = ((GOST3410PublicKeyAlgParameters)object3).getDigestParamSet();
            Object object5 = ((GOST3410PublicKeyAlgParameters)object3).getEncryptionParamSet();
            eCGOST3410Parameters = new ECGOST3410Parameters((ECDomainParameters)object2, (ASN1ObjectIdentifier)aSN1Object, (ASN1ObjectIdentifier)object4, (ASN1ObjectIdentifier)object5);
            try {
                AlgorithmIdentifier algorithmIdentifier;
                object2 = (ASN1OctetString)subjectPublicKeyInfo.parsePublicKey();
                n4 = 32;
                if (algorithmIdentifier.getAlgorithm().equals(RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512)) {
                    n4 = 64;
                }
                n3 = n4 * 2;
                byArray = ((ASN1OctetString)object2).getOctets();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering GOST3410_2012 public key");
            }
            object4 = byArray;
            if (byArray.length == n3) {
                byte[] byArray2 = new byte[n3 + 1];
                object5 = byArray2;
                byArray2[0] = 4;
                for (int i3 = 1; i3 <= n4; ++i3) {
                    int n5 = i3;
                    object5[i3] = object4[n4 - i3];
                    int n6 = n5 + n4;
                    object5[n6] = object4[n3 - n5];
                }
                ECPoint eCPoint = ((ECDomainParameters)object).getCurve().decodePoint((byte[])object5);
                return new ECPublicKeyParameters(eCPoint, (ECDomainParameters)object);
            }
            throw new IllegalArgumentException("invalid length for GOST3410_2012 public key");
        }
    }

    public static class GOST3410_2001Converter
    extends SubjectPublicKeyInfoConverter {
        private GOST3410_2001Converter() {
            super(null);
        }

        public /* synthetic */ GOST3410_2001Converter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo aSN1Object, Object object) {
            byte[] byArray;
            int n3;
            int n4;
            ECNamedDomainParameters eCNamedDomainParameters;
            ECGOST3410Parameters eCGOST3410Parameters;
            SubjectPublicKeyInfo subjectPublicKeyInfo = aSN1Object;
            Object object2 = GOST3410PublicKeyAlgParameters.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            aSN1Object = ((GOST3410PublicKeyAlgParameters)object2).getPublicKeyParamSet();
            object = eCGOST3410Parameters;
            Object object3 = object2;
            object2 = eCNamedDomainParameters;
            ASN1Object aSN1Object2 = aSN1Object;
            eCNamedDomainParameters = new ECNamedDomainParameters((ASN1ObjectIdentifier)aSN1Object2, ECGOST3410NamedCurves.getByOIDX9((ASN1ObjectIdentifier)aSN1Object2));
            Object object4 = ((GOST3410PublicKeyAlgParameters)object3).getDigestParamSet();
            Object object5 = ((GOST3410PublicKeyAlgParameters)object3).getEncryptionParamSet();
            eCGOST3410Parameters = new ECGOST3410Parameters((ECDomainParameters)object2, (ASN1ObjectIdentifier)aSN1Object, (ASN1ObjectIdentifier)object4, (ASN1ObjectIdentifier)object5);
            try {
                n4 = 32;
                n3 = 64;
                byArray = ((ASN1OctetString)subjectPublicKeyInfo.parsePublicKey()).getOctets();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering GOST3410_2001 public key");
            }
            object4 = byArray;
            if (byArray.length == n3) {
                byte[] byArray2 = new byte[65];
                object5 = byArray2;
                byArray2[0] = 4;
                for (int i3 = 1; i3 <= n4; ++i3) {
                    int n5 = i3;
                    object5[i3] = object4[n4 - i3];
                    int n6 = n5 + n4;
                    object5[n6] = object4[n3 - n5];
                }
                ECPoint eCPoint = ((ECDomainParameters)object).getCurve().decodePoint((byte[])object5);
                return new ECPublicKeyParameters(eCPoint, (ECDomainParameters)object);
            }
            throw new IllegalArgumentException("invalid length for GOST3410_2001 public key");
        }
    }

    public static class ECConverter
    extends SubjectPublicKeyInfoConverter {
        private ECConverter() {
            super(null);
        }

        public /* synthetic */ ECConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo aSN1Object, Object object) {
            X9ECPoint x9ECPoint;
            Object object2;
            DEROctetString dEROctetString;
            ECDomainParameters eCDomainParameters;
            Object object3 = X962Parameters.getInstance(aSN1Object.getAlgorithm().getParameters());
            if (((X962Parameters)object3).isNamedCurve()) {
                ECNamedDomainParameters eCNamedDomainParameters;
                object = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)(object3 = (ASN1ObjectIdentifier)((X962Parameters)object3).getParameters()));
                if (object == null) {
                    object = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)object3);
                }
                eCDomainParameters = eCNamedDomainParameters;
                eCNamedDomainParameters = new ECNamedDomainParameters((ASN1ObjectIdentifier)object3, (X9ECParameters)object);
            } else if (((X962Parameters)object3).isImplicitlyCA()) {
                eCDomainParameters = (ECDomainParameters)object;
            } else {
                ECDomainParameters eCDomainParameters2;
                object3 = X9ECParameters.getInstance(((X962Parameters)object3).getParameters());
                eCDomainParameters = eCDomainParameters2;
                eCDomainParameters2 = new ECDomainParameters((X9ECParameters)object3);
            }
            byte[] byArray = aSN1Object.getPublicKeyData().getBytes();
            object3 = byArray;
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString((byte[])object3);
            if (byArray[0] == 4 && object3[1] == ((Object)object3).length - 2 && ((object2 = object3[2]) == 2 || object2 == 3) && new X9IntegerConverter().getByteLength(eCDomainParameters.getCurve()) >= ((Object)object3).length - 3) {
                try {
                    aSN1Object = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])object3);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            object3 = x9ECPoint;
            x9ECPoint = new X9ECPoint(eCDomainParameters.getCurve(), (ASN1OctetString)aSN1Object);
            return new ECPublicKeyParameters(((X9ECPoint)object3).getPoint(), eCDomainParameters);
        }
    }

    public static class DSAConverter
    extends SubjectPublicKeyInfoConverter {
        private DSAConverter() {
            super(null);
        }

        public /* synthetic */ DSAConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo object, Object object2) {
            SubjectPublicKeyInfo subjectPublicKeyInfo = object;
            ASN1Integer aSN1Integer = (ASN1Integer)subjectPublicKeyInfo.parsePublicKey();
            object = subjectPublicKeyInfo.getAlgorithm().getParameters();
            object2 = null;
            if (object != null) {
                DSAParameters dSAParameters;
                object = DSAParameter.getInstance(object.toASN1Primitive());
                object2 = dSAParameters;
                ASN1Encodable aSN1Encodable = object;
                object = ((DSAParameter)aSN1Encodable).getP();
                BigInteger bigInteger = ((DSAParameter)aSN1Encodable).getQ();
                BigInteger bigInteger2 = ((DSAParameter)aSN1Encodable).getG();
                dSAParameters = new DSAParameters((BigInteger)object, bigInteger, bigInteger2);
            }
            return new DSAPublicKeyParameters(aSN1Integer.getValue(), (DSAParameters)object2);
        }
    }

    public static class ElGamalConverter
    extends SubjectPublicKeyInfoConverter {
        private ElGamalConverter() {
            super(null);
        }

        public /* synthetic */ ElGamalConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo aSN1Object, Object object) {
            SubjectPublicKeyInfo subjectPublicKeyInfo = aSN1Object;
            Object object2 = ElGamalParameter.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            aSN1Object = (ASN1Integer)subjectPublicKeyInfo.parsePublicKey();
            Object object3 = object2;
            object2 = ((ElGamalParameter)object3).getP();
            return new ElGamalPublicKeyParameters(((ASN1Integer)aSN1Object).getValue(), new ElGamalParameters((BigInteger)object2, ((ElGamalParameter)object3).getG()));
        }
    }

    public static class DHAgreementConverter
    extends SubjectPublicKeyInfoConverter {
        private DHAgreementConverter() {
            super(null);
        }

        public /* synthetic */ DHAgreementConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo aSN1Object, Object object) {
            DHParameters dHParameters;
            Object object2 = DHParameter.getInstance(((SubjectPublicKeyInfo)aSN1Object).getAlgorithm().getParameters());
            aSN1Object = (ASN1Integer)((SubjectPublicKeyInfo)aSN1Object).parsePublicKey();
            object = ((DHParameter)object2).getL();
            int n3 = object == null ? 0 : ((BigInteger)object).intValue();
            DHParameters dHParameters2 = dHParameters;
            Object object3 = object2;
            object2 = ((DHParameter)object3).getP();
            dHParameters = new DHParameters((BigInteger)object2, ((DHParameter)object3).getG(), null, n3);
            return new DHPublicKeyParameters(((ASN1Integer)aSN1Object).getValue(), dHParameters2);
        }
    }

    public static class DHPublicNumberConverter
    extends SubjectPublicKeyInfoConverter {
        private DHPublicNumberConverter() {
            super(null);
        }

        public /* synthetic */ DHPublicNumberConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo object, Object object2) {
            DHParameters dHParameters;
            SubjectPublicKeyInfo subjectPublicKeyInfo = object;
            BigInteger bigInteger = DHPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey()).getY();
            object = DomainParameters.getInstance(subjectPublicKeyInfo.getAlgorithm().getParameters());
            object2 = ((DomainParameters)object).getP();
            BigInteger bigInteger2 = ((DomainParameters)object).getG();
            BigInteger bigInteger3 = ((DomainParameters)object).getQ();
            BigInteger bigInteger4 = null;
            if (((DomainParameters)object).getJ() != null) {
                bigInteger4 = ((DomainParameters)object).getJ();
            }
            ASN1Object aSN1Object = object;
            object = null;
            Object object3 = ((DomainParameters)aSN1Object).getValidationParams();
            if (object3 != null) {
                DHValidationParameters dHValidationParameters;
                ValidationParams validationParams = object3;
                object = validationParams.getSeed();
                object3 = validationParams.getPgenCounter();
                DHValidationParameters dHValidationParameters2 = dHValidationParameters;
                dHValidationParameters = new DHValidationParameters((byte[])object, ((BigInteger)object3).intValue());
                object = dHValidationParameters2;
            }
            object3 = dHParameters;
            dHParameters = new DHParameters((BigInteger)object2, bigInteger2, bigInteger3, bigInteger4, (DHValidationParameters)object);
            return new DHPublicKeyParameters(bigInteger, (DHParameters)object3);
        }
    }

    public static class RSAConverter
    extends SubjectPublicKeyInfoConverter {
        private RSAConverter() {
            super(null);
        }

        public /* synthetic */ RSAConverter(1 var1_1) {
            this();
        }

        @Override
        public AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo object, Object object2) {
            Object object3 = object4 = RSAPublicKey.getInstance(((SubjectPublicKeyInfo)object).parsePublicKey());
            Object object4 = ((RSAPublicKey)object3).getModulus();
            object = ((RSAPublicKey)object3).getPublicExponent();
            return new RSAKeyParameters(false, (BigInteger)object4, (BigInteger)object);
        }
    }

    public static abstract class SubjectPublicKeyInfoConverter {
        private SubjectPublicKeyInfoConverter() {
        }

        public /* synthetic */ SubjectPublicKeyInfoConverter(1 var1_1) {
            this();
        }

        public abstract AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo var1, Object var2);
    }
}

