/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.math.BigInteger;

class SSHBuffer {
    private final byte[] buffer;
    private int pos = 0;

    public SSHBuffer(byte[] byArray, byte[] byArray2) {
        this.buffer = byArray2;
        for (int i3 = 0; i3 != byArray.length; ++i3) {
            if (byArray[i3] == byArray2[i3]) {
                continue;
            }
            throw new IllegalArgumentException("magic-number incorrect");
        }
        this.pos += byArray.length;
    }

    public SSHBuffer(byte[] byArray) {
        this.buffer = byArray;
    }

    public int readU32() {
        int n3 = this.pos;
        byte[] byArray = this.buffer;
        if (n3 <= this.buffer.length - 4) {
            int n4 = n3++;
            int n5 = n3++;
            int n6 = n3++;
            this.pos = n3 + 1;
            return (byArray[n4] & 0xFF) << 24 | (byArray[n5] & 0xFF) << 16 | (byArray[n6] & 0xFF) << 8 | byArray[n3] & 0xFF;
        }
        throw new IllegalArgumentException("4 bytes for U32 exceeds buffer.");
    }

    public String readString() {
        return Strings.fromByteArray(this.readBlock());
    }

    public byte[] readBlock() {
        int n3 = this.readU32();
        if (n3 == 0) {
            return new byte[0];
        }
        int n4 = this.pos;
        byte[] byArray = this.buffer;
        if (n4 <= this.buffer.length - n3) {
            int n5;
            this.pos = n5 = n4 + n3;
            return Arrays.copyOfRange(byArray, n4, n5);
        }
        throw new IllegalArgumentException("not enough data for block");
    }

    public void skipBlock() {
        SSHBuffer sSHBuffer = this;
        int n3 = sSHBuffer.pos;
        int n4 = sSHBuffer.readU32();
        if (n3 <= this.buffer.length - n4) {
            this.pos = n3 + n4;
            return;
        }
        throw new IllegalArgumentException("not enough data for block");
    }

    public byte[] readPaddedBlock() {
        return this.readPaddedBlock(8);
    }

    public byte[] readPaddedBlock(int n3) {
        int n4 = this.readU32();
        if (n4 == 0) {
            return new byte[0];
        }
        int n5 = this.pos;
        byte[] byArray = this.buffer;
        if (n5 <= this.buffer.length - n4) {
            if (n4 % n3 == 0) {
                int n6;
                int n7 = n4;
                this.pos = n4 = n5 + n4;
                if (n7 > 0 && (n6 = byArray[n4 - 1] & 0xFF) > 0 && n6 < n3) {
                    n3 = 1;
                    int n8 = n4 -= n6;
                    while (n3 <= n6) {
                        if (n3 == (this.buffer[n8] & 0xFF)) {
                            ++n3;
                            ++n8;
                            continue;
                        }
                        throw new IllegalArgumentException("incorrect padding");
                    }
                }
                return Arrays.copyOfRange(this.buffer, n5, n4);
            }
            throw new IllegalArgumentException("missing padding");
        }
        throw new IllegalArgumentException("not enough data for block");
    }

    public BigInteger readBigNumPositive() {
        SSHBuffer sSHBuffer = this;
        int n3 = sSHBuffer.readU32();
        int n4 = sSHBuffer.pos;
        byte[] byArray = this.buffer;
        if (n4 + n3 <= this.buffer.length) {
            int n5;
            this.pos = n5 = n4 + n3;
            byte[] byArray2 = Arrays.copyOfRange(byArray, n4, n5);
            return new BigInteger(1, byArray2);
        }
        throw new IllegalArgumentException("not enough data for big num");
    }

    public byte[] getBuffer() {
        return Arrays.clone(this.buffer);
    }

    public boolean hasRemaining() {
        return this.pos < this.buffer.length;
    }
}

