/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

class SSHBuilder {
    private final ByteArrayOutputStream bos;

    public SSHBuilder() {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        v1.bos = byteArrayOutputStream2;
    }

    public void u32(int n3) {
        SSHBuilder sSHBuilder = this;
        sSHBuilder.bos.write(n3 >>> 24 & 0xFF);
        sSHBuilder.bos.write(n3 >>> 16 & 0xFF);
        sSHBuilder.bos.write(n3 >>> 8 & 0xFF);
        sSHBuilder.bos.write(n3 & 0xFF);
    }

    public void writeBigNum(BigInteger bigInteger) {
        this.writeBlock(bigInteger.toByteArray());
    }

    public void writeBlock(byte[] byArray) {
        SSHBuilder sSHBuilder = this;
        sSHBuilder.u32(byArray.length);
        try {
            sSHBuilder.bos.write(byArray);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage(), iOException);
        }
    }

    public void writeBytes(byte[] byArray) {
        try {
            this.bos.write(byArray);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage(), iOException);
        }
    }

    public void writeString(String string2) {
        this.writeBlock(Strings.toByteArray(string2));
    }

    public byte[] getBytes() {
        return this.bos.toByteArray();
    }

    public byte[] getPaddedBytes() {
        return this.getPaddedBytes(8);
    }

    public byte[] getPaddedBytes(int n3) {
        int n4 = this.bos.size() % n3;
        if (n4 != 0) {
            n3 -= n4;
            for (n4 = 1; n4 <= n3; ++n4) {
                this.bos.write(n4);
            }
        }
        return this.bos.toByteArray();
    }
}

