/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.SECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.ec.CustomNamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class SSHNamedCurves {
    private static final Map<ASN1ObjectIdentifier, String> oidToName;
    private static final Map<String, ASN1ObjectIdentifier> oidMap;
    private static final Map<String, String> curveNameToSSHName;
    private static HashMap<ECCurve, String> curveMap;

    public static ASN1ObjectIdentifier getByName(String string2) {
        return oidMap.get(string2);
    }

    public static X9ECParameters getParameters(String string2) {
        return NISTNamedCurves.getByOID(oidMap.get(Strings.toLowerCase(string2)));
    }

    public static X9ECParameters getParameters(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return NISTNamedCurves.getByOID(aSN1ObjectIdentifier);
    }

    public static String getName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return oidToName.get(aSN1ObjectIdentifier);
    }

    public static String getNameForParameters(ECDomainParameters eCDomainParameters) {
        if (eCDomainParameters instanceof ECNamedDomainParameters) {
            return SSHNamedCurves.getName(((ECNamedDomainParameters)eCDomainParameters).getName());
        }
        return SSHNamedCurves.getNameForParameters(eCDomainParameters.getCurve());
    }

    public static String getNameForParameters(ECCurve eCCurve) {
        return curveNameToSSHName.get(curveMap.get(eCCurve));
    }

    static {
        oidMap = Collections.unmodifiableMap(new HashMap<String, ASN1ObjectIdentifier>(){
            {
                1 v02 = this;
                ((AbstractMap)v02).put("nistp256", SECObjectIdentifiers.secp256r1);
                ((AbstractMap)v02).put("nistp384", SECObjectIdentifiers.secp384r1);
                ((AbstractMap)v02).put("nistp521", SECObjectIdentifiers.secp521r1);
                ((AbstractMap)v02).put("nistk163", SECObjectIdentifiers.sect163k1);
                ((AbstractMap)v02).put("nistp192", SECObjectIdentifiers.secp192r1);
                ((AbstractMap)v02).put("nistp224", SECObjectIdentifiers.secp224r1);
                ((AbstractMap)v02).put("nistk233", SECObjectIdentifiers.sect233k1);
                ((AbstractMap)v02).put("nistb233", SECObjectIdentifiers.sect233r1);
                ((AbstractMap)v02).put("nistk283", SECObjectIdentifiers.sect283k1);
                ((AbstractMap)v02).put("nistk409", SECObjectIdentifiers.sect409k1);
                ((AbstractMap)v02).put("nistb409", SECObjectIdentifiers.sect409r1);
                ((AbstractMap)v02).put("nistt571", SECObjectIdentifiers.sect571k1);
            }
        });
        curveNameToSSHName = Collections.unmodifiableMap(new HashMap<String, String>(){
            {
                int n3 = 12;
                String[][] stringArrayArray = new String[12][];
                String[][] stringArrayArray2 = stringArrayArray;
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = "secp256r1";
                stringArray[1] = "nistp256";
                stringArrayArray[0] = stringArray2;
                String[] stringArray3 = new String[2];
                stringArray2 = stringArray3;
                stringArray3[0] = "secp384r1";
                stringArray3[1] = "nistp384";
                stringArrayArray[1] = stringArray2;
                String[] stringArray4 = new String[2];
                stringArray2 = stringArray4;
                stringArray4[0] = "secp521r1";
                stringArray4[1] = "nistp521";
                stringArrayArray[2] = stringArray2;
                String[] stringArray5 = new String[2];
                stringArray2 = stringArray5;
                stringArray5[0] = "sect163k1";
                stringArray5[1] = "nistk163";
                stringArrayArray[3] = stringArray2;
                String[] stringArray6 = new String[2];
                stringArray2 = stringArray6;
                stringArray6[0] = "secp192r1";
                stringArray6[1] = "nistp192";
                stringArrayArray[4] = stringArray2;
                String[] stringArray7 = new String[2];
                stringArray2 = stringArray7;
                stringArray7[0] = "secp224r1";
                stringArray7[1] = "nistp224";
                stringArrayArray[5] = stringArray2;
                String[] stringArray8 = new String[2];
                stringArray2 = stringArray8;
                stringArray8[0] = "sect233k1";
                stringArray8[1] = "nistk233";
                stringArrayArray[6] = stringArray2;
                String[] stringArray9 = new String[2];
                stringArray2 = stringArray9;
                stringArray9[0] = "sect233r1";
                stringArray9[1] = "nistb233";
                stringArrayArray[7] = stringArray2;
                String[] stringArray10 = new String[2];
                stringArray2 = stringArray10;
                stringArray10[0] = "sect283k1";
                stringArray10[1] = "nistk283";
                stringArrayArray[8] = stringArray2;
                String[] stringArray11 = new String[2];
                stringArray2 = stringArray11;
                stringArray11[0] = "sect409k1";
                stringArray11[1] = "nistk409";
                stringArrayArray[9] = stringArray2;
                String[] stringArray12 = new String[2];
                stringArray2 = stringArray12;
                stringArray12[0] = "sect409r1";
                stringArray12[1] = "nistb409";
                stringArrayArray[10] = stringArray2;
                String[] stringArray13 = new String[2];
                stringArray2 = stringArray13;
                stringArray13[0] = "sect571k1";
                stringArray13[1] = "nistt571";
                stringArrayArray[11] = stringArray2;
                for (int i3 = 0; i3 != n3; ++i3) {
                    String[] stringArray14 = stringArrayArray2[i3];
                    String string2 = stringArray14[0];
                    ((AbstractMap)this).put(string2, stringArray14[1]);
                }
            }
        });
        curveMap = new HashMap<ECCurve, String>(){
            {
                Enumeration enumeration = CustomNamedCurves.getNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    ((AbstractMap)this).put(CustomNamedCurves.getByName(string2).getCurve(), string2);
                }
            }
        };
        oidToName = Collections.unmodifiableMap(new HashMap<ASN1ObjectIdentifier, String>(){
            {
                for (String string2 : oidMap.keySet()) {
                    ((AbstractMap)this).put((ASN1ObjectIdentifier)oidMap.get(string2), string2);
                }
            }
        });
    }
}

