/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.PBKDFConfig;

public class ScryptConfig
extends PBKDFConfig {
    private final int costParameter;
    private final int blockSize;
    private final int parallelizationParameter;
    private final int saltLength;

    private ScryptConfig(Builder builder) {
        super(MiscObjectIdentifiers.id_scrypt);
        this.costParameter = builder.costParameter;
        this.blockSize = builder.blockSize;
        this.parallelizationParameter = builder.parallelizationParameter;
        this.saltLength = builder.saltLength;
    }

    public /* synthetic */ ScryptConfig(Builder builder, 1 var2_2) {
        this(builder);
    }

    public int getCostParameter() {
        return this.costParameter;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getParallelizationParameter() {
        return this.parallelizationParameter;
    }

    public int getSaltLength() {
        return this.saltLength;
    }

    public static class Builder {
        private final int costParameter;
        private final int blockSize;
        private final int parallelizationParameter;
        private int saltLength = 16;

        public Builder(int n3, int n4, int n5) {
            if (n3 > 1 && Builder.isPowerOf2(n3)) {
                Builder builder = this;
                builder.costParameter = n3;
                builder.blockSize = n4;
                builder.parallelizationParameter = n5;
                return;
            }
            throw new IllegalArgumentException("Cost parameter N must be > 1 and a power of 2");
        }

        private static boolean isPowerOf2(int n3) {
            int n4 = n3;
            return (n4 & n4 - 1) == 0;
        }

        public Builder withSaltLength(int n3) {
            this.saltLength = n3;
            return this;
        }

        public ScryptConfig build() {
            return new ScryptConfig(this, null);
        }
    }
}

