/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DSAParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECGOST3410Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X448PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class SubjectPublicKeyInfoFactory {
    private static Set cryptoProOids = new HashSet<ASN1ObjectIdentifier>(5);

    private SubjectPublicKeyInfoFactory() {
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter object) {
        if (object instanceof RSAKeyParameters) {
            RSAPublicKey rSAPublicKey;
            AlgorithmIdentifier algorithmIdentifier;
            object = (RSAKeyParameters)object;
            AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
            RSAPublicKey rSAPublicKey2 = rSAPublicKey;
            AsymmetricKeyParameter asymmetricKeyParameter = object;
            object = ((RSAKeyParameters)asymmetricKeyParameter).getModulus();
            rSAPublicKey = new RSAPublicKey((BigInteger)object, ((RSAKeyParameters)asymmetricKeyParameter).getExponent());
            return new SubjectPublicKeyInfo(algorithmIdentifier2, rSAPublicKey2);
        }
        if (object instanceof DSAPublicKeyParameters) {
            ASN1Integer aSN1Integer;
            object = (DSAPublicKeyParameters)object;
            ASN1Object aSN1Object = null;
            Object object2 = ((DSAKeyParameters)object).getParameters();
            if (object2 != null) {
                DSAParameter dSAParameter;
                aSN1Object = dSAParameter;
                DSAParameters dSAParameters = object2;
                object2 = dSAParameters.getP();
                BigInteger bigInteger = dSAParameters.getQ();
                BigInteger bigInteger2 = dSAParameters.getG();
                dSAParameter = new DSAParameter((BigInteger)object2, bigInteger, bigInteger2);
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, aSN1Object);
            aSN1Object = aSN1Integer;
            aSN1Integer = new ASN1Integer(((DSAPublicKeyParameters)object).getY());
            return new SubjectPublicKeyInfo(algorithmIdentifier, aSN1Object);
        }
        if (object instanceof ECPublicKeyParameters) {
            Object object3 = ((ECKeyParameters)(object = (ECPublicKeyParameters)object)).getParameters();
            if (object3 == null) {
                X962Parameters x962Parameters;
                object3 = x962Parameters;
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else {
                if (object3 instanceof ECGOST3410Parameters) {
                    DEROctetString dEROctetString;
                    AlgorithmIdentifier algorithmIdentifier;
                    SubjectPublicKeyInfo subjectPublicKeyInfo;
                    SubjectPublicKeyInfo subjectPublicKeyInfo2;
                    ASN1ObjectIdentifier aSN1ObjectIdentifier;
                    int n3;
                    int n4;
                    GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters;
                    AsymmetricKeyParameter asymmetricKeyParameter = object;
                    object = (ECGOST3410Parameters)object3;
                    object3 = ((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getAffineXCoord().toBigInteger();
                    BigInteger bigInteger = ((ECPublicKeyParameters)asymmetricKeyParameter).getQ().getAffineYCoord().toBigInteger();
                    GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters2 = gOST3410PublicKeyAlgParameters;
                    Object object4 = object;
                    ASN1ObjectIdentifier aSN1ObjectIdentifier2 = ((ECGOST3410Parameters)object4).getPublicKeyParamSet();
                    gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(aSN1ObjectIdentifier2, ((ECGOST3410Parameters)object4).getDigestParamSet());
                    if (cryptoProOids.contains(((ECGOST3410Parameters)object).getPublicKeyParamSet())) {
                        n4 = 64;
                        n3 = 32;
                        aSN1ObjectIdentifier = CryptoProObjectIdentifiers.gostR3410_2001;
                    } else if (((BigInteger)object3).bitLength() > 256) {
                        n4 = 128;
                        n3 = 64;
                        aSN1ObjectIdentifier = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_512;
                    } else {
                        n4 = 64;
                        n3 = 32;
                        aSN1ObjectIdentifier = RosstandartObjectIdentifiers.id_tc26_gost_3410_12_256;
                    }
                    byte[] byArray = new byte[n4];
                    SubjectPublicKeyInfoFactory.extractBytes(byArray, n4 /= 2, 0, (BigInteger)object3);
                    SubjectPublicKeyInfoFactory.extractBytes(byArray, n4, n3, bigInteger);
                    try {
                        SubjectPublicKeyInfo subjectPublicKeyInfo3;
                        subjectPublicKeyInfo2 = subjectPublicKeyInfo3;
                        subjectPublicKeyInfo = subjectPublicKeyInfo3;
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    AlgorithmIdentifier algorithmIdentifier3 = algorithmIdentifier;
                    algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier, gOST3410PublicKeyAlgParameters2);
                    object3 = dEROctetString;
                    dEROctetString = new DEROctetString(byArray);
                    subjectPublicKeyInfo2(algorithmIdentifier3, (ASN1Encodable)object3);
                    return subjectPublicKeyInfo;
                }
                if (object3 instanceof ECNamedDomainParameters) {
                    X962Parameters x962Parameters;
                    X962Parameters x962Parameters2 = x962Parameters;
                    x962Parameters = new X962Parameters(((ECNamedDomainParameters)object3).getName());
                    object3 = x962Parameters2;
                } else {
                    X962Parameters x962Parameters;
                    X9ECPoint x9ECPoint;
                    X9ECParameters x9ECParameters;
                    X9ECParameters x9ECParameters2 = x9ECParameters;
                    Object object5 = object3;
                    ECCurve eCCurve = ((ECDomainParameters)object5).getCurve();
                    X9ECPoint x9ECPoint2 = x9ECPoint;
                    x9ECPoint = new X9ECPoint(((ECDomainParameters)object3).getG(), false);
                    object3 = ((ECDomainParameters)object5).getN();
                    BigInteger bigInteger = ((ECDomainParameters)object5).getH();
                    byte[] byArray = ((ECDomainParameters)object5).getSeed();
                    x9ECParameters = new X9ECParameters(eCCurve, x9ECPoint2, (BigInteger)object3, bigInteger, byArray);
                    object3 = x962Parameters;
                    x962Parameters = new X962Parameters(x9ECParameters2);
                }
            }
            object = ((ECPublicKeyParameters)object).getQ().getEncoded(false);
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)object3), (byte[])object);
        }
        if (object instanceof X448PublicKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            object = (X448PublicKeyParameters)object;
            AsymmetricKeyParameter asymmetricKeyParameter = object;
            object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(EdECObjectIdentifiers.id_X448);
            return new SubjectPublicKeyInfo((AlgorithmIdentifier)object, ((X448PublicKeyParameters)asymmetricKeyParameter).getEncoded());
        }
        if (object instanceof X25519PublicKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            Object object6 = object = (X25519PublicKeyParameters)object;
            object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519);
            return new SubjectPublicKeyInfo((AlgorithmIdentifier)object, ((X25519PublicKeyParameters)object6).getEncoded());
        }
        if (object instanceof Ed448PublicKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            Object object7 = object = (Ed448PublicKeyParameters)object;
            object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed448);
            return new SubjectPublicKeyInfo((AlgorithmIdentifier)object, ((Ed448PublicKeyParameters)object7).getEncoded());
        }
        if (object instanceof Ed25519PublicKeyParameters) {
            AlgorithmIdentifier algorithmIdentifier;
            Object object8 = object = (Ed25519PublicKeyParameters)object;
            object = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519);
            return new SubjectPublicKeyInfo((AlgorithmIdentifier)object, ((Ed25519PublicKeyParameters)object8).getEncoded());
        }
        throw new IOException("key parameters not recognized");
    }

    private static void extractBytes(byte[] byArray, int n3, int n4, BigInteger object) {
        int n5;
        int n6;
        byte[] byArray2 = ((BigInteger)object).toByteArray();
        object = byArray2;
        if (byArray2.length < n3) {
            Object object2 = object;
            Object object3 = object;
            object = new byte[n3];
            n6 = n3 - ((Object)object3).length;
            n5 = ((Object)object2).length;
            System.arraycopy(object2, 0, object, n6, n5);
        }
        for (n6 = 0; n6 != n3; ++n6) {
            Object object4 = object;
            n5 = n4 + n6;
            byArray[n5] = (byte)object4[((Object)object4).length - 1 - n6];
        }
    }

    static {
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_B);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_C);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchA);
        cryptoProOids.add(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchB);
    }
}

