/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.io;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.io.InvalidCipherTextIOException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public class CipherInputStream
extends FilterInputStream {
    private final Cipher cipher;
    private final byte[] inputBuffer = new byte[512];
    private boolean finalized = false;
    private byte[] buf;
    private int maxBuf;
    private int bufOff;

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.cipher = cipher;
    }

    private int nextChunk() {
        int n3;
        if (this.finalized) {
            return -1;
        }
        CipherInputStream cipherInputStream = this;
        cipherInputStream.bufOff = 0;
        cipherInputStream.maxBuf = 0;
        while ((n3 = this.maxBuf) == 0) {
            n3 = this.in.read(this.inputBuffer);
            if (n3 == -1) {
                byte[] byArray = this.finaliseCipher();
                this.buf = byArray;
                if (byArray != null && byArray.length != 0) {
                    this.maxBuf = byArray.length;
                    return this.maxBuf;
                }
                return -1;
            }
            byte[] byArray = this.cipher.update(this.inputBuffer, 0, n3);
            this.buf = byArray;
            if (byArray == null) continue;
            this.maxBuf = byArray.length;
        }
        return n3;
    }

    private byte[] finaliseCipher() {
        block3: {
            try {
                if (this.finalized) break block3;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidCipherTextIOException("Error finalising cipher", generalSecurityException);
            }
            this.finalized = true;
            return this.cipher.doFinal();
        }
        return null;
    }

    @Override
    public int read() {
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        int n3 = this.bufOff;
        this.bufOff = n3 + 1;
        return this.buf[n3] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n3, int n4) {
        if (this.bufOff >= this.maxBuf && this.nextChunk() < 0) {
            return -1;
        }
        n4 = Math.min(n4, this.available());
        CipherInputStream cipherInputStream = this;
        System.arraycopy(cipherInputStream.buf, this.bufOff, byArray, n3, n4);
        cipherInputStream.bufOff += n4;
        return n4;
    }

    @Override
    public long skip(long l3) {
        if (l3 <= 0L) {
            return 0L;
        }
        int n3 = (int)Math.min(l3, (long)this.available());
        this.bufOff += n3;
        return n3;
    }

    @Override
    public int available() {
        return this.maxBuf - this.bufOff;
    }

    @Override
    public void close() {
        block3: {
            try {
                CipherInputStream cipherInputStream = this;
                cipherInputStream.in.close();
                if (cipherInputStream.finalized) break block3;
                this.finaliseCipher();
            }
            catch (Throwable throwable) {
                if (!this.finalized) {
                    this.finaliseCipher();
                }
                throw throwable;
            }
        }
        CipherInputStream cipherInputStream = this;
        cipherInputStream.bufOff = 0;
        cipherInputStream.maxBuf = 0;
    }

    @Override
    public void mark(int n3) {
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

