/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dh;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.DHParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.DomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.ValidationParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHValidationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dh.DHUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.DHDomainParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.DHExtendedPublicKeySpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class BCDHPublicKey
implements DHPublicKey {
    public static final long serialVersionUID = -216691575254424324L;
    private BigInteger y;
    private transient DHPublicKeyParameters dhPublicKey;
    private transient DHParameterSpec dhSpec;
    private transient SubjectPublicKeyInfo info;

    public BCDHPublicKey(DHPublicKeySpec object) {
        Serializable serializable;
        Object object2;
        Object object3;
        serializable.y = ((DHPublicKeySpec)object).getY();
        if (object instanceof DHExtendedPublicKeySpec) {
            serializable.dhSpec = ((DHExtendedPublicKeySpec)object).getParams();
        } else {
            DHParameterSpec dHParameterSpec;
            object3 = dHParameterSpec;
            DHPublicKeySpec dHPublicKeySpec = object;
            object2 = dHPublicKeySpec.getP();
            dHParameterSpec = new DHParameterSpec((BigInteger)object2, dHPublicKeySpec.getG());
            serializable.dhSpec = object3;
        }
        object3 = serializable.dhSpec;
        if (object3 instanceof DHDomainParameterSpec) {
            DHPublicKeyParameters dHPublicKeyParameters;
            BCDHPublicKey bCDHPublicKey = serializable;
            object = (DHDomainParameterSpec)object3;
            object3 = dHPublicKeyParameters;
            serializable = serializable.y;
            dHPublicKeyParameters = new DHPublicKeyParameters((BigInteger)serializable, ((DHDomainParameterSpec)object).getDomainParameters());
            bCDHPublicKey.dhPublicKey = object3;
        } else {
            DHParameters dHParameters;
            DHPublicKeyParameters dHPublicKeyParameters;
            BCDHPublicKey bCDHPublicKey = serializable;
            object3 = dHPublicKeyParameters;
            serializable = serializable.y;
            object2 = dHParameters;
            Object object4 = object;
            object = ((DHPublicKeySpec)object4).getP();
            dHParameters = new DHParameters((BigInteger)object, ((DHPublicKeySpec)object4).getG());
            dHPublicKeyParameters = new DHPublicKeyParameters((BigInteger)serializable, (DHParameters)object2);
            bCDHPublicKey.dhPublicKey = object3;
        }
    }

    public BCDHPublicKey(DHPublicKey object) {
        serializable.y = object.getY();
        object = object.getParams();
        serializable.dhSpec = object;
        if (object instanceof DHDomainParameterSpec) {
            DHPublicKeyParameters dHPublicKeyParameters;
            BCDHPublicKey bCDHPublicKey = serializable;
            object = (DHDomainParameterSpec)object;
            DHPublicKeyParameters dHPublicKeyParameters2 = dHPublicKeyParameters;
            Serializable serializable = serializable.y;
            dHPublicKeyParameters = new DHPublicKeyParameters((BigInteger)serializable, ((DHDomainParameterSpec)object).getDomainParameters());
            bCDHPublicKey.dhPublicKey = dHPublicKeyParameters2;
        } else {
            serializable.dhPublicKey = new DHPublicKeyParameters(serializable.y, new DHParameters(serializable.dhSpec.getP(), serializable.dhSpec.getG()));
        }
    }

    public BCDHPublicKey(DHPublicKeyParameters dHPublicKeyParameters) {
        BCDHPublicKey bCDHPublicKey = this;
        bCDHPublicKey.y = dHPublicKeyParameters.getY();
        bCDHPublicKey.dhSpec = new DHDomainParameterSpec(dHPublicKeyParameters.getParameters());
        this.dhPublicKey = dHPublicKeyParameters;
    }

    public BCDHPublicKey(BigInteger bigInteger, DHParameterSpec object) {
        ((BCDHPublicKey)((Object)dHPublicKeyParameters2)).y = bigInteger;
        ((BCDHPublicKey)((Object)dHPublicKeyParameters2)).dhSpec = object;
        if (object instanceof DHDomainParameterSpec) {
            ((BCDHPublicKey)((Object)dHPublicKeyParameters2)).dhPublicKey = new DHPublicKeyParameters(bigInteger, ((DHDomainParameterSpec)object).getDomainParameters());
        } else {
            DHParameters dHParameters;
            DHPublicKeyParameters dHPublicKeyParameters;
            BCDHPublicKey bCDHPublicKey = dHPublicKeyParameters2;
            DHPublicKeyParameters dHPublicKeyParameters2 = dHPublicKeyParameters;
            DHParameters dHParameters2 = dHParameters;
            DHParameterSpec dHParameterSpec = object;
            object = dHParameterSpec.getP();
            dHParameters = new DHParameters((BigInteger)object, dHParameterSpec.getG());
            dHPublicKeyParameters = new DHPublicKeyParameters(bigInteger, dHParameters2);
            bCDHPublicKey.dhPublicKey = dHPublicKeyParameters2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BCDHPublicKey(SubjectPublicKeyInfo object) {
        Object object2;
        void v02 = object2;
        this.info = object2;
        try {
            this.y = ((ASN1Integer)((SubjectPublicKeyInfo)object2).parsePublicKey()).getValue();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DH public key");
        }
        object2 = ASN1Sequence.getInstance(v02.getAlgorithm().getParameters());
        Object object3 = v02.getAlgorithm().getAlgorithm();
        if (!((ASN1Primitive)object3).equals(PKCSObjectIdentifiers.dhKeyAgreement) && !this.isPKCSParam((ASN1Sequence)object2)) {
            if (!((ASN1Primitive)object3).equals(X9ObjectIdentifiers.dhpublicnumber)) throw new IllegalArgumentException(a.a("unknown algorithm type: ", (ASN1ObjectIdentifier)object3));
            object3 = ((DomainParameters)(object2 = DomainParameters.getInstance(object2))).getValidationParams();
            if (object3 != null) {
                DHValidationParameters dHValidationParameters;
                Object object4 = object2;
                object2 = ((DomainParameters)object4).getP();
                BigInteger bigInteger = ((DomainParameters)object4).getG();
                BigInteger bigInteger2 = ((DomainParameters)object4).getQ();
                BigInteger bigInteger3 = ((DomainParameters)object4).getJ();
                Object object5 = object2;
                object2 = dHValidationParameters;
                dHValidationParameters = new DHValidationParameters(((ValidationParams)object3).getSeed(), ((ValidationParams)object3).getPgenCounter().intValue());
                this.dhPublicKey = new DHPublicKeyParameters(this.y, new DHParameters((BigInteger)object5, bigInteger, bigInteger2, bigInteger3, (DHValidationParameters)object2));
            } else {
                DHParameters dHParameters;
                DHPublicKeyParameters dHPublicKeyParameters;
                object3 = dHPublicKeyParameters;
                BigInteger bigInteger = this.y;
                DHParameters dHParameters2 = dHParameters;
                Object object6 = object2;
                object2 = ((DomainParameters)object6).getP();
                BigInteger bigInteger4 = ((DomainParameters)object6).getG();
                BigInteger bigInteger5 = ((DomainParameters)object6).getQ();
                BigInteger bigInteger6 = ((DomainParameters)object6).getJ();
                dHParameters = new DHParameters((BigInteger)object2, bigInteger4, bigInteger5, bigInteger6, null);
                dHPublicKeyParameters = new DHPublicKeyParameters(bigInteger, dHParameters2);
                this.dhPublicKey = object3;
            }
            this.dhSpec = new DHDomainParameterSpec(this.dhPublicKey.getParameters());
            return;
        } else if (((DHParameter)(object2 = DHParameter.getInstance(object2))).getL() != null) {
            BCDHPublicKey bCDHPublicKey = this;
            ASN1Object aSN1Object = object2;
            object3 = ((DHParameter)aSN1Object).getP();
            bCDHPublicKey.dhSpec = new DHParameterSpec((BigInteger)object3, ((DHParameter)aSN1Object).getG(), ((DHParameter)object2).getL().intValue());
            BCDHPublicKey bCDHPublicKey2 = this;
            BigInteger bigInteger = bCDHPublicKey2.dhSpec.getG();
            int n3 = bCDHPublicKey2.dhSpec.getL();
            bCDHPublicKey.dhPublicKey = new DHPublicKeyParameters(this.y, new DHParameters(this.dhSpec.getP(), bigInteger, null, n3));
            return;
        } else {
            BCDHPublicKey bCDHPublicKey = this;
            ASN1Object aSN1Object = object2;
            object2 = ((DHParameter)aSN1Object).getP();
            bCDHPublicKey.dhSpec = new DHParameterSpec((BigInteger)object2, ((DHParameter)aSN1Object).getG());
            bCDHPublicKey.dhPublicKey = new DHPublicKeyParameters(this.y, new DHParameters(this.dhSpec.getP(), this.dhSpec.getG()));
        }
    }

    private boolean isPKCSParam(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 2) {
            return true;
        }
        if (aSN1Sequence.size() > 3) {
            return false;
        }
        ASN1Sequence aSN1Sequence2 = aSN1Sequence;
        ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Sequence2.getObjectAt(2));
        return aSN1Integer.getValue().compareTo(BigInteger.valueOf(ASN1Integer.getInstance(aSN1Sequence2.getObjectAt(0)).getValue().bitLength())) <= 0;
    }

    private void readObject(ObjectInputStream object) {
        BCDHPublicKey bCDHPublicKey = serializable;
        ((ObjectInputStream)object).defaultReadObject();
        ObjectInputStream objectInputStream = object;
        Serializable serializable = (BigInteger)objectInputStream.readObject();
        object = (BigInteger)objectInputStream.readObject();
        int n3 = objectInputStream.readInt();
        bCDHPublicKey.dhSpec = new DHParameterSpec((BigInteger)serializable, (BigInteger)object, n3);
        bCDHPublicKey.info = null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.dhSpec.getP());
        objectOutputStream.writeObject(this.dhSpec.getG());
        objectOutputStream.writeInt(this.dhSpec.getL());
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        Object object = this.info;
        if (object != null) {
            return KeyUtil.getEncodedSubjectPublicKeyInfo((SubjectPublicKeyInfo)object);
        }
        object = this.dhSpec;
        if (object instanceof DHDomainParameterSpec && ((DHDomainParameterSpec)object).getQ() != null) {
            object = ((DHDomainParameterSpec)this.dhSpec).getDomainParameters();
            Object object2 = ((DHParameters)object).getValidationParameters();
            ValidationParams validationParams = null;
            if (object2 != null) {
                ValidationParams validationParams2;
                validationParams = validationParams2;
                DHValidationParameters dHValidationParameters = object2;
                object2 = dHValidationParameters.getSeed();
                validationParams2 = new ValidationParams((byte[])object2, dHValidationParameters.getCounter());
            }
            Object object3 = object;
            object = ((DHParameters)object3).getP();
            object2 = ((DHParameters)object3).getG();
            BigInteger bigInteger = ((DHParameters)object3).getQ();
            BigInteger bigInteger2 = ((DHParameters)object3).getJ();
            return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.dhpublicnumber, new DomainParameters((BigInteger)object, (BigInteger)object2, bigInteger, bigInteger2, validationParams).toASN1Primitive()), new ASN1Integer(this.y));
        }
        BCDHPublicKey bCDHPublicKey = this;
        object = bCDHPublicKey.dhSpec.getG();
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.dhKeyAgreement, new DHParameter(this.dhSpec.getP(), (BigInteger)object, bCDHPublicKey.dhSpec.getL()).toASN1Primitive()), new ASN1Integer(this.y));
    }

    public String toString() {
        DHParameters dHParameters;
        DHParameters dHParameters2 = dHParameters;
        dHParameters = new DHParameters(this.dhSpec.getP(), this.dhSpec.getG());
        return DHUtil.publicKeyToString("DH", this.y, dHParameters2);
    }

    @Override
    public DHParameterSpec getParams() {
        return this.dhSpec;
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    public DHPublicKeyParameters engineGetKeyParameters() {
        return this.dhPublicKey;
    }

    public int hashCode() {
        return this.getY().hashCode() ^ this.getParams().getG().hashCode() ^ this.getParams().getP().hashCode() ^ this.getParams().getL();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DHPublicKey)) {
            return false;
        }
        object = (DHPublicKey)object;
        return this.getY().equals(object.getY()) && this.getParams().getG().equals(object.getParams().getG()) && this.getParams().getP().equals(object.getParams().getP()) && this.getParams().getL() == object.getParams().getL();
    }
}

