/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dsa;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DSAParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.util.Enumeration;

public class BCDSAPrivateKey
implements DSAPrivateKey,
PKCS12BagAttributeCarrier {
    private static final long serialVersionUID = -4677259546958385734L;
    private BigInteger x;
    private transient DSAParams dsaSpec;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier;

    public BCDSAPrivateKey() {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        v1.attrCarrier = pKCS12BagAttributeCarrier;
    }

    public BCDSAPrivateKey(DSAPrivateKey dSAPrivateKey) {
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.x = dSAPrivateKey.getX();
        this.dsaSpec = dSAPrivateKey.getParams();
    }

    public BCDSAPrivateKey(DSAPrivateKeySpec object) {
        BCDSAPrivateKey bCDSAPrivateKey = serializable;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        bCDSAPrivateKey.x = ((DSAPrivateKeySpec)object).getX();
        DSAPrivateKeySpec dSAPrivateKeySpec = object;
        Serializable serializable = dSAPrivateKeySpec.getP();
        object = dSAPrivateKeySpec.getQ();
        BigInteger bigInteger = dSAPrivateKeySpec.getG();
        bCDSAPrivateKey.dsaSpec = new DSAParameterSpec((BigInteger)serializable, (BigInteger)object, bigInteger);
    }

    public BCDSAPrivateKey(PrivateKeyInfo object) {
        BCDSAPrivateKey bCDSAPrivateKey = object2;
        PrivateKeyInfo privateKeyInfo = object;
        ((BCDSAPrivateKey)object2).attrCarrier = new PKCS12BagAttributeCarrierImpl();
        Object object2 = DSAParameter.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        bCDSAPrivateKey.x = ((ASN1Integer)privateKeyInfo.parsePrivateKey()).getValue();
        Object object3 = object2;
        object2 = ((DSAParameter)object3).getP();
        object = ((DSAParameter)object3).getQ();
        BigInteger bigInteger = ((DSAParameter)object3).getG();
        bCDSAPrivateKey.dsaSpec = new DSAParameterSpec((BigInteger)object2, (BigInteger)object, bigInteger);
    }

    public BCDSAPrivateKey(DSAPrivateKeyParameters dSAPrivateKeyParameters) {
        BCDSAPrivateKey bCDSAPrivateKey = serializable;
        serializable.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        bCDSAPrivateKey.x = dSAPrivateKeyParameters.getX();
        DSAPrivateKeyParameters dSAPrivateKeyParameters2 = dSAPrivateKeyParameters;
        Serializable serializable = dSAPrivateKeyParameters2.getParameters().getQ();
        bCDSAPrivateKey.dsaSpec = new DSAParameterSpec(dSAPrivateKeyParameters.getParameters().getP(), (BigInteger)serializable, dSAPrivateKeyParameters2.getParameters().getG());
    }

    private void readObject(ObjectInputStream objectInputStream) {
        BCDSAPrivateKey bCDSAPrivateKey = serializable;
        objectInputStream.defaultReadObject();
        ObjectInputStream objectInputStream2 = objectInputStream;
        Serializable serializable = (BigInteger)objectInputStream2.readObject();
        bCDSAPrivateKey.dsaSpec = new DSAParameterSpec((BigInteger)objectInputStream.readObject(), (BigInteger)serializable, (BigInteger)objectInputStream2.readObject());
        bCDSAPrivateKey.attrCarrier = new PKCS12BagAttributeCarrierImpl();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.dsaSpec.getP());
        objectOutputStream.writeObject(this.dsaSpec.getQ());
        objectOutputStream.writeObject(this.dsaSpec.getG());
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        BCDSAPrivateKey bCDSAPrivateKey = this;
        BigInteger bigInteger = bCDSAPrivateKey.dsaSpec.getQ();
        return KeyUtil.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(this.dsaSpec.getP(), bigInteger, bCDSAPrivateKey.dsaSpec.getG()).toASN1Primitive()), new ASN1Integer(this.getX()));
    }

    @Override
    public DSAParams getParams() {
        return this.dsaSpec;
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DSAPrivateKey)) {
            return false;
        }
        object = (DSAPrivateKey)object;
        return this.getX().equals(object.getX()) && this.getParams().getG().equals(object.getParams().getG()) && this.getParams().getP().equals(object.getParams().getP()) && this.getParams().getQ().equals(object.getParams().getQ());
    }

    public int hashCode() {
        return this.getX().hashCode() ^ this.getParams().getG().hashCode() ^ this.getParams().getP().hashCode() ^ this.getParams().getQ().hashCode();
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Strings.lineSeparator();
        BigInteger bigInteger = this.getParams().getG().modPow(this.x, this.getParams().getP());
        stringBuffer.append("DSA Private Key [").append(DSAUtil.generateKeyFingerprint(bigInteger, this.getParams())).append("]").append(string2);
        stringBuffer.append("            Y: ").append(bigInteger.toString(16)).append(string2);
        return stringBuffer.toString();
    }
}

