/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dsa;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DSAParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPublicKeySpec;

public class BCDSAPublicKey
implements DSAPublicKey {
    private static final long serialVersionUID = 1752452449903495175L;
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private BigInteger y;
    private transient DSAPublicKeyParameters lwKeyParams;
    private transient DSAParams dsaSpec;

    public BCDSAPublicKey(DSAPublicKeySpec object) {
        BCDSAPublicKey bCDSAPublicKey = this;
        bCDSAPublicKey.y = ((DSAPublicKeySpec)object).getY();
        DSAPublicKeySpec dSAPublicKeySpec = object;
        object = dSAPublicKeySpec.getP();
        BigInteger bigInteger = dSAPublicKeySpec.getQ();
        BigInteger bigInteger2 = dSAPublicKeySpec.getG();
        bCDSAPublicKey.dsaSpec = new DSAParameterSpec((BigInteger)object, bigInteger, bigInteger2);
        bCDSAPublicKey.lwKeyParams = new DSAPublicKeyParameters(this.y, DSAUtil.toDSAParameters(this.dsaSpec));
    }

    public BCDSAPublicKey(DSAPublicKey dSAPublicKey) {
        BCDSAPublicKey bCDSAPublicKey = this;
        this.y = dSAPublicKey.getY();
        bCDSAPublicKey.dsaSpec = dSAPublicKey.getParams();
        bCDSAPublicKey.lwKeyParams = new DSAPublicKeyParameters(this.y, DSAUtil.toDSAParameters(this.dsaSpec));
    }

    public BCDSAPublicKey(DSAPublicKeyParameters dSAPublicKeyParameters) {
        BCDSAPublicKey bCDSAPublicKey = serializable;
        BCDSAPublicKey bCDSAPublicKey2 = serializable;
        bCDSAPublicKey2.y = dSAPublicKeyParameters.getY();
        DSAPublicKeyParameters dSAPublicKeyParameters2 = dSAPublicKeyParameters;
        Serializable serializable = dSAPublicKeyParameters2.getParameters().getQ();
        bCDSAPublicKey2.dsaSpec = new DSAParameterSpec(dSAPublicKeyParameters.getParameters().getP(), (BigInteger)serializable, dSAPublicKeyParameters2.getParameters().getG());
        bCDSAPublicKey.lwKeyParams = dSAPublicKeyParameters;
    }

    public BCDSAPublicKey(SubjectPublicKeyInfo object) {
        block3: {
            block2: {
                try {
                    this.y = ((ASN1Integer)((SubjectPublicKeyInfo)object).parsePublicKey()).getValue();
                    if (!this.isNotNull(((SubjectPublicKeyInfo)object).getAlgorithm().getParameters())) break block2;
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("invalid info structure in DSA public key");
                }
                object = DSAParameter.getInstance(((SubjectPublicKeyInfo)object).getAlgorithm().getParameters());
                ASN1Object aSN1Object = object;
                object = ((DSAParameter)aSN1Object).getP();
                BigInteger bigInteger = ((DSAParameter)aSN1Object).getQ();
                BigInteger bigInteger2 = ((DSAParameter)aSN1Object).getG();
                this.dsaSpec = new DSAParameterSpec((BigInteger)object, bigInteger, bigInteger2);
                break block3;
            }
            this.dsaSpec = null;
        }
        this.lwKeyParams = new DSAPublicKeyParameters(this.y, DSAUtil.toDSAParameters(this.dsaSpec));
    }

    private boolean isNotNull(ASN1Encodable aSN1Encodable) {
        return aSN1Encodable != null && !DERNull.INSTANCE.equals(aSN1Encodable.toASN1Primitive());
    }

    private void readObject(ObjectInputStream object) {
        ObjectInputStream objectInputStream = object;
        objectInputStream.defaultReadObject();
        BigInteger bigInteger = (BigInteger)objectInputStream.readObject();
        if (bigInteger.equals(ZERO)) {
            this.dsaSpec = null;
        } else {
            ObjectInputStream objectInputStream2 = object;
            object = (BigInteger)objectInputStream2.readObject();
            this.dsaSpec = new DSAParameterSpec(bigInteger, (BigInteger)object, (BigInteger)objectInputStream2.readObject());
        }
        this.lwKeyParams = new DSAPublicKeyParameters(this.y, DSAUtil.toDSAParameters(this.dsaSpec));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        DSAParams dSAParams = this.dsaSpec;
        if (dSAParams == null) {
            objectOutputStream.writeObject(ZERO);
        } else {
            objectOutputStream.writeObject(dSAParams.getP());
            objectOutputStream.writeObject(this.dsaSpec.getQ());
            objectOutputStream.writeObject(this.dsaSpec.getG());
        }
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    public DSAPublicKeyParameters engineGetKeyParameters() {
        return this.lwKeyParams;
    }

    @Override
    public byte[] getEncoded() {
        Object object = this.dsaSpec;
        if (object == null) {
            return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa), new ASN1Integer(this.y));
        }
        BigInteger bigInteger = object.getP();
        BCDSAPublicKey bCDSAPublicKey = this;
        object = bCDSAPublicKey.dsaSpec.getQ();
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(bigInteger, (BigInteger)object, bCDSAPublicKey.dsaSpec.getG()).toASN1Primitive()), new ASN1Integer(this.y));
    }

    @Override
    public DSAParams getParams() {
        return this.dsaSpec;
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Strings.lineSeparator();
        stringBuffer.append("DSA Public Key [").append(DSAUtil.generateKeyFingerprint(this.y, this.getParams())).append("]").append(string2);
        stringBuffer.append("            Y: ").append(this.getY().toString(16)).append(string2);
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this.dsaSpec != null) {
            return this.getY().hashCode() ^ this.getParams().getG().hashCode() ^ this.getParams().getP().hashCode() ^ this.getParams().getQ().hashCode();
        }
        return this.getY().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DSAPublicKey)) {
            return false;
        }
        object = (DSAPublicKey)object;
        if (this.dsaSpec != null) {
            return this.getY().equals(object.getY()) && object.getParams() != null && this.getParams().getG().equals(object.getParams().getG()) && this.getParams().getP().equals(object.getParams().getP()) && this.getParams().getQ().equals(object.getParams().getQ());
        }
        return this.getY().equals(object.getY()) && object.getParams() == null;
    }
}

