/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dsa;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dsa.BCDSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Fingerprint;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;

public class DSAUtil {
    public static final ASN1ObjectIdentifier[] dsaOids = new ASN1ObjectIdentifier[]{X9ObjectIdentifiers.id_dsa, OIWObjectIdentifiers.dsaWithSHA1, X9ObjectIdentifiers.id_dsa_with_sha1};

    public static boolean isDsaOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        int n3 = 0;
        while (true) {
            ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = dsaOids;
            if (n3 == dsaOids.length) break;
            if (aSN1ObjectIdentifier.equals(aSN1ObjectIdentifierArray[n3])) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static DSAParameters toDSAParameters(DSAParams object) {
        if (object != null) {
            DSAParams dSAParams = object;
            object = dSAParams.getP();
            BigInteger bigInteger = dSAParams.getQ();
            BigInteger bigInteger2 = dSAParams.getG();
            return new DSAParameters((BigInteger)object, bigInteger, bigInteger2);
        }
        return null;
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) {
        byte[] byArray;
        if (publicKey instanceof BCDSAPublicKey) {
            return ((BCDSAPublicKey)publicKey).engineGetKeyParameters();
        }
        if (publicKey instanceof DSAPublicKey) {
            return new BCDSAPublicKey((DSAPublicKey)publicKey).engineGetKeyParameters();
        }
        try {
            byArray = publicKey.getEncoded();
        }
        catch (Exception exception) {
            throw new InvalidKeyException(b.a("can't identify DSA public key: ").append(publicKey.getClass().getName()).toString());
        }
        return new BCDSAPublicKey(SubjectPublicKeyInfo.getInstance(byArray)).engineGetKeyParameters();
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey serializable) {
        if (serializable instanceof DSAPrivateKey) {
            serializable = (DSAPrivateKey)serializable;
            BigInteger bigInteger = serializable.getX();
            BigInteger bigInteger2 = serializable.getParams().getP();
            PrivateKey privateKey = serializable;
            serializable = privateKey.getParams().getQ();
            return new DSAPrivateKeyParameters(bigInteger, new DSAParameters(bigInteger2, (BigInteger)serializable, privateKey.getParams().getG()));
        }
        throw new InvalidKeyException("can't identify DSA private key.");
    }

    public static String generateKeyFingerprint(BigInteger object, DSAParams dSAParams) {
        byte[] byArray = ((BigInteger)object).toByteArray();
        DSAParams dSAParams2 = dSAParams;
        object = dSAParams2.getQ().toByteArray();
        return new Fingerprint(Arrays.concatenate(byArray, dSAParams.getP().toByteArray(), (byte[])object, dSAParams2.getG().toByteArray())).toString();
    }
}

