/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dstu;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ua.DSTU4145Params;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GOST3411Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSTU4145Signer;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.dstu.BCDSTU4145PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECKey;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends java.security.SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private DSAExt signer;

    public SignatureSpi() {
        DSTU4145Signer dSTU4145Signer;
        DSTU4145Signer dSTU4145Signer2 = dSTU4145Signer;
        dSTU4145Signer = new DSTU4145Signer();
        v1.signer = dSTU4145Signer2;
    }

    @Override
    public void engineInitVerify(PublicKey publicKey) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (publicKey instanceof BCDSTU4145PublicKey) {
            publicKey = (BCDSTU4145PublicKey)publicKey;
            asymmetricKeyParameter = ((BCDSTU4145PublicKey)publicKey).engineGetKeyParameters();
            this.digest = new GOST3411Digest(this.expandSbox(((BCDSTU4145PublicKey)publicKey).getSbox()));
        } else {
            asymmetricKeyParameter = ECUtil.generatePublicKeyParameter(publicKey);
            this.digest = new GOST3411Digest(this.expandSbox(DSTU4145Params.getDefaultDKE()));
        }
        this.signer.init(false, asymmetricKeyParameter);
    }

    public byte[] expandSbox(byte[] byArray) {
        Object object = new byte[128];
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            int n3 = i3;
            int n4 = n3 * 2;
            object[n4] = (byte)(byArray[n3] >> 4 & 0xF);
            object[++n4] = (byte)(byArray[i3] & 0xF);
        }
        return object;
    }

    @Override
    public void engineInitSign(PrivateKey serializable) {
        AsymmetricKeyParameter asymmetricKeyParameter = null;
        if (serializable instanceof BCDSTU4145PrivateKey) {
            asymmetricKeyParameter = ECUtil.generatePrivateKeyParameter(serializable);
            ((SignatureSpi)((Object)parametersWithRandom2)).digest = new GOST3411Digest(((SignatureSpi)((Object)parametersWithRandom2)).expandSbox(DSTU4145Params.getDefaultDKE()));
        } else if (serializable instanceof ECKey) {
            asymmetricKeyParameter = ECUtil.generatePrivateKeyParameter(serializable);
            ((SignatureSpi)((Object)parametersWithRandom2)).digest = new GOST3411Digest(((SignatureSpi)((Object)parametersWithRandom2)).expandSbox(DSTU4145Params.getDefaultDKE()));
        }
        serializable = ((java.security.SignatureSpi)((Object)parametersWithRandom2)).appRandom;
        if (serializable != null) {
            ParametersWithRandom parametersWithRandom;
            ParametersWithRandom parametersWithRandom2 = parametersWithRandom;
            parametersWithRandom = new ParametersWithRandom(asymmetricKeyParameter, (SecureRandom)serializable);
            ((SignatureSpi)((Object)parametersWithRandom2)).signer.init(true, parametersWithRandom2);
        } else {
            ((SignatureSpi)((Object)parametersWithRandom2)).signer.init(true, asymmetricKeyParameter);
        }
    }

    @Override
    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n3, int n4) {
        this.digest.update(byArray, n3, n4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] engineSign() {
        int n3;
        int n4;
        Object object;
        Object object2;
        int n5;
        SignatureSpi signatureSpi = object3;
        Object object3 = new byte[signatureSpi.digest.getDigestSize()];
        signatureSpi.digest.doFinal((byte[])object3, 0);
        try {
            BigInteger[] bigIntegerArray = signatureSpi.signer.generateSignature((byte[])object3);
            object3 = bigIntegerArray[0].toByteArray();
            byte[] byArray = bigIntegerArray[1].toByteArray();
            n5 = (((Object)object3).length > byArray.length ? ((Object)object3).length : byArray.length) * 2;
            Object object4 = object3;
            object2 = object4;
            object = object4;
            int n6 = n5;
            Object object5 = object3;
            int n7 = n5;
            object3 = new byte[n7];
            n5 = 0;
            n4 = n7 / 2 - byArray.length;
            n3 = byArray.length;
            System.arraycopy(byArray, n5, object3, n4, n3);
            n4 = 0;
            n5 = n6 - ((Object)object5).length;
        }
        catch (Exception exception) {
            throw new SignatureException(((Object)exception).toString());
        }
        n3 = ((Object)object2).length;
        System.arraycopy(object, n4, object3, n5, n3);
        return new DEROctetString((byte[])object3).getEncoded();
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        BigInteger bigInteger;
        SignatureSpi signatureSpi = object;
        SignatureSpi signatureSpi2 = object;
        Object object = new byte[signatureSpi2.digest.getDigestSize()];
        signatureSpi2.digest.doFinal((byte[])object, 0);
        try {
            byArray = ((ASN1OctetString)ASN1Primitive.fromByteArray(byArray)).getOctets();
        }
        catch (Exception exception) {
            throw new SignatureException("error decoding signature bytes.");
        }
        Object object2 = new byte[byArray.length / 2];
        byte[] byArray2 = new byte[byArray.length / 2];
        int n3 = 0;
        System.arraycopy(byArray, 0, byArray2, n3, byArray.length / 2);
        int n4 = byArray.length / 2;
        int n5 = 0;
        System.arraycopy(byArray, n4, object2, n5, byArray.length / 2);
        BigInteger[] bigIntegerArray = new BigInteger[2];
        BigInteger[] bigIntegerArray2 = bigIntegerArray;
        bigIntegerArray[0] = new BigInteger(1, (byte[])object2);
        object2 = bigInteger;
        bigInteger = new BigInteger(1, byArray2);
        bigIntegerArray[1] = bigInteger;
        return signatureSpi.signer.verifySignature((byte[])object, bigIntegerArray2[0], (BigInteger)object2);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    public void engineSetParameter(String string2, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string2) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }
}

