/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9IntegerConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPointEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Properties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;

public class BCECPublicKey
implements ECPublicKey,
com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey,
ECPointEncoder {
    public static final long serialVersionUID = 2422789860422731812L;
    private String algorithm;
    private boolean withCompression;
    private transient ECPublicKeyParameters ecPublicKey;
    private transient ECParameterSpec ecSpec;
    private transient ProviderConfiguration configuration;

    public BCECPublicKey(String string2, BCECPublicKey bCECPublicKey) {
        this.algorithm = string2;
        this.ecPublicKey = bCECPublicKey.ecPublicKey;
        this.ecSpec = bCECPublicKey.ecSpec;
        this.withCompression = bCECPublicKey.withCompression;
        this.configuration = bCECPublicKey.configuration;
    }

    public BCECPublicKey(String string2, ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        BCECPublicKey bCECPublicKey = object;
        BCECPublicKey bCECPublicKey2 = object;
        ((BCECPublicKey)object).algorithm = string2;
        Object object = eCPublicKeySpec.getParams();
        bCECPublicKey2.ecSpec = object;
        object = EC5Util.convertPoint((ECParameterSpec)object, eCPublicKeySpec.getW());
        bCECPublicKey2.ecPublicKey = new ECPublicKeyParameters((ECPoint)object, EC5Util.getDomainParameters(providerConfiguration, eCPublicKeySpec.getParams()));
        bCECPublicKey.configuration = providerConfiguration;
    }

    public BCECPublicKey(String object, com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec eCPublicKeySpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = object;
        if (eCPublicKeySpec.getParams() != null) {
            com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPublicKeySpec eCPublicKeySpec2 = eCPublicKeySpec;
            object = eCPublicKeySpec2.getQ();
            this.ecPublicKey = new ECPublicKeyParameters((ECPoint)object, ECUtil.getDomainParameters(providerConfiguration, eCPublicKeySpec2.getParams()));
            this.ecSpec = EC5Util.convertSpec(EC5Util.convertCurve(eCPublicKeySpec.getParams().getCurve(), eCPublicKeySpec.getParams().getSeed()), eCPublicKeySpec.getParams());
        } else {
            BCECPublicKey bCECPublicKey = this;
            object = providerConfiguration.getEcImplicitlyCa();
            object = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object).getCurve().createPoint(eCPublicKeySpec.getQ().getAffineXCoord().toBigInteger(), eCPublicKeySpec.getQ().getAffineYCoord().toBigInteger());
            bCECPublicKey.ecPublicKey = new ECPublicKeyParameters((ECPoint)object, EC5Util.getDomainParameters(providerConfiguration, null));
            bCECPublicKey.ecSpec = null;
        }
        this.configuration = providerConfiguration;
    }

    public BCECPublicKey(String string2, ECPublicKeyParameters eCPublicKeyParameters, ECParameterSpec eCParameterSpec, ProviderConfiguration providerConfiguration) {
        BCECPublicKey bCECPublicKey = this;
        this.algorithm = "EC";
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        bCECPublicKey.algorithm = string2;
        bCECPublicKey.ecPublicKey = eCPublicKeyParameters;
        this.ecSpec = eCParameterSpec == null ? this.createSpec(EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed()), eCDomainParameters) : eCParameterSpec;
        this.configuration = providerConfiguration;
    }

    public BCECPublicKey(String string2, ECPublicKeyParameters eCPublicKeyParameters, com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec, ProviderConfiguration providerConfiguration) {
        this.algorithm = "EC";
        ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
        this.algorithm = string2;
        this.ecSpec = eCParameterSpec == null ? this.createSpec(EC5Util.convertCurve(eCDomainParameters.getCurve(), eCDomainParameters.getSeed()), eCDomainParameters) : EC5Util.convertSpec(EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed()), eCParameterSpec);
        BCECPublicKey bCECPublicKey = this;
        bCECPublicKey.ecPublicKey = eCPublicKeyParameters;
        bCECPublicKey.configuration = providerConfiguration;
    }

    public BCECPublicKey(String string2, ECPublicKeyParameters eCPublicKeyParameters, ProviderConfiguration providerConfiguration) {
        this.algorithm = string2;
        this.ecPublicKey = eCPublicKeyParameters;
        this.ecSpec = null;
        this.configuration = providerConfiguration;
    }

    public BCECPublicKey(ECPublicKey eCPublicKey, ProviderConfiguration providerConfiguration) {
        BCECPublicKey bCECPublicKey = object;
        BCECPublicKey bCECPublicKey2 = object;
        ((BCECPublicKey)object).algorithm = "EC";
        ((BCECPublicKey)object).algorithm = eCPublicKey.getAlgorithm();
        Object object = eCPublicKey.getParams();
        bCECPublicKey2.ecSpec = object;
        object = EC5Util.convertPoint((ECParameterSpec)object, eCPublicKey.getW());
        bCECPublicKey2.ecPublicKey = new ECPublicKeyParameters((ECPoint)object, EC5Util.getDomainParameters(providerConfiguration, eCPublicKey.getParams()));
        bCECPublicKey.configuration = providerConfiguration;
    }

    public BCECPublicKey(String string2, SubjectPublicKeyInfo subjectPublicKeyInfo, ProviderConfiguration providerConfiguration) {
        BCECPublicKey bCECPublicKey = this;
        bCECPublicKey.algorithm = string2;
        bCECPublicKey.configuration = providerConfiguration;
        bCECPublicKey.populateFromPubKeyInfo(subjectPublicKeyInfo);
    }

    private ECParameterSpec createSpec(EllipticCurve object, ECDomainParameters eCDomainParameters) {
        EllipticCurve ellipticCurve = object;
        ECDomainParameters eCDomainParameters2 = eCDomainParameters;
        java.security.spec.ECPoint eCPoint = EC5Util.convertPoint(eCDomainParameters2.getG());
        object = eCDomainParameters2.getN();
        int n3 = eCDomainParameters2.getH().intValue();
        return new ECParameterSpec(ellipticCurve, eCPoint, (BigInteger)object, n3);
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo aSN1Object) {
        X9ECPoint x9ECPoint;
        byte by;
        DEROctetString dEROctetString;
        SubjectPublicKeyInfo subjectPublicKeyInfo = aSN1Object;
        aSN1Object = X962Parameters.getInstance(aSN1Object.getAlgorithm().getParameters());
        ECCurve eCCurve = EC5Util.getCurve(this.configuration, (X962Parameters)aSN1Object);
        this.ecSpec = EC5Util.convertToSpec((X962Parameters)aSN1Object, eCCurve);
        Object object = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        ASN1OctetString aSN1OctetString = dEROctetString;
        dEROctetString = new DEROctetString((byte[])object);
        if (object[0] == 4 && object[1] == ((byte[])object).length - 2 && ((by = object[2]) == 2 || by == 3) && new X9IntegerConverter().getByteLength(eCCurve) >= ((Object)object).length - 3) {
            try {
                aSN1OctetString = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])object);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
        }
        object = x9ECPoint;
        x9ECPoint = new X9ECPoint(eCCurve, aSN1OctetString);
        this.ecPublicKey = new ECPublicKeyParameters(((X9ECPoint)object).getPoint(), ECUtil.getDomainParameters(this.configuration, (X962Parameters)aSN1Object));
    }

    private void readObject(ObjectInputStream objectInputStream) {
        BCECPublicKey bCECPublicKey = object;
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        Object object = (byte[])objectInputStream2.readObject();
        bCECPublicKey.configuration = BouncyCastleProvider.CONFIGURATION;
        bCECPublicKey.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray((byte[])object)));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        boolean bl = this.withCompression || Properties.isOverrideSet("com.fis.ekyc.nfc.build_in.bouncycastle.ec.enable_pc");
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, ECUtils.getDomainParametersFromName(this.ecSpec, bl)), this.ecPublicKey.getQ().getEncoded(bl));
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        ECParameterSpec eCParameterSpec = ((BCECPublicKey)((Object)eCParameterSpec)).ecSpec;
        if (eCParameterSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(eCParameterSpec);
    }

    @Override
    public java.security.spec.ECPoint getW() {
        return EC5Util.convertPoint(this.ecPublicKey.getQ());
    }

    @Override
    public ECPoint getQ() {
        BCECPublicKey bCECPublicKey = eCPoint;
        ECPoint eCPoint = bCECPublicKey.ecPublicKey.getQ();
        if (bCECPublicKey.ecSpec == null) {
            return eCPoint.getDetachedPoint();
        }
        return eCPoint;
    }

    public ECPublicKeyParameters engineGetKeyParameters() {
        return this.ecPublicKey;
    }

    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        ECParameterSpec eCParameterSpec = this.ecSpec;
        if (eCParameterSpec != null) {
            return EC5Util.convertSpec(eCParameterSpec);
        }
        return this.configuration.getEcImplicitlyCa();
    }

    public String toString() {
        BCECPublicKey bCECPublicKey = eCPoint;
        ECPoint eCPoint = bCECPublicKey.ecPublicKey.getQ();
        com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = bCECPublicKey.engineGetSpec();
        return ECUtil.publicKeyToString("EC", eCPoint, eCParameterSpec);
    }

    @Override
    public void setPointFormat(String string2) {
        this.withCompression = "UNCOMPRESSED".equalsIgnoreCase(string2) ^ true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECPublicKey)) {
            return false;
        }
        object = (BCECPublicKey)object;
        return this.ecPublicKey.getQ().equals(((BCECPublicKey)object).ecPublicKey.getQ()) && this.engineGetSpec().equals(((BCECPublicKey)object).engineGetSpec());
    }

    public int hashCode() {
        return this.ecPublicKey.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }
}

