/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.ECUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.Hashtable;

public abstract class KeyPairGeneratorSpi
extends KeyPairGenerator {
    public KeyPairGeneratorSpi(String string2) {
        super(string2);
    }

    public static class ECMQV
    extends EC {
        public ECMQV() {
            super("ECMQV", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class EC
    extends KeyPairGeneratorSpi {
        private static Hashtable ecParameters = new Hashtable<Integer, ECGenParameterSpec>();
        public ECKeyGenerationParameters param;
        public ECKeyPairGenerator engine = new ECKeyPairGenerator();
        public Object ecParams = null;
        public int strength = 239;
        public SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
        public boolean initialised = false;
        public String algorithm;
        public ProviderConfiguration configuration;

        public EC() {
            super("EC");
            this.algorithm = "EC";
            this.configuration = BouncyCastleProvider.CONFIGURATION;
        }

        public EC(String string2, ProviderConfiguration providerConfiguration) {
            super(string2);
            this.algorithm = string2;
            this.configuration = providerConfiguration;
        }

        static {
            ecParameters.put(Integers.valueOf(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(Integers.valueOf(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(Integers.valueOf(256), new ECGenParameterSpec("prime256v1"));
            ecParameters.put(Integers.valueOf(224), new ECGenParameterSpec("P-224"));
            ecParameters.put(Integers.valueOf(384), new ECGenParameterSpec("P-384"));
            ecParameters.put(Integers.valueOf(521), new ECGenParameterSpec("P-521"));
        }

        @Override
        public void initialize(int n3, SecureRandom secureRandom) {
            this.strength = n3;
            this.random = secureRandom;
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)ecParameters.get(Integers.valueOf(n3));
            if (eCGenParameterSpec != null) {
                try {
                    this.initialize(eCGenParameterSpec, secureRandom);
                    return;
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            }
            throw new InvalidParameterException("unknown key size.");
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
            block9: {
                block4: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block2: {
                                        block3: {
                                            if (algorithmParameterSpec != null) break block2;
                                            algorithmParameterSpec = this.configuration.getEcImplicitlyCa();
                                            if (algorithmParameterSpec == null) break block3;
                                            this.ecParams = null;
                                            this.param = this.createKeyGenParamsBC((ECParameterSpec)algorithmParameterSpec, secureRandom);
                                            break block4;
                                        }
                                        throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                                    }
                                    if (!(algorithmParameterSpec instanceof ECParameterSpec)) break block5;
                                    this.ecParams = algorithmParameterSpec;
                                    this.param = this.createKeyGenParamsBC((ECParameterSpec)algorithmParameterSpec, secureRandom);
                                    break block4;
                                }
                                if (!(algorithmParameterSpec instanceof java.security.spec.ECParameterSpec)) break block6;
                                this.ecParams = algorithmParameterSpec;
                                this.param = this.createKeyGenParamsJCE((java.security.spec.ECParameterSpec)algorithmParameterSpec, secureRandom);
                                break block4;
                            }
                            if (!(algorithmParameterSpec instanceof ECGenParameterSpec)) break block7;
                            this.initializeNamedCurve(((ECGenParameterSpec)algorithmParameterSpec).getName(), secureRandom);
                            break block4;
                        }
                        if (!(algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec)) break block8;
                        this.initializeNamedCurve(((ECNamedCurveGenParameterSpec)algorithmParameterSpec).getName(), secureRandom);
                        break block4;
                    }
                    String string2 = ECUtil.getNameFrom(algorithmParameterSpec);
                    if (string2 == null) break block9;
                    this.initializeNamedCurve(string2, secureRandom);
                }
                this.engine.init(this.param);
                this.initialised = true;
                return;
            }
            throw new InvalidAlgorithmParameterException("invalid parameterSpec: " + algorithmParameterSpec);
        }

        @Override
        public KeyPair generateKeyPair() {
            BCECPrivateKey bCECPrivateKey;
            BCECPublicKey bCECPublicKey;
            Object object;
            Object object2;
            if (!((EC)object).initialised) {
                SecureRandom secureRandom;
                EC eC = object;
                int n3 = eC.strength;
                object2 = secureRandom;
                secureRandom = new SecureRandom();
                eC.initialize(n3, (SecureRandom)object2);
            }
            EC eC = object;
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = eC.engine.generateKeyPair();
            Object object3 = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            object2 = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            Object object4 = eC.ecParams;
            if (object4 instanceof ECParameterSpec) {
                BCECPrivateKey bCECPrivateKey2;
                BCECPublicKey bCECPublicKey2;
                object4 = (ECParameterSpec)object4;
                BCECPublicKey bCECPublicKey3 = bCECPublicKey2;
                EC eC2 = object;
                Object object5 = eC2.algorithm;
                ProviderConfiguration providerConfiguration = eC2.configuration;
                bCECPublicKey2 = new BCECPublicKey((String)object5, (ECPublicKeyParameters)object3, (ECParameterSpec)object4, providerConfiguration);
                object3 = bCECPrivateKey2;
                EC eC3 = object;
                object = eC3.algorithm;
                object5 = eC3.configuration;
                bCECPrivateKey2 = new BCECPrivateKey((String)object, (ECPrivateKeyParameters)object2, bCECPublicKey3, (ECParameterSpec)object4, (ProviderConfiguration)object5);
                return new KeyPair(bCECPublicKey3, (PrivateKey)object3);
            }
            if (object4 == null) {
                BCECPrivateKey bCECPrivateKey3;
                BCECPublicKey bCECPublicKey4;
                object4 = bCECPublicKey4;
                EC eC4 = object;
                Object object6 = eC4.algorithm;
                ProviderConfiguration providerConfiguration = eC4.configuration;
                bCECPublicKey4 = new BCECPublicKey((String)object6, (ECPublicKeyParameters)object3, providerConfiguration);
                object3 = bCECPrivateKey3;
                EC eC5 = object;
                object = eC5.algorithm;
                object6 = eC5.configuration;
                bCECPrivateKey3 = new BCECPrivateKey((String)object, (ECPrivateKeyParameters)object2, (ProviderConfiguration)object6);
                return new KeyPair((PublicKey)object4, (PrivateKey)object3);
            }
            object4 = (java.security.spec.ECParameterSpec)object4;
            BCECPublicKey bCECPublicKey5 = bCECPublicKey;
            EC eC6 = object;
            Object object7 = eC6.algorithm;
            ProviderConfiguration providerConfiguration = eC6.configuration;
            bCECPublicKey = new BCECPublicKey((String)object7, (ECPublicKeyParameters)object3, (java.security.spec.ECParameterSpec)object4, providerConfiguration);
            object3 = bCECPrivateKey;
            Object object8 = object;
            object = ((EC)object8).algorithm;
            object7 = ((EC)object8).configuration;
            bCECPrivateKey = new BCECPrivateKey((String)object, (ECPrivateKeyParameters)object2, bCECPublicKey5, (java.security.spec.ECParameterSpec)object4, (ProviderConfiguration)object7);
            return new KeyPair(bCECPublicKey5, (PrivateKey)object3);
        }

        public ECKeyGenerationParameters createKeyGenParamsBC(ECParameterSpec object, SecureRandom secureRandom) {
            ECDomainParameters eCDomainParameters;
            ECDomainParameters eCDomainParameters2 = eCDomainParameters;
            ECParameterSpec eCParameterSpec = object;
            object = eCParameterSpec.getCurve();
            ECPoint eCPoint = eCParameterSpec.getG();
            BigInteger bigInteger = eCParameterSpec.getN();
            BigInteger bigInteger2 = eCParameterSpec.getH();
            eCDomainParameters = new ECDomainParameters((ECCurve)object, eCPoint, bigInteger, bigInteger2);
            return new ECKeyGenerationParameters(eCDomainParameters2, secureRandom);
        }

        public ECKeyGenerationParameters createKeyGenParamsJCE(java.security.spec.ECParameterSpec object, SecureRandom secureRandom) {
            ECDomainParameters eCDomainParameters;
            Object object2;
            if (object instanceof ECNamedCurveSpec && (object2 = ECUtils.getDomainParametersFromName(((ECNamedCurveSpec)object).getName())) != null) {
                ECDomainParameters eCDomainParameters2;
                object = eCDomainParameters2;
                Object object3 = object2;
                object2 = ((X9ECParameters)object3).getCurve();
                ECPoint eCPoint = ((X9ECParameters)object3).getG();
                BigInteger bigInteger = ((X9ECParameters)object3).getN();
                BigInteger bigInteger2 = ((X9ECParameters)object3).getH();
                eCDomainParameters2 = new ECDomainParameters((ECCurve)object2, eCPoint, bigInteger, bigInteger2);
                return new ECKeyGenerationParameters((ECDomainParameters)object, secureRandom);
            }
            java.security.spec.ECParameterSpec eCParameterSpec = object;
            object2 = EC5Util.convertCurve(eCParameterSpec.getCurve());
            object = EC5Util.convertPoint((ECCurve)object2, ((java.security.spec.ECParameterSpec)object).getGenerator());
            BigInteger bigInteger = eCParameterSpec.getOrder();
            BigInteger bigInteger3 = BigInteger.valueOf(eCParameterSpec.getCofactor());
            ECDomainParameters eCDomainParameters3 = eCDomainParameters;
            eCDomainParameters = new ECDomainParameters((ECCurve)object2, (ECPoint)object, bigInteger, bigInteger3);
            return new ECKeyGenerationParameters(eCDomainParameters3, secureRandom);
        }

        public ECNamedCurveSpec createNamedCurveSpec(String string2) {
            Object object;
            block5: {
                object = ECUtils.getDomainParametersFromName(string2);
                if (object == null) {
                    try {
                        object = ECNamedCurveTable.getByOID(new ASN1ObjectIdentifier(string2));
                        if (object != null) break block5;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new InvalidAlgorithmParameterException(i.a("unknown curve name: ", string2));
                    }
                    object = (X9ECParameters)((EC)((Object)eCCurve)).configuration.getAdditionalECParameters().get(new ASN1ObjectIdentifier(string2));
                    if (object != null) break block5;
                    throw new InvalidAlgorithmParameterException("unknown curve OID: " + string2);
                }
            }
            X9ECParameters x9ECParameters = object;
            ECCurve eCCurve = x9ECParameters.getCurve();
            object = x9ECParameters.getG();
            BigInteger bigInteger = x9ECParameters.getN();
            BigInteger bigInteger2 = x9ECParameters.getH();
            return new ECNamedCurveSpec(string2, eCCurve, (ECPoint)object, bigInteger, bigInteger2, null);
        }

        public void initializeNamedCurve(String string2, SecureRandom secureRandom) {
            EC eC = this;
            eC.ecParams = this = eC.createNamedCurveSpec(string2);
            eC.param = eC.createKeyGenParamsJCE((java.security.spec.ECParameterSpec)this, secureRandom);
        }
    }
}

