/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ecgost;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X962Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.ECGOST3410NamedCurveTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPointEncoder;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECPrivateKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;

public class BCECGOST3410PrivateKey
implements java.security.interfaces.ECPrivateKey,
ECPrivateKey,
PKCS12BagAttributeCarrier,
ECPointEncoder {
    public static final long serialVersionUID = 7245981689601667138L;
    private String algorithm;
    private boolean withCompression;
    private transient ASN1Encodable gostParams;
    private transient BigInteger d;
    private transient ECParameterSpec ecSpec;
    private transient DERBitString publicKey;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier;

    public BCECGOST3410PrivateKey() {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrier.algorithm = "ECGOST3410";
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        v1.attrCarrier = pKCS12BagAttributeCarrier;
    }

    public BCECGOST3410PrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey) {
        this.algorithm = "ECGOST3410";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.d = eCPrivateKey.getS();
        this.algorithm = eCPrivateKey.getAlgorithm();
        this.ecSpec = eCPrivateKey.getParams();
    }

    public BCECGOST3410PrivateKey(ECPrivateKeySpec eCPrivateKeySpec) {
        this.algorithm = "ECGOST3410";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.d = eCPrivateKeySpec.getD();
        this.ecSpec = eCPrivateKeySpec.getParams() != null ? EC5Util.convertSpec(EC5Util.convertCurve(eCPrivateKeySpec.getParams().getCurve(), eCPrivateKeySpec.getParams().getSeed()), eCPrivateKeySpec.getParams()) : null;
    }

    public BCECGOST3410PrivateKey(java.security.spec.ECPrivateKeySpec eCPrivateKeySpec) {
        this.algorithm = "ECGOST3410";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.d = eCPrivateKeySpec.getS();
        this.ecSpec = eCPrivateKeySpec.getParams();
    }

    public BCECGOST3410PrivateKey(BCECGOST3410PrivateKey bCECGOST3410PrivateKey) {
        this.algorithm = "ECGOST3410";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.d = bCECGOST3410PrivateKey.d;
        this.ecSpec = bCECGOST3410PrivateKey.ecSpec;
        this.withCompression = bCECGOST3410PrivateKey.withCompression;
        this.attrCarrier = bCECGOST3410PrivateKey.attrCarrier;
        this.publicKey = bCECGOST3410PrivateKey.publicKey;
        this.gostParams = bCECGOST3410PrivateKey.gostParams;
    }

    public BCECGOST3410PrivateKey(String object, ECPrivateKeyParameters object2, BCECGOST3410PublicKey bCECGOST3410PublicKey, ECParameterSpec eCParameterSpec) {
        this.algorithm = "ECGOST3410";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = object;
        this.d = ((ECPrivateKeyParameters)object2).getD();
        if (eCParameterSpec == null) {
            object = ((ECKeyParameters)object2).getParameters();
            Object object3 = object2 = EC5Util.convertCurve(((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getSeed());
            Object object4 = object;
            object = EC5Util.convertPoint(((ECDomainParameters)object4).getG());
            object2 = ((ECDomainParameters)object4).getN();
            int n3 = ((ECDomainParameters)object4).getH().intValue();
            this.ecSpec = new ECParameterSpec((EllipticCurve)object3, (java.security.spec.ECPoint)object, (BigInteger)object2, n3);
        } else {
            this.ecSpec = eCParameterSpec;
        }
        this.gostParams = bCECGOST3410PublicKey.getGostParams();
        this.publicKey = this.getPublicKeyDetails(bCECGOST3410PublicKey);
    }

    public BCECGOST3410PrivateKey(String object, ECPrivateKeyParameters object2, BCECGOST3410PublicKey bCECGOST3410PublicKey, com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec) {
        this.algorithm = "ECGOST3410";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = object;
        this.d = ((ECPrivateKeyParameters)object2).getD();
        if (eCParameterSpec == null) {
            object = ((ECKeyParameters)object2).getParameters();
            Object object3 = object2 = EC5Util.convertCurve(((ECDomainParameters)object).getCurve(), ((ECDomainParameters)object).getSeed());
            Object object4 = object;
            object = EC5Util.convertPoint(((ECDomainParameters)object4).getG());
            object2 = ((ECDomainParameters)object4).getN();
            int n3 = ((ECDomainParameters)object4).getH().intValue();
            this.ecSpec = new ECParameterSpec((EllipticCurve)object3, (java.security.spec.ECPoint)object, (BigInteger)object2, n3);
        } else {
            Object object5 = object = EC5Util.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getSeed());
            com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec2 = eCParameterSpec;
            object = EC5Util.convertPoint(eCParameterSpec2.getG());
            object2 = eCParameterSpec2.getN();
            int n4 = eCParameterSpec2.getH().intValue();
            this.ecSpec = new ECParameterSpec((EllipticCurve)object5, (java.security.spec.ECPoint)object, (BigInteger)object2, n4);
        }
        this.gostParams = bCECGOST3410PublicKey.getGostParams();
        this.publicKey = this.getPublicKeyDetails(bCECGOST3410PublicKey);
    }

    public BCECGOST3410PrivateKey(String string2, ECPrivateKeyParameters eCPrivateKeyParameters) {
        BCECGOST3410PrivateKey bCECGOST3410PrivateKey = this;
        this.algorithm = "ECGOST3410";
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.algorithm = string2;
        bCECGOST3410PrivateKey.d = eCPrivateKeyParameters.getD();
        bCECGOST3410PrivateKey.ecSpec = null;
    }

    public BCECGOST3410PrivateKey(PrivateKeyInfo privateKeyInfo) {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        BCECGOST3410PrivateKey bCECGOST3410PrivateKey = pKCS12BagAttributeCarrier;
        bCECGOST3410PrivateKey.algorithm = "ECGOST3410";
        PKCS12BagAttributeCarrier pKCS12BagAttributeCarrier = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        bCECGOST3410PrivateKey.attrCarrier = pKCS12BagAttributeCarrier;
        bCECGOST3410PrivateKey.populateFromPrivKeyInfo(privateKeyInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateFromPrivKeyInfo(PrivateKeyInfo object) {
        Object object2;
        Object object3 = ((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getParameters();
        Object object4 = object3.toASN1Primitive();
        if (object4 instanceof ASN1Sequence && (ASN1Sequence.getInstance(object4).size() == 2 || ASN1Sequence.getInstance(object4).size() == 3)) {
            Object object5 = object;
            BCECGOST3410PrivateKey bCECGOST3410PrivateKey = object2;
            object = GOST3410PublicKeyAlgParameters.getInstance(object3);
            bCECGOST3410PrivateKey.gostParams = object;
            object3 = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(((GOST3410PublicKeyAlgParameters)object).getPublicKeyParamSet()));
            object4 = EC5Util.convertCurve(((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object3).getCurve(), ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object3).getSeed());
            Object object6 = object3;
            object = ECGOST3410NamedCurves.getName(((GOST3410PublicKeyAlgParameters)object).getPublicKeyParamSet());
            object3 = EC5Util.convertPoint(((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object6).getG());
            BigInteger bigInteger = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object6).getN();
            BigInteger bigInteger2 = ((com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec)object6).getH();
            bCECGOST3410PrivateKey.ecSpec = new ECNamedCurveSpec((String)object, (EllipticCurve)object4, (java.security.spec.ECPoint)object3, bigInteger, bigInteger2);
            object = ((PrivateKeyInfo)object5).parsePrivateKey();
            if (object instanceof ASN1Integer) {
                ((BCECGOST3410PrivateKey)object2).d = ASN1Integer.getInstance(object).getPositiveValue();
                return;
            } else {
                BigInteger bigInteger3;
                byte[] byArray = ASN1OctetString.getInstance(object).getOctets();
                object = byArray;
                object3 = new byte[byArray.length];
                for (int i3 = 0; i3 != ((Object)object).length; ++i3) {
                    Object object7 = object;
                    object3[i3] = object7[((Object)object7).length - 1 - i3];
                }
                Object object8 = object2;
                object2 = bigInteger3;
                bigInteger3 = new BigInteger(1, (byte[])object3);
                ((BCECGOST3410PrivateKey)object8).d = object2;
            }
            return;
        } else {
            if (((X962Parameters)(object3 = X962Parameters.getInstance(object3))).isNamedCurve()) {
                object4 = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)(object3 = ASN1ObjectIdentifier.getInstance(((X962Parameters)object3).getParameters())));
                if (object4 == null) throw new IllegalStateException();
                object3 = ECUtil.getCurveName((ASN1ObjectIdentifier)object3);
                EllipticCurve ellipticCurve = EC5Util.convertCurve(((X9ECParameters)object4).getCurve(), ((X9ECParameters)object4).getSeed());
                Object object9 = object3;
                Object object10 = object4;
                object3 = EC5Util.convertPoint(((X9ECParameters)object10).getG());
                object4 = ((X9ECParameters)object10).getN();
                BigInteger bigInteger = ((X9ECParameters)object10).getH();
                ((BCECGOST3410PrivateKey)object2).ecSpec = new ECNamedCurveSpec((String)object9, ellipticCurve, (java.security.spec.ECPoint)object3, (BigInteger)object4, bigInteger);
            } else if (((X962Parameters)object3).isImplicitlyCA()) {
                ((BCECGOST3410PrivateKey)object2).ecSpec = null;
            } else {
                object3 = X9ECParameters.getInstance(((X962Parameters)object3).getParameters());
                Object object11 = object4 = EC5Util.convertCurve(((X9ECParameters)object3).getCurve(), ((X9ECParameters)object3).getSeed());
                Object object12 = object3;
                object3 = EC5Util.convertPoint(((X9ECParameters)object12).getG());
                object4 = ((X9ECParameters)object12).getN();
                int n3 = ((X9ECParameters)object12).getH().intValue();
                ((BCECGOST3410PrivateKey)object2).ecSpec = new ECParameterSpec((EllipticCurve)object11, (java.security.spec.ECPoint)object3, (BigInteger)object4, n3);
            }
            object = ((PrivateKeyInfo)object).parsePrivateKey();
            if (object instanceof ASN1Integer) {
                ((BCECGOST3410PrivateKey)object2).d = ASN1Integer.getInstance(object).getValue();
                return;
            } else {
                BCECGOST3410PrivateKey bCECGOST3410PrivateKey = object2;
                object2 = com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey.getInstance(object);
                bCECGOST3410PrivateKey.d = ((com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey)object2).getKey();
                bCECGOST3410PrivateKey.publicKey = ((com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey)object2).getPublicKey();
            }
        }
    }

    private void extractBytes(byte[] byArray, int n3, BigInteger bigInteger) {
        int n4;
        byte[] byArray2 = bigInteger.toByteArray();
        Object object = byArray2;
        if (byArray2.length < 32) {
            Object object2 = object;
            object = new byte[32];
            int n5 = 32 - ((Object)object2).length;
            n4 = ((Object)object2).length;
            System.arraycopy(object2, 0, object, n5, n4);
        }
        for (int i3 = 0; i3 != 32; ++i3) {
            Object object3 = object;
            n4 = n3 + i3;
            byArray[n4] = (byte)object3[((Object)object3).length - 1 - i3];
        }
    }

    private DERBitString getPublicKeyDetails(BCECGOST3410PublicKey bCECGOST3410PublicKey) {
        try {
            return SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(bCECGOST3410PublicKey.getEncoded())).getPublicKeyData();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        ObjectInputStream objectInputStream2 = objectInputStream;
        objectInputStream2.defaultReadObject();
        this.populateFromPrivKeyInfo(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray((byte[])objectInputStream2.readObject())));
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        AlgorithmIdentifier algorithmIdentifier;
        ASN1Object aSN1Object;
        PrivateKeyInfo privateKeyInfo;
        PrivateKeyInfo privateKeyInfo2;
        Object object;
        ASN1Object aSN1Object2;
        int n3;
        Object object2;
        Object object3;
        if (((BCECGOST3410PrivateKey)object3).gostParams != null) {
            DEROctetString dEROctetString;
            BCECGOST3410PrivateKey bCECGOST3410PrivateKey;
            AlgorithmIdentifier algorithmIdentifier2;
            AlgorithmIdentifier algorithmIdentifier3;
            PrivateKeyInfo privateKeyInfo3;
            PrivateKeyInfo privateKeyInfo4;
            BCECGOST3410PrivateKey bCECGOST3410PrivateKey2 = object3;
            byte[] byArray = new byte[32];
            BigInteger bigInteger = bCECGOST3410PrivateKey2.getS();
            bCECGOST3410PrivateKey2.extractBytes(byArray, 0, bigInteger);
            try {
                AlgorithmIdentifier algorithmIdentifier4;
                PrivateKeyInfo privateKeyInfo5;
                privateKeyInfo4 = privateKeyInfo5;
                privateKeyInfo3 = privateKeyInfo5;
                algorithmIdentifier3 = algorithmIdentifier4;
                algorithmIdentifier2 = algorithmIdentifier4;
                bCECGOST3410PrivateKey = object3;
                object3 = CryptoProObjectIdentifiers.gostR3410_2001;
            }
            catch (IOException iOException) {
                return null;
            }
            algorithmIdentifier3((ASN1ObjectIdentifier)object3, bCECGOST3410PrivateKey.gostParams);
            object3 = dEROctetString;
            dEROctetString = new DEROctetString(byArray);
            privateKeyInfo4(algorithmIdentifier2, (ASN1Encodable)object3);
            return privateKeyInfo3.getEncoded("DER");
        }
        Object object4 = ((BCECGOST3410PrivateKey)object3).ecSpec;
        if (object4 instanceof ECNamedCurveSpec) {
            X962Parameters x962Parameters;
            if ((object4 = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)object4).getName())) == null) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier;
                object4 = aSN1ObjectIdentifier;
                aSN1ObjectIdentifier = new ASN1ObjectIdentifier(((ECNamedCurveSpec)((BCECGOST3410PrivateKey)object3).ecSpec).getName());
            }
            object2 = x962Parameters;
            x962Parameters = new X962Parameters((ASN1ObjectIdentifier)object4);
            Object object5 = object3;
            object4 = ((BCECGOST3410PrivateKey)object5).ecSpec.getOrder();
            n3 = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, (BigInteger)object4, ((BCECGOST3410PrivateKey)object5).getS());
        } else if (object4 == null) {
            X962Parameters x962Parameters;
            object2 = x962Parameters;
            x962Parameters = new X962Parameters(DERNull.INSTANCE);
            n3 = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, null, ((BCECGOST3410PrivateKey)object3).getS());
        } else {
            X962Parameters x962Parameters;
            X9ECPoint x9ECPoint;
            X9ECParameters x9ECParameters;
            object4 = EC5Util.convertCurve(((ECParameterSpec)object4).getCurve());
            Object object6 = x9ECParameters;
            Object object7 = object4;
            BCECGOST3410PrivateKey bCECGOST3410PrivateKey = object3;
            aSN1Object2 = x9ECPoint;
            object4 = EC5Util.convertPoint((ECCurve)object4, ((BCECGOST3410PrivateKey)object3).ecSpec.getGenerator());
            x9ECPoint = new X9ECPoint((ECPoint)object4, ((BCECGOST3410PrivateKey)object3).withCompression);
            object4 = bCECGOST3410PrivateKey.ecSpec.getOrder();
            object = BigInteger.valueOf(bCECGOST3410PrivateKey.ecSpec.getCofactor());
            byte[] byArray = bCECGOST3410PrivateKey.ecSpec.getCurve().getSeed();
            x9ECParameters = new X9ECParameters((ECCurve)object7, (X9ECPoint)aSN1Object2, (BigInteger)object4, (BigInteger)object, byArray);
            object4 = x962Parameters;
            x962Parameters = new X962Parameters((X9ECParameters)object6);
            Object object8 = object3;
            object6 = ((BCECGOST3410PrivateKey)object8).ecSpec.getOrder();
            int n4 = ECUtil.getOrderBitLength(BouncyCastleProvider.CONFIGURATION, (BigInteger)object6, ((BCECGOST3410PrivateKey)object8).getS());
            object2 = object4;
            n3 = n4;
        }
        if (((BCECGOST3410PrivateKey)object3).publicKey != null) {
            com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey;
            aSN1Object2 = eCPrivateKey;
            Object object9 = object3;
            object3 = ((BCECGOST3410PrivateKey)object9).getS();
            object = ((BCECGOST3410PrivateKey)object9).publicKey;
            eCPrivateKey = new com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey(n3, (BigInteger)object3, (DERBitString)object, (ASN1Encodable)object2);
        } else {
            com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey eCPrivateKey;
            aSN1Object2 = eCPrivateKey;
            eCPrivateKey = new com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey(n3, ((BCECGOST3410PrivateKey)object3).getS(), (ASN1Encodable)object2);
        }
        try {
            PrivateKeyInfo privateKeyInfo6;
            privateKeyInfo2 = privateKeyInfo6;
            privateKeyInfo = privateKeyInfo6;
            aSN1Object = aSN1Object2;
        }
        catch (IOException iOException) {
            return null;
        }
        object3 = algorithmIdentifier;
        X962Parameters x962Parameters = object2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = CryptoProObjectIdentifiers.gostR3410_2001;
        algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier, x962Parameters.toASN1Primitive());
        privateKeyInfo2((AlgorithmIdentifier)object3, ((com.fis.ekyc.nfc.build_in.bouncycastle.asn1.sec.ECPrivateKey)aSN1Object).toASN1Primitive());
        return privateKeyInfo.getEncoded("DER");
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec getParameters() {
        ECParameterSpec eCParameterSpec = ((BCECGOST3410PrivateKey)((Object)eCParameterSpec)).ecSpec;
        if (eCParameterSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(eCParameterSpec);
    }

    public com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        ECParameterSpec eCParameterSpec = ((BCECGOST3410PrivateKey)((Object)eCParameterSpec)).ecSpec;
        if (eCParameterSpec != null) {
            return EC5Util.convertSpec(eCParameterSpec);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    @Override
    public BigInteger getS() {
        return this.d;
    }

    @Override
    public BigInteger getD() {
        return this.d;
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    @Override
    public void setPointFormat(String string2) {
        this.withCompression = "UNCOMPRESSED".equalsIgnoreCase(string2) ^ true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCECGOST3410PrivateKey)) {
            return false;
        }
        object = (BCECGOST3410PrivateKey)object;
        return this.getD().equals(((BCECGOST3410PrivateKey)object).getD()) && this.engineGetSpec().equals(((BCECGOST3410PrivateKey)object).engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        BCECGOST3410PrivateKey bCECGOST3410PrivateKey = serializable;
        Serializable serializable = bCECGOST3410PrivateKey.d;
        return ECUtil.privateKeyToString(serializable.algorithm, (BigInteger)serializable, bCECGOST3410PrivateKey.engineGetSpec());
    }
}

